/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils.browser;

import com.jaspersoft.studio.editor.preview.view.report.html.ABrowserViewer;
import com.jaspersoft.studio.utils.Callback;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.HttpUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.viewer.BrowserUtils;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BrowserInfo {
    public static void initUserAgent(JasperReportsConfiguration c) {
        String userAgent = c.getProperty("com.jaspersoft.studio.server.user-agent");
        if (!Misc.isNullOrEmpty((String)userAgent)) {
            HttpUtils.USER_AGENT_JASPERSOFT_STUDIO = userAgent;
        }
        c.getPrefStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("com.jaspersoft.studio.server.user-agent")) {
                    String ua = (String)event.getNewValue();
                    HttpUtils.USER_AGENT_JASPERSOFT_STUDIO = !Misc.isNullOrEmpty((String)ua) ? ua : "JaspersoftStudio";
                }
            }
        });
    }

    public static String getUserAgent() {
        return HttpUtils.USER_AGENT_JASPERSOFT_STUDIO;
    }

    public static void findUserAgent(final Callback<String> callback) {
        int port = SocketUtil.findFreePort();
        Server server = new Server(new InetSocketAddress("localhost", port));
        try {
            try {
                server.setHandler((Handler)new AbstractHandler(){

                    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                        response.setContentType("text/html");
                        response.setStatus(200);
                        String ua = baseRequest.getHeader("User-Agent");
                        response.getWriter().println(ua);
                        UIUtils.getDisplay().asyncExec(() -> callback.completed(ua));
                        baseRequest.setHandled(true);
                    }
                });
                server.start();
                UIUtils.getDisplay().syncExec(() -> BrowserInfo.runBrowser("http://localhost:" + port + "/index.html"));
            }
            catch (Exception e) {
                throw new JRRuntimeException((Throwable)e);
            }
        }
        finally {
            try {
                Thread.sleep(10000L);
                server.stop();
                server.destroy();
            }
            catch (Exception e) {
                UIUtils.showError((Throwable)e);
            }
        }
    }

    protected static void runBrowser(final String url) {
        Dialog d = new Dialog(UIUtils.getShell()){

            protected Control createDialogArea(Composite parent) {
                try {
                    BrowserUtils.getSWTBrowserWidget((Composite)parent, (int)0).setUrl(url);
                    UIUtils.getDisplay().asyncExec(() -> this.close());
                }
                catch (Throwable throwable) {
                    UIUtils.getDisplay().syncExec(() -> {
                        if (ABrowserViewer.useExternalBrowser()) {
                            BrowserUtils.openExternalBrowser((String)url);
                        } else {
                            BrowserUtils.openLink((String)url);
                        }
                    });
                }
                return super.createDialogArea(parent);
            }
        };
        d.open();
    }
}

