/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils.expr;

import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import org.apache.commons.lang.LocaleUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public abstract class AInterpreter {
    protected IJavaProject javaProject;
    protected JRDesignDataset dataset;
    protected JasperDesign jasperDesign;
    protected JasperReportsConfiguration jConfig;
    protected ClassLoader classLoader;
    private Set<String> literals = new HashSet<String>();
    private boolean convertNullParams = false;
    private ResourceBundle rb;
    private String bundleName;
    private Locale locale;

    public void prepareExpressionEvaluator(JRDesignDataset dataset, JasperDesign jasperDesign, JasperReportsConfiguration jConfig) throws Exception {
        this.dataset = dataset;
        this.jasperDesign = jasperDesign;
        this.jConfig = jConfig;
        try {
            IProject project;
            IFile file = (IFile)jConfig.get("ifile");
            if (file != null && (project = file.getProject()).getNature("org.eclipse.jdt.core.javanature") != null) {
                this.javaProject = JavaCore.create((IProject)project);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.classLoader = jConfig.getClassLoader();
        if (this.classLoader == null) {
            this.classLoader = jasperDesign != null ? jasperDesign.getClass().getClassLoader() : Thread.currentThread().getContextClassLoader();
        }
    }

    protected abstract Object eval(String var1) throws Exception;

    protected abstract void set(String var1, Object var2) throws Exception;

    protected abstract Object get(String var1) throws Exception;

    public Object interpretExpression(String expression) {
        try {
            if (this.dataset != null) {
                expression = this.prepareExpression(expression, 0);
            }
            return this.eval(expression);
        }
        catch (Throwable e) {
            System.out.println("Expression: " + expression);
            e.printStackTrace();
            return null;
        }
    }

    protected String prepareExpression(String expression, int recursion) throws Exception {
        String pnameLiteral;
        String pname;
        while (expression.indexOf("$P{") >= 0) {
            pname = Misc.extract((String)expression, (String)"$P{", (String)"}");
            JRParameter pr = null;
            pr = (JRParameter)this.dataset.getParametersMap().get(pname);
            if (pr == null) {
                throw new JRException("Paramater $P{" + pname + "} does not exists in the dataset");
            }
            pnameLiteral = this.getLiteral(pname);
            expression = Misc.strReplace((String)pnameLiteral, (String)("$P{" + pname + "}"), (String)expression);
            if (this.literals.contains(pnameLiteral)) continue;
            this.recursiveInterpreter(recursion, pr);
        }
        while (expression.indexOf("$V{") >= 0) {
            String vname = Misc.extract((String)expression, (String)"$V{", (String)"}");
            JRVariable vr = null;
            vr = (JRVariable)this.dataset.getVariablesMap().get(vname);
            if (vr == null) {
                throw new JRException("Variable $V{" + vname + "} does not exists in the dataset");
            }
            pnameLiteral = this.getVariableLiteral(vname);
            expression = Misc.strReplace((String)pnameLiteral, (String)("$V{" + vname + "}"), (String)expression);
            if (this.literals.contains(pnameLiteral)) continue;
            this.recursiveInterpreter(recursion, vr);
        }
        while (expression.indexOf("$F{") >= 0) {
            String fname = Misc.extract((String)expression, (String)"$F{", (String)"}");
            expression = Misc.strReplace((String)"(null)", (String)("$F{" + fname + "}"), (String)expression);
        }
        while (expression.indexOf("$R{") >= 0) {
            ResourceBundle rb;
            pname = Misc.extract((String)expression, (String)"$R{", (String)"}");
            String baseName = this.getBundleName();
            if (!baseName.isEmpty() && (rb = this.getResourceBundle()) != null) {
                baseName = Misc.nvl((String)rb.getString(pname));
            }
            expression = Misc.strReplace((String)("\"" + baseName + "\""), (String)("$R{" + pname + "}"), (String)expression);
        }
        return expression;
    }

    protected Object recursiveInterpreter(int recursion, JRParameter prm) throws Exception {
        ++recursion;
        String pliteral = this.getLiteral(prm.getName());
        if (this.literals.contains(pliteral)) {
            return this.get(pliteral);
        }
        Map<String, Object> pmap = this.jConfig.getJRParameters();
        if (pmap.containsKey(prm.getName())) {
            return this.setValue(pmap.get(prm.getName()), pliteral);
        }
        if (prm.getName().equals("JASPER_REPORTS_CONTEXT")) {
            return this.setValue((Object)this.jConfig, pliteral);
        }
        JRExpression exp = prm.getDefaultValueExpression();
        if (recursion > 100 || exp == null || Misc.isNullOrEmpty((String)exp.getText())) {
            return this.getNull(pliteral, prm);
        }
        return this.setValue(this.eval(this.prepareExpression(exp.getText(), recursion)), pliteral);
    }

    protected Object recursiveInterpreter(int recursion, JRVariable vrb) throws Exception {
        ++recursion;
        String pliteral = this.getVariableLiteral(vrb.getName());
        if (this.literals.contains(pliteral)) {
            return this.get(pliteral);
        }
        JRExpression exp = vrb.getInitialValueExpression();
        if (recursion > 100 || exp == null || Misc.isNullOrEmpty((String)exp.getText())) {
            if (vrb.getValueClass().equals(String.class)) {
                return this.setValue("", pliteral);
            }
            return this.setValue(null, pliteral);
        }
        return this.setValue(this.eval(this.prepareExpression(exp.getText(), recursion)), pliteral);
    }

    private Object getNull(String pliteral, JRParameter prm) throws Exception {
        if (this.isConvertNullParams() && prm.getValueClass().equals(String.class)) {
            return this.setValue("", pliteral);
        }
        return this.setValue(null, pliteral);
    }

    private Object setValue(Object v, String literal) throws Exception {
        this.set(literal, v);
        this.literals.add(literal);
        return v;
    }

    private String getLiteral(String pname) {
        return "param_" + JRStringUtil.escapeJavaStringLiteral((String)pname).replace(".", "_");
    }

    private String getVariableLiteral(String vname) {
        return "var_" + JRStringUtil.escapeJavaStringLiteral((String)vname).replace(".", "_");
    }

    public boolean isConvertNullParams() {
        return this.convertNullParams;
    }

    public void setConvertNullParams(boolean convertNullParams) {
        this.convertNullParams = convertNullParams;
    }

    protected ResourceBundle getResourceBundle() {
        if (this.rb == null) {
            this.rb = JRResourcesUtil.loadResourceBundle((JasperReportsContext)this.jConfig, (String)this.getBundleName(), (Locale)this.getLocale());
        }
        return this.rb;
    }

    protected String getBundleName() {
        if (this.bundleName != null) {
            return this.bundleName;
        }
        this.bundleName = this.dataset.getResourceBundle();
        if (this.bundleName == null) {
            this.bundleName = this.jasperDesign.getMainDataset().getResourceBundle();
        }
        if (Misc.isNullOrEmpty((String)this.bundleName)) {
            this.bundleName = "";
        }
        return this.bundleName;
    }

    protected Locale getLocale() {
        String str;
        if (this.locale != null) {
            return this.locale;
        }
        this.locale = Locale.getDefault();
        Object obj = null;
        if (this.jConfig.getJRParameters() != null && (obj = this.jConfig.getJRParameters().get("REPORT_LOCALE")) == null && (str = this.jConfig.getProperty("net.sf.jasperreports.default.locale")) != null) {
            obj = LocaleUtils.toLocale((String)str);
        }
        if (obj != null && obj instanceof Locale) {
            this.locale = (Locale)obj;
        }
        return this.locale;
    }
}

