/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils.expr;

import com.jaspersoft.studio.utils.expr.AInterpreter;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class GroovyInterpretter
extends AInterpreter {
    private GroovyShell interpreter;

    @Override
    public void prepareExpressionEvaluator(JRDesignDataset dataset, JasperDesign jasperDesign, JasperReportsConfiguration jConfig) throws Exception {
        super.prepareExpressionEvaluator(dataset, jasperDesign, jConfig);
        ImportCustomizer ic = new ImportCustomizer();
        ic.addStarImports(new String[]{"import net.sf.jasperreports.engine.*;"});
        ic.addStarImports(new String[]{"import net.sf.jasperreports.engine.fill.*;"});
        ic.addStarImports(new String[]{"import java.util.*;"});
        ic.addStarImports(new String[]{"import java.math.*;"});
        ic.addStarImports(new String[]{"import java.text.*;"});
        ic.addStarImports(new String[]{"import java.io.*;"});
        ic.addStarImports(new String[]{"import java.net.*;"});
        ic.addStarImports(new String[]{"import java.util.*;"});
        ic.addStarImports(new String[]{"import java.sql.*;"});
        ic.addStarImports(new String[]{"import net.sf.jasperreports.engine.data.*;"});
        if (jasperDesign != null) {
            String[] imports = jasperDesign.getImports();
            int i = 0;
            while (imports != null && i < imports.length) {
                String importString = imports[i];
                if (importString.startsWith("static ")) {
                    ic.addStaticStars(new String[]{"static import " + imports[i].substring("static ".length()) + ";"});
                } else {
                    ic.addStarImports(new String[]{"import " + imports[i] + ";"});
                }
                ++i;
            }
        }
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.addCompilationCustomizers(new CompilationCustomizer[]{ic});
        Binding binding = new Binding();
        this.interpreter = this.classLoader != null ? new GroovyShell(this.classLoader, binding, cc) : new GroovyShell(cc);
    }

    @Override
    public Object interpretExpression(String expression) {
        if (this.interpreter == null) {
            return null;
        }
        return super.interpretExpression(expression);
    }

    @Override
    protected Object eval(String expression) throws Exception {
        return this.interpreter.evaluate(expression);
    }

    @Override
    protected void set(String key, Object val) throws Exception {
        this.interpreter.setVariable(key, val);
    }

    @Override
    protected Object get(String key) throws Exception {
        return this.interpreter.getVariable(key);
    }
}

