/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils.jasper;

import com.jaspersoft.studio.utils.jasper.IDriverProvider;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.eclipse.classpath.JavaProjectClassLoader;
import net.sf.jasperreports.engine.util.CompositeClassloader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class DriversManager {
    private static List<IDriverProvider> nodeFactory;
    private ClassLoader parent;
    private URLClassLoader classloader;

    public void init() {
        if (nodeFactory == null) {
            IConfigurationElement[] config;
            nodeFactory = new ArrayList<IDriverProvider>();
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.jaspersoft.studio", "drivers");
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    Object o = e.createExecutableExtension("ClassFactory");
                    if (o instanceof IDriverProvider) {
                        nodeFactory.add((IDriverProvider)o);
                    }
                }
                catch (CoreException ex) {
                    System.out.println(ex.getMessage());
                }
                ++n2;
            }
        }
    }

    private URL[] getDriversURL() {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (IDriverProvider f : nodeFactory) {
            urls.addAll(Arrays.asList(f.getDriversURL()));
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public ClassLoader getClassLoader(ClassLoader cl) {
        URL[] urls;
        if (this.parent != cl) {
            JavaProjectClassLoader.clean((URLClassLoader)this.classloader);
            this.classloader = null;
        }
        if (this.classloader == null && (urls = this.getDriversURL()) != null && urls.length > 0) {
            this.classloader = new URLClassLoader(urls);
        }
        if (this.classloader == null) {
            return cl;
        }
        return new CompositeClassloader(cl, (ClassLoader)this.classloader);
    }
}

