/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.manager.panel;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.WItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.WidgetFactory;
import com.jaspersoft.studio.widgets.framework.manager.panel.IPanelManager;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BasePanelManager
implements IPanelManager {
    protected static final String LABEL_KEY = "widgetLabel";
    protected List<WItemProperty> properties = new ArrayList<WItemProperty>();
    protected Composite parent;

    public BasePanelManager(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(2, false));
    }

    @Override
    public IWItemProperty createWidget(WidgetPropertyDescriptor widgetDesc, ItemPropertyDescription<?> widget, IPropertyEditor editor, ExpressionContext ec) {
        Label label = WidgetFactory.createLabelForProperty(this.parent, widgetDesc);
        label.setLayoutData((Object)new GridData());
        WItemProperty widgetEditor = new WItemProperty(this.parent, 0, widget, editor);
        widgetEditor.setLayoutData(new GridData(768));
        widgetEditor.setExpressionContext(ec);
        widgetEditor.setData(LABEL_KEY, label);
        this.properties.add(widgetEditor);
        return widgetEditor;
    }

    @Override
    public void disposeWidgets() {
        this.properties.clear();
        Control[] controlArray = this.parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    @Override
    public void updateWidgets() {
        for (IWItemProperty iWItemProperty : this.properties) {
            iWItemProperty.updateWidget();
        }
    }

    @Override
    public List<IWItemProperty> getWidgets() {
        return new ArrayList<IWItemProperty>(this.properties);
    }

    @Override
    public List<String> validateWidgets(boolean stopToFirst) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (WItemProperty property : this.properties) {
            List<String> validationResult = property.isValueValid();
            if (validationResult == null || validationResult.isEmpty()) continue;
            errorMessages.addAll(validationResult);
            if (stopToFirst) break;
        }
        return errorMessages;
    }
}

