/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.AbstractExpressionPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.IDialogProvider;
import java.io.IOException;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractMeasurePropertyDescription<T>
extends AbstractExpressionPropertyDescription<T>
implements IDialogProvider {
    protected static final String POPUP_KEY = "measureUnitMenu";
    public static final String CURRENT_MEASURE_KEY = "_measureUnit";
    protected static final String FOCUS_KEY = "focusListener";
    protected Color defaultBackgroundColor = null;
    protected Number min;
    protected Number max;

    public AbstractMeasurePropertyDescription() {
    }

    public AbstractMeasurePropertyDescription(String name, String label, String description, boolean mandatory, T defaultValue, long min, long max) {
        super(name, label, description, mandatory, defaultValue);
        this.min = min;
        this.max = max;
    }

    public AbstractMeasurePropertyDescription(String name, String label, String description, boolean mandatory, long min, long max) {
        super(name, label, description, mandatory);
        this.min = min;
        this.max = max;
    }

    public Number getMin() {
        return this.min;
    }

    public Number getMax() {
        return this.max;
    }

    protected String getMeasureUnitFromText(String value) {
        String[] results = value.split("[^a-z]");
        if (results.length == 0) {
            return null;
        }
        String measure = results[results.length - 1].trim();
        if (measure.isEmpty()) {
            return null;
        }
        return measure.toLowerCase();
    }

    protected void setMeasureUnit(String measureUnitKey, String measureUnitName, IWItemProperty wItemProperty) {
        String propertyName = wItemProperty.getPropertyName();
        String measureUnitProperty = String.valueOf(propertyName) + CURRENT_MEASURE_KEY;
        MeasureDefinition definition = new MeasureDefinition(measureUnitKey, measureUnitName);
        String encodedDefinition = this.encode(definition);
        wItemProperty.getPropertyEditor().createUpdateProperty(measureUnitProperty, encodedDefinition != null ? encodedDefinition.toLowerCase() : null, null);
    }

    protected void removeMeasureUnit(IWItemProperty wItemProperty) {
        String propertyName = wItemProperty.getPropertyName();
        String measureUnitProperty = String.valueOf(propertyName) + CURRENT_MEASURE_KEY;
        wItemProperty.getPropertyEditor().removeProperty(measureUnitProperty);
    }

    protected MeasureDefinition getMeasureUnit(IWItemProperty wItemProperty) {
        String propertyName = wItemProperty.getPropertyName();
        String measureUnitProperty = String.valueOf(propertyName) + CURRENT_MEASURE_KEY;
        String result = wItemProperty.getPropertyEditor().getPropertyValue(measureUnitProperty);
        MeasureDefinition value = this.decode(result);
        return value;
    }

    protected MeasureDefinition decode(String encodedMeasure) {
        MeasureDefinition result = null;
        if (encodedMeasure != null) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
                result = (MeasureDefinition)mapper.readValue(encodedMeasure, MeasureDefinition.class);
            }
            catch (JsonMappingException e) {
                throw new JRRuntimeException((Throwable)e);
            }
            catch (JsonParseException e) {
                throw new JRRuntimeException((Throwable)e);
            }
            catch (IOException e) {
                throw new JRRuntimeException((Throwable)e);
            }
        }
        return result;
    }

    protected String encode(MeasureDefinition value) {
        String result = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            result = mapper.writeValueAsString((Object)value);
        }
        catch (JsonProcessingException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        return result;
    }

    protected Long createMin(WidgetPropertyDescriptor cpd) {
        Long min = null;
        min = cpd.getMin() != null ? new Long(cpd.getMin()) : Long.valueOf(Long.MIN_VALUE);
        return min;
    }

    protected Long createMax(WidgetPropertyDescriptor cpd) {
        Long max = null;
        max = cpd.getMax() != null ? new Long(cpd.getMax()) : Long.valueOf(Long.MAX_VALUE);
        return max;
    }

    protected void updateBackground(Color color, Text control) {
        if (Util.isMac() && control.isFocusControl() && !ModelUtils.safeEquals(color, control.getBackground())) {
            FocusListener focusListner = (FocusListener)control.getData(FOCUS_KEY);
            control.removeFocusListener(focusListner);
            Point caretPosition = control.getSelection();
            boolean oldEnabled = control.getEnabled();
            control.setEnabled(false);
            control.setBackground(color);
            control.setEnabled(oldEnabled);
            control.setFocus();
            control.setSelection(caretPosition.x);
            control.addFocusListener(focusListner);
        } else {
            control.setBackground(color);
        }
    }

    protected void setErrorStatus(String message, Text insertField) {
        if (message != null) {
            this.updateBackground(ColorConstants.red, insertField);
            insertField.setToolTipText(message);
        } else {
            this.updateBackground(this.defaultBackgroundColor, insertField);
            insertField.setToolTipText(this.getToolTip());
        }
    }

    protected abstract Menu createPopupMenu(Text var1, IWItemProperty var2);

    protected void openPopupMenu(Text insertField, IWItemProperty wItemProp) {
        Menu popUpMenu = (Menu)insertField.getData(POPUP_KEY);
        if (popUpMenu == null) {
            popUpMenu = this.createPopupMenu(insertField, wItemProp);
        }
        if (!popUpMenu.isDisposed() && popUpMenu.getItemCount() > 1 && !insertField.getText().trim().isEmpty()) {
            if (popUpMenu.isVisible()) {
                popUpMenu.setVisible(false);
            } else {
                this.locatePopupMenu(insertField, popUpMenu);
                popUpMenu.setVisible(true);
            }
        }
    }

    protected void locatePopupMenu(Text insertField, Menu popUpMenu) {
        Rectangle r = insertField.getBounds();
        r.y = 0;
        r.x = 0;
        Point loc = insertField.toDisplay(r.x, r.y);
        loc.y += r.height;
        popUpMenu.setLocation(loc);
    }

    protected class AutoCompleteMeasure
    extends TextContentAdapter {
        private Text insertField;

        public AutoCompleteMeasure(Text insertField) {
            this.insertField = insertField;
        }

        public String getControlContents(Control control) {
            String text = this.insertField.getText().trim().toLowerCase();
            String measureUnit = AbstractMeasurePropertyDescription.this.getMeasureUnitFromText(text);
            if (this.insertField.getCaretPosition() == text.length() && measureUnit != null) {
                return measureUnit;
            }
            return "";
        }

        public void setControlContents(Control control, String text, int cursorPosition) {
            String textField = this.insertField.getText().trim().toLowerCase();
            String key = AbstractMeasurePropertyDescription.this.getMeasureUnitFromText(textField);
            String value = textField.substring(0, textField.indexOf(key));
            ((Text)control).setText(value.concat(text));
            ((Text)control).setSelection(cursorPosition, cursorPosition);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class MeasureDefinition {
        private String key;
        private String name;

        public MeasureDefinition() {
            this.key = "";
            this.name = "";
        }

        @JsonIgnore
        public MeasureDefinition(String measureKey, String measureName) {
            Assert.isNotNull((Object)measureName);
            Assert.isNotNull((Object)measureKey);
            this.key = measureKey;
            this.name = measureName.trim().toLowerCase();
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public void setKey(String value) {
            this.key = value;
        }

        public void setName(String value) {
            this.name = value;
        }
    }
}

