/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.manager.WidgetFactory;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.AbstractExpressionPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.dialog.ArrayDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ArrayPropertyDescription
extends AbstractExpressionPropertyDescription<String> {
    private ItemPropertyDescription<?> innerType;

    public ArrayPropertyDescription() {
    }

    public ArrayPropertyDescription(String name, String label, String description, boolean mandatory, String defaultValue) {
        super(name, label, description, mandatory, defaultValue);
    }

    @Override
    public Control createControl(IWItemProperty wiProp, Composite parent) {
        DoubleControlComposite cmp = new DoubleControlComposite(parent, 0);
        cmp.setLayoutData(new GridData(768));
        this.lazyCreateExpressionControl(wiProp, cmp);
        cmp.getSecondContainer().setLayout((Layout)WidgetFactory.getNoPadLayout(2));
        Text simpleControl = new Text(cmp.getSecondContainer(), 2048);
        simpleControl.setEnabled(false);
        cmp.getSecondContainer().setData((Object)simpleControl);
        cmp.setSimpleControlToHighlight((Control)simpleControl);
        GridData textData = new GridData(768);
        textData.verticalAlignment = 0x1000000;
        textData.grabExcessVerticalSpace = true;
        simpleControl.setLayoutData((Object)textData);
        this.createToolbarButton(cmp.getSecondContainer(), wiProp);
        cmp.switchToFirstContainer();
        return cmp;
    }

    protected void createToolbarButton(Composite parent, final IWItemProperty wiProp) {
        ToolBar toolBar = new ToolBar(parent, 0);
        ToolItem b = new ToolItem(toolBar, 0x800000);
        b.setImage(this.getButtonImage());
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (wiProp.isRefresh()) {
                    return;
                }
                wiProp.setRefresh(true);
                try {
                    ArrayDialog dialog = new ArrayDialog(UIUtils.getShell(), wiProp.getStaticValue(), ArrayPropertyDescription.this.innerType);
                    if (dialog.open() == 0) {
                        wiProp.setValue(dialog.getInnerValues(), null);
                    }
                }
                finally {
                    wiProp.setRefresh(false);
                }
            }
        });
        GridData data = new GridData();
        data.verticalAlignment = 128;
        toolBar.setLayoutData((Object)data);
        if (this.isReadOnly()) {
            toolBar.setEnabled(false);
        }
    }

    protected Image getButtonImage() {
        return JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/obj16/fldr_obj.gif");
    }

    @Override
    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        if (wip.isExpressionMode()) {
            this.lazyCreateExpressionControl(wip, cmp);
            Text expressionControl = (Text)cmp.getFirstContainer().getData();
            super.update((Control)expressionControl, wip);
            cmp.switchToFirstContainer();
            expressionControl.setToolTipText(this.getToolTip(wip, expressionControl.getText()));
        } else {
            Text txtValue = (Text)cmp.getSecondContainer().getData();
            String txt = wip.getStaticValue() != null ? wip.getStaticValue() : (wip.getFallbackValue() != null ? Misc.nvl((String)wip.getFallbackValue().toString()) : "");
            ObjectMapper mapper = new ObjectMapper();
            txtValue.setText("Values: 0");
            if (txt != null && !txt.isEmpty()) {
                try {
                    String[] stringValues = (String[])mapper.readValue(txt, String[].class);
                    txtValue.setText("Values: " + stringValues.length);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            txtValue.setToolTipText(this.getToolTip(wip, txtValue.getText()));
            cmp.switchToSecondContainer();
        }
    }

    @Override
    public ItemPropertyDescription<String> clone() {
        ArrayPropertyDescription result = new ArrayPropertyDescription();
        result.defaultValue = (String)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.fallbackValue = (String)this.fallbackValue;
        result.innerType = this.innerType.clone();
        return result;
    }

    public void setInnterType(ItemPropertyDescription<?> innerType) {
        this.innerType = innerType;
    }

    @Override
    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        ArrayPropertyDescription fileDesc = new ArrayPropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), cpd.getDefaultValue());
        fileDesc.setjConfig(jConfig);
        fileDesc.setReadOnly(cpd.isReadOnly());
        fileDesc.setFallbackValue(cpd.getFallbackValue());
        return fileDesc;
    }
}

