/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.SelectableComboItemPropertyDescription;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;

public class BooleanComboPropertyDescription
extends SelectableComboItemPropertyDescription<Boolean> {
    public static final String TRUE_VALUE = "true";
    public static final String FALSE_VALUE = "false";

    public BooleanComboPropertyDescription() {
    }

    public BooleanComboPropertyDescription(String name, String label, String description, boolean mandatory, Boolean defaultValue, String[][] keyValues) {
        super(name, label, description, mandatory, defaultValue, keyValues);
    }

    @Override
    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        if (wip.isExpressionMode()) {
            super.update(c, wip);
        } else {
            boolean isFallback = false;
            Combo booleanCombo = (Combo)cmp.getSecondContainer().getData();
            String v = wip.getStaticValue();
            if (this.verifyValue(v)) {
                booleanCombo.setText(v);
            } else {
                booleanCombo.setText(String.valueOf(wip.getFallbackValue()));
                isFallback = true;
            }
            this.changeFallbackForeground(isFallback, (Control)booleanCombo);
            cmp.switchToSecondContainer();
        }
    }

    protected boolean verifyValue(String value) {
        return TRUE_VALUE.equalsIgnoreCase(value) || FALSE_VALUE.equalsIgnoreCase(value);
    }

    @Override
    public BooleanComboPropertyDescription clone() {
        BooleanComboPropertyDescription result = new BooleanComboPropertyDescription();
        result.defaultValue = (Boolean)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.keyValues = this.keyValues;
        result.fallbackValue = (Boolean)this.fallbackValue;
        return result;
    }

    @Override
    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        String[][] i18nOpts = new String[2][2];
        i18nOpts[0][0] = TRUE_VALUE;
        i18nOpts[0][1] = cd.getLocalizedString(i18nOpts[0][0]);
        i18nOpts[1][0] = FALSE_VALUE;
        i18nOpts[1][1] = cd.getLocalizedString(i18nOpts[1][0]);
        Boolean defaultValue = null;
        Boolean fallbackValue = null;
        if (this.verifyValue(cpd.getDefaultValue())) {
            defaultValue = Boolean.parseBoolean(cpd.getDefaultValue());
        }
        if (this.verifyValue(cpd.getFallbackValue())) {
            fallbackValue = Boolean.parseBoolean(cpd.getFallbackValue());
        }
        BooleanComboPropertyDescription result = new BooleanComboPropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), defaultValue, i18nOpts);
        result.setReadOnly(cpd.isReadOnly());
        result.setFallbackValue(fallbackValue);
        return result;
    }
}

