/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.swt.events.ColorSelectedEvent;
import com.jaspersoft.studio.swt.events.ColorSelectionListener;
import com.jaspersoft.studio.swt.widgets.WColorPicker;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.Colors;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.AbstractExpressionPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class ColorPropertyDescription<T>
extends AbstractExpressionPropertyDescription<T> {
    private boolean htmlColorNamesSupported = false;

    public ColorPropertyDescription() {
    }

    public ColorPropertyDescription(String name, String label, String description, boolean mandatory, T defaultValue) {
        super(name, label, description, mandatory, defaultValue);
    }

    public ColorPropertyDescription(String name, String label, String description, boolean mandatory) {
        super(name, label, description, mandatory);
    }

    @Override
    public void handleEdit(Control txt, IWItemProperty wiProp) {
        super.handleEdit(txt, wiProp);
        if (txt instanceof WColorPicker) {
            String tvalue = Colors.getHexEncodedRGBColor(((WColorPicker)txt).getSelectedColorAsRGB());
            if (this.isTransaprent()) {
                tvalue = Colors.getRGBAEncodedRGBColor(((WColorPicker)txt).getSelectedColorAsRGB());
            }
            if (tvalue != null && tvalue.isEmpty()) {
                tvalue = null;
            }
            wiProp.setValue(tvalue, null);
        }
    }

    @Override
    public Control createControl(final IWItemProperty wiProp, Composite parent) {
        DoubleControlComposite cmp = new DoubleControlComposite(parent, 0);
        cmp.setLayoutData(new GridData(768));
        this.lazyCreateExpressionControl(wiProp, cmp);
        final WColorPicker simpleEditor = new WColorPicker(new AlfaRGB(new RGB(0, 0, 0), 0), cmp.getSecondContainer());
        cmp.getSecondContainer().setData((Object)simpleEditor);
        cmp.setSimpleControlToHighlight((Control)simpleEditor);
        simpleEditor.setHaveTransparency(this.isTransaprent());
        simpleEditor.addColorSelectionListener(new ColorSelectionListener(){

            @Override
            public void changed(ColorSelectedEvent e) {
                if (wiProp.isRefresh()) {
                    return;
                }
                ColorPropertyDescription.this.handleEdit((Control)simpleEditor, wiProp);
            }
        });
        Control[] controlArray = simpleEditor.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            this.setupContextMenu(c, wiProp);
            ++n2;
        }
        cmp.switchToSecondContainer();
        return cmp;
    }

    @Override
    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        if (wip.isExpressionMode()) {
            this.lazyCreateExpressionControl(wip, cmp);
            Text txt = (Text)cmp.getFirstContainer().getData();
            super.update((Control)txt, wip);
            cmp.switchToFirstContainer();
            txt.setToolTipText(this.getToolTip(wip, txt.getText()));
        } else {
            WColorPicker colorPicker = (WColorPicker)((Object)cmp.getSecondContainer().getData());
            colorPicker.setHtmlColorNamesSupport(this.htmlColorNamesSupported);
            String v = wip.getStaticValue();
            if (v == null && this.defaultValue != null) {
                v = this.defaultValue.toString();
            }
            boolean isFallback = false;
            if (v == null && this.fallbackValue != null) {
                isFallback = true;
                v = this.fallbackValue.toString();
            }
            colorPicker.setHtmlColorNamesSupport(this.htmlColorNamesSupported);
            colorPicker.setColor(WColorPicker.decodeColor(v, this.htmlColorNamesSupported));
            colorPicker.setToolTipText(this.getToolTip(wip, v));
            this.changeFallbackForeground(isFallback, (Control)colorPicker);
            cmp.switchToSecondContainer();
        }
    }

    @Override
    protected void changeFallbackForeground(boolean isUsingFallback, Control control) {
        Color dcolor = UIUtils.INHERITED_COLOR;
        Color ecolor = SWTResourceManager.getColor((int)21);
        Control controlToUpdate = control;
        if (control instanceof WColorPicker) {
            controlToUpdate = ((WColorPicker)control).getChildren()[1];
        }
        Color fg = controlToUpdate.getForeground();
        if (isUsingFallback && !ModelUtils.safeEquals(fg, dcolor)) {
            controlToUpdate.setForeground(dcolor);
        } else if (!isUsingFallback && !ModelUtils.safeEquals(fg.getRGB(), ecolor.getRGB())) {
            controlToUpdate.setForeground(null);
        }
    }

    public void setHtmlColorNamesSupport(boolean enabled) {
        this.htmlColorNamesSupported = enabled;
    }

    public boolean isHtmlColorNamesSupportEnabled() {
        return this.htmlColorNamesSupported;
    }

    protected boolean isTransaprent() {
        return false;
    }

    @Override
    public ItemPropertyDescription<T> clone() {
        ColorPropertyDescription<T> result = new ColorPropertyDescription<T>();
        result.defaultValue = this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.fallbackValue = this.fallbackValue;
        return result;
    }

    @Override
    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        ColorPropertyDescription<String> result = new ColorPropertyDescription<String>(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), cpd.getDefaultValue());
        result.setReadOnly(cpd.isReadOnly());
        result.setFallbackValue(cpd.getFallbackValue());
        return result;
    }
}

