/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.swt.widgets.NumericText;
import com.jaspersoft.studio.utils.ValidatedDecimalFormat;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.NumberPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.widget.FallbackNumericText;
import java.text.DecimalFormat;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FloatPropertyDescription
extends NumberPropertyDescription<Float> {
    public FloatPropertyDescription() {
    }

    public FloatPropertyDescription(String name, String label, String description, boolean mandatory, Float defaultValue, Float min, Float max) {
        super(name, label, description, mandatory, defaultValue, min, max);
    }

    public FloatPropertyDescription(String name, String label, String description, boolean mandatory, Float min, Float max) {
        super(name, label, description, mandatory, min, max);
    }

    @Override
    public Class<? extends Number> getType() {
        if (this.defaultValue != null) {
            return ((Float)this.defaultValue).getClass();
        }
        return Float.class;
    }

    @Override
    public FloatPropertyDescription clone() {
        FloatPropertyDescription result = new FloatPropertyDescription();
        result.defaultValue = (Float)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.min = (Float)this.min;
        result.max = (Float)this.max;
        result.fallbackValue = (Float)this.fallbackValue;
        return result;
    }

    public FloatPropertyDescription getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        Float min = null;
        Float max = null;
        Float def = null;
        Float fallBack = null;
        min = cpd.getMin() != null ? new Float(cpd.getMin()) : Float.valueOf(Float.MIN_VALUE);
        max = cpd.getMax() != null ? new Float(cpd.getMax()) : Float.valueOf(Float.MAX_VALUE);
        if (cpd.getDefaultValue() != null && !cpd.getDefaultValue().isEmpty()) {
            def = new Float(cpd.getDefaultValue());
        }
        if (cpd.getFallbackValue() != null && !cpd.getFallbackValue().isEmpty()) {
            fallBack = new Float(cpd.getFallbackValue());
        }
        FloatPropertyDescription floatDesc = new FloatPropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), def, min, max);
        floatDesc.setReadOnly(cpd.isReadOnly());
        floatDesc.setFallbackValue(fallBack);
        return floatDesc;
    }

    @Override
    protected FallbackNumericText createSimpleEditor(Composite parent) {
        FallbackNumericText text = new FallbackNumericText(parent, 2048, 4, 6);
        text.setRemoveTrailZeroes(true);
        Float max = Float.valueOf(this.getMax() != null ? ((Float)this.getMax()).floatValue() : Float.MAX_VALUE);
        Float min = Float.valueOf(this.getMin() != null ? ((Float)this.getMin()).floatValue() : Float.MIN_VALUE);
        text.setMaximum(max.doubleValue());
        text.setMinimum(min.doubleValue());
        return text;
    }

    @Override
    public void handleEdit(Control txt, IWItemProperty wiProp) {
        if (wiProp == null) {
            return;
        }
        if (txt instanceof NumericText) {
            int decimalPosition;
            String tvalue;
            NumericText widget = (NumericText)txt;
            Float floatValue = widget.getValueAsFloat();
            String string = tvalue = floatValue != null ? floatValue.toString() : null;
            if (tvalue != null && tvalue.isEmpty()) {
                tvalue = null;
            }
            if (tvalue != null && widget.getText() != null && (decimalPosition = tvalue.indexOf(ValidatedDecimalFormat.DECIMAL_SEPARATOR)) != -1) {
                int unconvertedDecimal = widget.getText().indexOf(ValidatedDecimalFormat.DECIMAL_SEPARATOR);
                if (unconvertedDecimal == -1) {
                    tvalue = tvalue.substring(0, decimalPosition);
                } else if (widget.getText().endsWith("0")) {
                    tvalue = widget.getText();
                }
            }
            widget.setToolTipText(this.getToolTip(wiProp, widget.getText()));
            wiProp.setValue(tvalue, null);
        } else {
            super.handleEdit(txt, wiProp);
        }
    }

    @Override
    protected Number convertValue(String v) throws NumberFormatException {
        if (v == null || v.isEmpty()) {
            return null;
        }
        char separator = ValidatedDecimalFormat.DECIMAL_SEPARATOR;
        if (separator != '.') {
            v = v.replace(separator, '.');
        }
        return Float.valueOf(v);
    }

    @Override
    public String getToolTip() {
        String tt = Misc.nvl((String)this.getDescription());
        tt = String.valueOf(tt) + "\n" + (this.isMandatory() ? "Mandatory" : "Optional");
        DecimalFormat formatter = new DecimalFormat("0.#######", ValidatedDecimalFormat.SYMBOLS);
        if (!Misc.isNullOrEmpty((String)this.getDefaultValueString())) {
            tt = String.valueOf(tt) + "\nDefault: " + formatter.format(this.getDefaultValue());
        }
        if (this.getMin() != null || this.getMax() != null) {
            if (this.getMin() != null && ((Float)this.getMin()).floatValue() != Float.MIN_VALUE) {
                tt = String.valueOf(tt) + "\nmin: " + formatter.format(this.getMin());
            }
            if (this.getMax() != null && ((Float)this.getMax()).floatValue() != Float.MAX_VALUE) {
                tt = String.valueOf(tt) + "\nmax: " + formatter.format(this.getMax());
            }
        }
        return tt;
    }
}

