/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.ComboItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;

public class FontFamilyComboPropertyDescription
extends ComboItemPropertyDescription<String> {
    public FontFamilyComboPropertyDescription() {
    }

    public FontFamilyComboPropertyDescription(String name, String label, String description, boolean mandatory, String defaultValue, String[][] keyValues) {
        super(name, label, description, mandatory, defaultValue, keyValues);
    }

    @Override
    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        if (wip.isExpressionMode()) {
            super.update(c, wip);
        } else {
            boolean isFallback = false;
            Combo fontCombo = (Combo)cmp.getSecondContainer().getData();
            String v = wip.getStaticValue();
            if (v != null) {
                fontCombo.setText(v);
            } else if (wip.getFallbackValue() != null) {
                fontCombo.setText(wip.getFallbackValue().toString());
                isFallback = true;
            }
            fontCombo.setToolTipText(this.getToolTip(wip, fontCombo.getToolTipText()));
            this.changeFallbackForeground(isFallback, (Control)fontCombo);
            cmp.switchToSecondContainer();
        }
    }

    @Override
    public FontFamilyComboPropertyDescription clone() {
        FontFamilyComboPropertyDescription result = new FontFamilyComboPropertyDescription();
        result.defaultValue = (String)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.keyValues = this.keyValues;
        result.fallbackValue = (String)this.fallbackValue;
        return result;
    }

    @Override
    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        String[][] fonts = FontFamilyComboPropertyDescription.convert2KeyValue(jConfig.getFontList());
        FontFamilyComboPropertyDescription result = new FontFamilyComboPropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), cpd.getDefaultValue(), fonts);
        result.setReadOnly(cpd.isReadOnly());
        result.setFallbackValue(cpd.getFallbackValue());
        return result;
    }
}

