/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.swt.widgets.NumericText;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.NumberPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.widget.FallbackNumericText;
import java.util.Locale;
import net.sf.jasperreports.eclipse.util.Misc;
import org.apache.commons.validator.routines.IntegerValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class IntegerPropertyDescription
extends NumberPropertyDescription<Integer> {
    public IntegerPropertyDescription() {
    }

    public IntegerPropertyDescription(String name, String label, String description, boolean mandatory, Integer defaultValue, Integer min, Integer max) {
        super(name, label, description, mandatory, defaultValue, min, max);
    }

    public IntegerPropertyDescription(String name, String label, String description, boolean mandatory, Integer min, Integer max) {
        super(name, label, description, mandatory, min, max);
    }

    @Override
    public Class<? extends Number> getType() {
        if (this.defaultValue != null) {
            return ((Integer)this.defaultValue).getClass();
        }
        return Integer.class;
    }

    @Override
    public IntegerPropertyDescription clone() {
        IntegerPropertyDescription result = new IntegerPropertyDescription();
        result.defaultValue = (Integer)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.min = (Integer)this.min;
        result.max = (Integer)this.max;
        result.fallbackValue = (Integer)this.fallbackValue;
        return result;
    }

    public IntegerPropertyDescription getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        Integer min = null;
        Integer max = null;
        Integer def = null;
        Integer fallBack = null;
        min = cpd.getMin() != null ? new Integer(cpd.getMin()) : Integer.valueOf(Integer.MIN_VALUE);
        max = cpd.getMax() != null ? new Integer(cpd.getMax()) : Integer.valueOf(Integer.MAX_VALUE);
        if (cpd.getDefaultValue() != null && !cpd.getDefaultValue().isEmpty()) {
            def = new Integer(cpd.getDefaultValue());
        }
        if (cpd.getFallbackValue() != null && !cpd.getFallbackValue().isEmpty()) {
            fallBack = new Integer(cpd.getFallbackValue());
        }
        IntegerPropertyDescription intDesc = new IntegerPropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), def, min, max);
        intDesc.setReadOnly(cpd.isReadOnly());
        intDesc.setFallbackValue(fallBack);
        return intDesc;
    }

    @Override
    protected FallbackNumericText createSimpleEditor(Composite parent) {
        FallbackNumericText text = new FallbackNumericText(parent, 2048, 0, 0);
        text.setRemoveTrailZeroes(true);
        Integer max = this.getMax() != null ? (Integer)this.getMax() : Integer.MAX_VALUE;
        Integer min = this.getMin() != null ? (Integer)this.getMin() : Integer.MIN_VALUE;
        text.setMaximum(max.doubleValue());
        text.setMinimum(min.doubleValue());
        return text;
    }

    @Override
    public void handleEdit(Control txt, IWItemProperty wiProp) {
        if (wiProp == null) {
            return;
        }
        if (txt instanceof NumericText) {
            String tvalue;
            NumericText widget = (NumericText)txt;
            Integer integerValue = widget.getValueAsInteger();
            String string = tvalue = integerValue != null ? integerValue.toString() : null;
            if (tvalue != null && tvalue.isEmpty()) {
                tvalue = null;
            }
            wiProp.setValue(tvalue, null);
            widget.setToolTipText(this.getToolTip(wiProp, widget.getText()));
        } else {
            super.handleEdit(txt, wiProp);
        }
    }

    @Override
    protected Integer convertValue(String v) throws NumberFormatException {
        if (v == null || v.isEmpty()) {
            return null;
        }
        Integer parsedInt = IntegerValidator.getInstance().validate(v, Locale.getDefault());
        if (parsedInt == null) {
            throw new NumberFormatException();
        }
        return parsedInt;
    }

    @Override
    public String getToolTip() {
        String tt = String.valueOf(this.getName()) + "\n\n";
        tt = String.valueOf(tt) + Misc.nvl((String)this.getDescription());
        tt = String.valueOf(tt) + "\n\n" + (this.isMandatory() ? "Mandatory" : "Optional");
        if (!Misc.isNullOrEmpty((String)this.getDefaultValueString())) {
            tt = String.valueOf(tt) + "\nDefault: " + this.getDefaultValue();
        }
        if (this.getMin() != null || this.getMax() != null) {
            if (this.getMin() != null && (Integer)this.getMin() != Integer.MIN_VALUE) {
                tt = String.valueOf(tt) + "\nmin: " + this.getMin();
            }
            if (this.getMax() != null && (Integer)this.getMax() != Integer.MAX_VALUE) {
                tt = String.valueOf(tt) + "\nmax: " + this.getMax();
            }
        }
        return tt;
    }
}

