/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.property.combomenu.ComboItem;
import com.jaspersoft.studio.property.combomenu.ComboItemAction;
import com.jaspersoft.studio.property.combomenu.ComboItemSeparator;
import com.jaspersoft.studio.property.combomenu.WritableComboMenuViewer;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.AbstractExpressionPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import java.util.ArrayList;
import net.sf.jasperreports.eclipse.ui.WritableComboButton;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class JSSDataAdapterPropertyDescription
extends AbstractExpressionPropertyDescription<String> {
    private ADataAdapterStorage[] daStorage = new ADataAdapterStorage[0];

    public JSSDataAdapterPropertyDescription() {
    }

    public JSSDataAdapterPropertyDescription(String name, String label, String description, boolean mandatory, String defaultValue, JasperReportsConfiguration jConfig) {
        super(name, label, description, mandatory, defaultValue);
        this.jConfig = jConfig;
        IFile file = (IFile)jConfig.get("ifile");
        this.daStorage = DataAdapterManager.getDataAdapter(file, jConfig);
    }

    public JSSDataAdapterPropertyDescription(String name, String label, String description, boolean mandatory, JasperReportsConfiguration jConfig) {
        super(name, label, description, mandatory);
        this.jConfig = jConfig;
        IFile file = (IFile)jConfig.get("ifile");
        this.daStorage = DataAdapterManager.getDataAdapter(file, jConfig);
    }

    @Override
    public Control createControl(final IWItemProperty wiProp, Composite parent) {
        DoubleControlComposite cmp = new DoubleControlComposite(parent, 0);
        cmp.setLayoutData(new GridData(768));
        this.lazyCreateExpressionControl(wiProp, cmp);
        final WritableComboMenuViewer viewer = new WritableComboMenuViewer(cmp.getSecondContainer(), 8);
        WritableComboButton simpleControl = viewer.getControl();
        cmp.getSecondContainer().setData((Object)viewer);
        cmp.setSimpleControlToHighlight((Control)simpleControl);
        GridData comboData = new GridData(768);
        comboData.verticalAlignment = 0x1000000;
        comboData.grabExcessVerticalSpace = true;
        simpleControl.setLayoutData((Object)comboData);
        JRDesignDataset currentDataset = this.jConfig.getJasperDesign().getMainDesignDataset();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (currentDataset != null) {
            int i = 0;
            while (i < this.daStorage.length) {
                ADataAdapterStorage s = this.daStorage[i];
                for (DataAdapterDescriptor d : s.getDataAdapterDescriptors(currentDataset)) {
                    ComboItem m1 = new ComboItem(s.getLabel(d), true, d.getIcon(16), i, d, d);
                    items.add(m1);
                }
                if (!s.getDataAdapterDescriptors(currentDataset).isEmpty() && i < this.daStorage.length - 1 && !this.daStorage[i + 1].getDataAdapterDescriptors(currentDataset).isEmpty()) {
                    items.add(new ComboItemSeparator(i));
                }
                ++i;
            }
        }
        viewer.addSelectionListener(new ComboItemAction(){

            @Override
            public void exec() {
                if (wiProp.isRefresh()) {
                    return;
                }
                String tValue = viewer.getText();
                wiProp.setValue(tValue, null);
            }
        });
        viewer.setItems(items);
        if (this.isReadOnly()) {
            simpleControl.setEnabled(false);
        } else {
            this.setupContextMenu((Control)simpleControl, wiProp);
        }
        cmp.switchToSecondContainer();
        return cmp;
    }

    @Override
    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        boolean isFallback = false;
        if (wip.isExpressionMode()) {
            this.lazyCreateExpressionControl(wip, cmp);
            Text txt = (Text)cmp.getFirstContainer().getData();
            super.update((Control)txt, wip);
            cmp.switchToFirstContainer();
            txt.setToolTipText(this.getToolTip(wip, txt.getText()));
        } else {
            WritableComboMenuViewer combo = (WritableComboMenuViewer)cmp.getSecondContainer().getData();
            String v = wip.getStaticValue();
            if (v == null && wip.getFallbackValue() != null) {
                v = wip.getFallbackValue().toString();
                isFallback = true;
            }
            combo.select(combo.getElementIndex(v));
            combo.setToolTipText(this.getToolTip(wip, v));
            this.changeFallbackForeground(isFallback, (Control)combo.getControl());
            cmp.switchToSecondContainer();
        }
    }

    @Override
    public ItemPropertyDescription<String> clone() {
        JSSDataAdapterPropertyDescription result = new JSSDataAdapterPropertyDescription();
        result.defaultValue = (String)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.fallbackValue = (String)this.fallbackValue;
        return result;
    }

    @Override
    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        JSSDataAdapterPropertyDescription result = new JSSDataAdapterPropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), cpd.getDefaultValue(), jConfig);
        result.setReadOnly(cpd.isReadOnly());
        result.setFallbackValue(cpd.getFallbackValue());
        return result;
    }
}

