/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.swt.widgets.NumericText;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.NumberPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.widget.FallbackNumericText;
import java.util.Locale;
import net.sf.jasperreports.eclipse.util.Misc;
import org.apache.commons.validator.routines.LongValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class LongPropertyDescription
extends NumberPropertyDescription<Long> {
    public LongPropertyDescription() {
    }

    public LongPropertyDescription(String name, String label, String description, boolean mandatory, Long defaultValue, Long min, Long max) {
        super(name, label, description, mandatory, defaultValue, min, max);
    }

    public LongPropertyDescription(String name, String label, String description, boolean mandatory, Long min, Long max) {
        super(name, label, description, mandatory, min, max);
    }

    @Override
    public Class<? extends Number> getType() {
        if (this.defaultValue != null) {
            return ((Long)this.defaultValue).getClass();
        }
        return Long.class;
    }

    @Override
    public LongPropertyDescription clone() {
        LongPropertyDescription result = new LongPropertyDescription();
        result.defaultValue = (Long)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.min = (Long)this.min;
        result.max = (Long)this.max;
        result.fallbackValue = (Long)this.fallbackValue;
        return result;
    }

    public LongPropertyDescription getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        Long min = null;
        Long max = null;
        Long def = null;
        Long fallBack = null;
        min = cpd.getMin() != null ? new Long(cpd.getMin()) : Long.valueOf(Long.MIN_VALUE);
        max = cpd.getMax() != null ? new Long(cpd.getMax()) : Long.valueOf(Long.MAX_VALUE);
        if (cpd.getDefaultValue() != null && !cpd.getDefaultValue().isEmpty()) {
            def = new Long(cpd.getDefaultValue());
        }
        if (cpd.getFallbackValue() != null && !cpd.getFallbackValue().isEmpty()) {
            fallBack = new Long(cpd.getFallbackValue());
        }
        LongPropertyDescription intDesc = new LongPropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), def, min, max);
        intDesc.setReadOnly(cpd.isReadOnly());
        intDesc.setFallbackValue(fallBack);
        return intDesc;
    }

    @Override
    protected FallbackNumericText createSimpleEditor(Composite parent) {
        FallbackNumericText text = new FallbackNumericText(parent, 2048, 0, 0);
        text.setRemoveTrailZeroes(true);
        Long max = this.getMax() != null ? (Long)this.getMax() : Long.MAX_VALUE;
        Long min = this.getMin() != null ? (Long)this.getMin() : Long.MIN_VALUE;
        text.setMaximum(max.doubleValue());
        text.setMinimum(min.doubleValue());
        return text;
    }

    @Override
    public void handleEdit(Control txt, IWItemProperty wiProp) {
        if (wiProp == null) {
            return;
        }
        if (txt instanceof NumericText) {
            String tvalue;
            NumericText widget = (NumericText)txt;
            Long longValue = widget.getValueAsLong();
            String string = tvalue = longValue != null ? longValue.toString() : null;
            if (tvalue != null && tvalue.isEmpty()) {
                tvalue = null;
            }
            wiProp.setValue(tvalue, null);
            widget.setToolTipText(this.getToolTip(wiProp, widget.getText()));
        } else {
            super.handleEdit(txt, wiProp);
        }
    }

    @Override
    protected Long convertValue(String v) throws NumberFormatException {
        if (v == null || v.isEmpty()) {
            return null;
        }
        Long parsedLong = LongValidator.getInstance().validate(v, Locale.getDefault());
        if (parsedLong == null) {
            throw new NumberFormatException();
        }
        return parsedLong;
    }

    @Override
    public String getToolTip() {
        String tt = Misc.nvl((String)this.getDescription());
        if (!Misc.isNullOrEmpty((String)this.getDefaultValueString())) {
            tt = String.valueOf(tt) + "\nDefault: " + this.getDefaultValue();
        }
        if (this.getMin() != null || this.getMax() != null) {
            if (this.getMin() != null && (Long)this.getMin() != Long.MIN_VALUE) {
                tt = String.valueOf(tt) + "\nmin: " + this.getMin();
            }
            if (this.getMax() != null && (Long)this.getMax() != Long.MAX_VALUE) {
                tt = String.valueOf(tt) + "\nmax: " + this.getMax();
            }
        }
        return tt;
    }
}

