/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.section.report.util.Unit;
import com.jaspersoft.studio.property.section.widgets.SPPixel;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.WItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.AbstractMeasurePropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.dialog.ItemPropertyElementDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class MeasureUnitPropertyDescription
extends AbstractMeasurePropertyDescription<Long> {
    public MeasureUnitPropertyDescription() {
    }

    public MeasureUnitPropertyDescription(String name, String label, String description, boolean mandatory, Long defaultValue, long min, long max) {
        super(name, label, description, mandatory, defaultValue, min, max);
    }

    public MeasureUnitPropertyDescription(String name, String label, String description, boolean mandatory, long min, long max) {
        super(name, label, description, mandatory, min, max);
    }

    @Override
    public Control createControl(final IWItemProperty wiProp, Composite parent) {
        DoubleControlComposite cmp = new DoubleControlComposite(parent, 0);
        cmp.setLayoutData(new GridData(768));
        this.lazyCreateExpressionControl(wiProp, cmp);
        final Text simpleControl = new Text(cmp.getSecondContainer(), 2048);
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (UIUtil.isMacAndEclipse4()) {
                    if (((Text)e.getSource()).isDisposed()) {
                        return;
                    }
                    wiProp.updateWidget();
                }
            }

            public void focusLost(FocusEvent e) {
                MeasureUnitPropertyDescription.this.handleEdit((Control)simpleControl, wiProp);
            }
        };
        simpleControl.addFocusListener((FocusListener)focusListener);
        simpleControl.setData("focusListener", (Object)focusListener);
        simpleControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    MeasureUnitPropertyDescription.this.handleEdit((Control)simpleControl, wiProp);
                }
            }
        });
        simpleControl.addMouseListener((MouseListener)new MouseClickListener(simpleControl, wiProp));
        if (SPPixel.autocompleteValues.length > 1) {
            new AutoCompleteField((Control)simpleControl, (IControlContentAdapter)new AbstractMeasurePropertyDescription.AutoCompleteMeasure(simpleControl), SPPixel.autocompleteValues);
        }
        this.defaultBackgroundColor = simpleControl.getBackground();
        cmp.getSecondContainer().setData((Object)simpleControl);
        cmp.setSimpleControlToHighlight((Control)simpleControl);
        GridData textData = new GridData(768);
        textData.verticalAlignment = 0x1000000;
        textData.grabExcessVerticalSpace = true;
        simpleControl.setLayoutData((Object)textData);
        this.setupContextMenu((Control)simpleControl, wiProp);
        cmp.switchToFirstContainer();
        return cmp;
    }

    @Override
    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        if (wip.isExpressionMode()) {
            this.lazyCreateExpressionControl(wip, cmp);
            Text expressionControl = (Text)cmp.getFirstContainer().getData();
            super.update((Control)expressionControl, wip);
            cmp.switchToFirstContainer();
            expressionControl.setToolTipText(this.getToolTip(wip, expressionControl.getText()));
        } else {
            boolean isFallback = false;
            Text simpleControl = (Text)cmp.getSecondContainer().getData();
            String v = wip.getStaticValue();
            if (v == null && wip.getFallbackValue() != null) {
                v = wip.getFallbackValue().toString();
                isFallback = true;
            }
            Long n = v != null ? Long.valueOf(Long.parseLong(v)) : null;
            this.setDataNumber(n, simpleControl, wip);
            this.changeFallbackForeground(isFallback, (Control)simpleControl);
            cmp.switchToSecondContainer();
            simpleControl.setToolTipText(this.getToolTip(wip, simpleControl.getText()));
        }
    }

    public void setDataNumber(Number f, Text insertField, IWItemProperty wItemProp) {
        if (f != null) {
            int oldpos = insertField.getCaretPosition();
            this.setPixels(f.toString(), insertField, wItemProp);
            if (insertField.getText().length() >= oldpos) {
                insertField.setSelection(oldpos, oldpos);
            }
        } else {
            insertField.setText("");
        }
    }

    @Override
    public String getToolTip(IWItemProperty wip, String value) {
        return String.valueOf(super.getToolTip(wip, value)) + "\n" + this.getToolTip();
    }

    @Override
    public String getToolTip() {
        String tt = super.getToolTip();
        if (this.getMin() != null) {
            tt = String.valueOf(tt) + "\nmin: " + this.getMin();
        }
        if (this.getMax() != null) {
            tt = String.valueOf(tt) + "\nmax: " + this.getMax();
        }
        return tt;
    }

    @Override
    protected Menu createPopupMenu(Text insertField, IWItemProperty wItemProp) {
        final Menu popUpMenu = new Menu((Control)insertField);
        insertField.setData("measureUnitMenu", (Object)popUpMenu);
        insertField.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                popUpMenu.dispose();
            }
        });
        int i = 0;
        while (i < SPPixel.units.length) {
            SPPixel.MeasureUnit key = SPPixel.units[i];
            MenuItem item = new MenuItem(popUpMenu, 8);
            item.setText(key.getUnitName());
            item.addSelectionListener((SelectionListener)new MenuAction(key.getKeyName(), key.getUnitName(), insertField, wItemProp));
            ++i;
        }
        return popUpMenu;
    }

    protected String getPixels(Text insertField) {
        String text = insertField.getText().trim().toLowerCase();
        String key = this.getMeasureUnitFromText(text);
        SPPixel.MeasureUnit unit = SPPixel.unitsMap.get(Unit.getKeyFromAlias(key));
        if (unit != null) {
            String value = text.substring(0, text.indexOf(key));
            if (value.trim().isEmpty()) {
                return null;
            }
            Unit uunit = new Unit(Double.parseDouble(value), unit.getKeyName());
            Double dValue = uunit.getValue("pixel");
            return String.valueOf(dValue.longValue());
        }
        return null;
    }

    protected void setPixels(String value, Text insertField, IWItemProperty wItemProp) {
        SPPixel.MeasureUnit defaultMeasure = this.getDefaultMeasure(insertField, wItemProp);
        Unit uunit = new Unit(Double.parseDouble(value), "pixel");
        Double dValue = uunit.getValue(defaultMeasure.getKeyName());
        insertField.setBackground(null);
        if ("pixel".equals(defaultMeasure.getKeyName())) {
            insertField.setText(String.valueOf(dValue.intValue()).concat(" ".concat(defaultMeasure.getUnitName())));
        } else {
            insertField.setText(String.valueOf(dValue).concat(" ".concat(defaultMeasure.getUnitName())));
        }
    }

    protected SPPixel.MeasureUnit getDefaultMeasure(Text insertField, IWItemProperty wItemProp) {
        SPPixel.MeasureUnit mu = null;
        AbstractMeasurePropertyDescription.MeasureDefinition localValue = this.getMeasureUnit(wItemProp);
        mu = localValue != null && SPPixel.unitsMap.containsKey(localValue.getKey()) ? SPPixel.unitsMap.get(localValue) : SPPixel.unitsMap.get("pixel");
        if (mu == null) {
            mu = SPPixel.units[0];
        }
        return mu;
    }

    @Override
    public void handleEdit(Control txt, IWItemProperty wiProp) {
        if (wiProp == null) {
            return;
        }
        if (!wiProp.isExpressionMode() && txt instanceof Text) {
            Text insertField = (Text)txt;
            String text = insertField.getText().trim().toLowerCase();
            if (!text.isEmpty()) {
                String value;
                SPPixel.MeasureUnit unit;
                String unitName = this.getMeasureUnitFromText(text);
                if (unitName == null) {
                    unit = this.getDefaultMeasure(insertField, wiProp);
                    value = text;
                } else {
                    unit = SPPixel.unitsMap.get(Unit.getKeyFromAlias(unitName));
                    value = text.substring(0, text.indexOf(unitName));
                }
                if (unit != null) {
                    try {
                        this.setMeasureUnit(unit.getKeyName(), unitName, wiProp);
                        String convertedValue = unit.doConversionFromThis(SPPixel.unitsMap.get("pixel"), value);
                        if (convertedValue != null) {
                            long pixelCount = Double.valueOf(convertedValue).longValue();
                            wiProp.setValue(String.valueOf(pixelCount), null);
                        } else {
                            wiProp.setValue(null, null);
                        }
                        this.setErrorStatus(null, insertField);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setErrorStatus(Messages.common_this_is_not_an_integer_number, insertField);
                    }
                    catch (Unit.PixelConversionException ex) {
                        this.setErrorStatus(ex.getMessage(), insertField);
                    }
                } else {
                    this.setErrorStatus(Messages.SPPixel_errorMeasureUnit, insertField);
                }
            } else {
                wiProp.setValue(null, null);
                this.removeMeasureUnit(wiProp);
            }
        } else {
            super.handleEdit(txt, wiProp);
        }
    }

    @Override
    public ItemPropertyElementDialog getDialog(final WItemProperty wItemProp) {
        ItemPropertyElementDialog result = new ItemPropertyElementDialog(UIUtils.getShell(), this, wItemProp){

            @Override
            public boolean close() {
                if (this.getReturnCode() == 0) {
                    String propertyName;
                    String measureUnit;
                    Control focusedControl = this.getShell().getDisplay().getFocusControl();
                    if (focusedControl != null) {
                        focusedControl.setEnabled(false);
                    }
                    if ((measureUnit = (String)this.customPropertiesMap.get(String.valueOf(propertyName = wItemProp.getPropertyName()) + "_measureUnit")) != null) {
                        AbstractMeasurePropertyDescription.MeasureDefinition currentDef = MeasureUnitPropertyDescription.this.decode(measureUnit);
                        MeasureUnitPropertyDescription.this.setMeasureUnit(currentDef.getKey(), currentDef.getName(), wItemProp);
                    }
                }
                return super.close();
            }

            @Override
            protected Control createDialogArea(Composite parent) {
                AbstractMeasurePropertyDescription.MeasureDefinition currentMeasureDef = MeasureUnitPropertyDescription.this.getMeasureUnit(wItemProp);
                String propertyName = wItemProp.getPropertyName();
                this.customPropertiesMap.put(String.valueOf(propertyName) + "_measureUnit", MeasureUnitPropertyDescription.this.encode(currentMeasureDef));
                return super.createDialogArea(parent);
            }
        };
        result.setHelpAvailable(false);
        result.setForceExpressionMode(wItemProp.hasForcedExpression());
        return result;
    }

    @Override
    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        Long def = null;
        Long fallBack = null;
        Long min = this.createMin(cpd);
        Long max = this.createMax(cpd);
        if (cpd.getDefaultValue() != null && !cpd.getDefaultValue().isEmpty()) {
            def = new Long(cpd.getDefaultValue());
        }
        if (cpd.getFallbackValue() != null && !cpd.getFallbackValue().isEmpty()) {
            fallBack = new Long(cpd.getFallbackValue());
        }
        MeasureUnitPropertyDescription intDesc = new MeasureUnitPropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), def, (long)min, (long)max);
        intDesc.setReadOnly(cpd.isReadOnly());
        intDesc.setFallbackValue(fallBack);
        intDesc.setjConfig(jConfig);
        return intDesc;
    }

    @Override
    public ItemPropertyDescription<Long> clone() {
        MeasureUnitPropertyDescription result = new MeasureUnitPropertyDescription();
        result.defaultValue = (Long)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.min = this.min;
        result.max = this.max;
        result.fallbackValue = (Long)this.fallbackValue;
        return result;
    }

    private class MenuAction
    extends SelectionAdapter {
        private String measureKey;
        private String measureName;
        private Text insertField;
        private IWItemProperty wItemProperty;

        public MenuAction(String measureKey, String measureName, Text insertField, IWItemProperty wItemProperty) {
            this.measureKey = measureKey;
            this.measureName = measureName;
            this.insertField = insertField;
            this.wItemProperty = wItemProperty;
        }

        public void widgetSelected(SelectionEvent e) {
            String pixelValue = MeasureUnitPropertyDescription.this.getPixels(this.insertField);
            MeasureUnitPropertyDescription.this.setMeasureUnit(this.measureKey, this.measureName, this.wItemProperty);
            MeasureUnitPropertyDescription.this.setPixels(pixelValue, this.insertField, this.wItemProperty);
        }
    }

    private class MouseClickListener
    extends MouseAdapter {
        private Text insertField;
        private IWItemProperty wItemProp;

        public MouseClickListener(Text insertField, IWItemProperty wItemProp) {
            this.insertField = insertField;
            this.wItemProp = wItemProp;
        }

        public void mouseDoubleClick(MouseEvent e) {
            String measureUnitAlias = this.insertField.getSelectionText().trim().toLowerCase();
            String measureUnitName = Unit.getKeyFromAlias(measureUnitAlias);
            if (measureUnitName != null) {
                MeasureUnitPropertyDescription.this.openPopupMenu(this.insertField, this.wItemProp);
            }
        }
    }
}

