/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.ui.AbstractExpressionPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.widget.FallbackNumericText;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class NumberPropertyDescription<T extends Number>
extends AbstractExpressionPropertyDescription<T> {
    protected T min;
    protected T max;

    public NumberPropertyDescription() {
    }

    public NumberPropertyDescription(String name, String label, String description, boolean mandatory, T defaultValue, T min, T max) {
        super(name, label, description, mandatory, defaultValue);
        this.min = min;
        this.max = max;
    }

    public NumberPropertyDescription(String name, String label, String description, boolean mandatory, T min, T max) {
        super(name, label, description, mandatory);
        this.min = min;
        this.max = max;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    @Override
    public Control createControl(final IWItemProperty wiProp, Composite parent) {
        DoubleControlComposite cmp = new DoubleControlComposite(parent, 0);
        cmp.setLayoutData(new GridData(768));
        this.lazyCreateExpressionControl(wiProp, cmp);
        final FallbackNumericText simpleControl = this.createSimpleEditor(cmp.getSecondContainer());
        cmp.getSecondContainer().setData((Object)simpleControl);
        cmp.setSimpleControlToHighlight((Control)simpleControl);
        GridData textData = new GridData(768);
        textData.verticalAlignment = 0x1000000;
        textData.grabExcessVerticalSpace = true;
        simpleControl.setLayoutData(textData);
        simpleControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (wiProp.isRefresh()) {
                    return;
                }
                NumberPropertyDescription.this.handleEdit((Control)simpleControl, wiProp);
            }
        });
        this.setupContextMenu((Control)simpleControl, wiProp);
        cmp.switchToFirstContainer();
        return cmp;
    }

    protected abstract FallbackNumericText createSimpleEditor(Composite var1);

    protected abstract Number convertValue(String var1) throws NumberFormatException;

    public abstract Class<? extends Number> getType();

    @Override
    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        if (wip.isExpressionMode()) {
            this.lazyCreateExpressionControl(wip, cmp);
            Text expressionControl = (Text)cmp.getFirstContainer().getData();
            super.update((Control)expressionControl, wip);
            cmp.switchToFirstContainer();
            expressionControl.setToolTipText(this.getToolTip(wip, expressionControl.getText()));
        } else {
            boolean isFallback = false;
            FallbackNumericText simpleControl = (FallbackNumericText)((Object)cmp.getSecondContainer().getData());
            String v = wip.getStaticValue();
            if (v == null && wip.getFallbackValue() != null) {
                v = wip.getFallbackValue().toString();
                isFallback = true;
            }
            simpleControl.setFallback(isFallback);
            try {
                String safeValue = Misc.nvl((String)v);
                Number numericValue = this.convertValue(safeValue);
                simpleControl.setValue(numericValue, safeValue);
                simpleControl.setToolTipText(this.getToolTip(wip, simpleControl.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                simpleControl.setUnparsedValue(Misc.nvl((String)v));
                simpleControl.setToolTipText("The current value can not be recognized \n" + this.getToolTip());
            }
            this.changeFallbackForeground(isFallback, (Control)simpleControl);
            cmp.switchToSecondContainer();
        }
    }

    @Override
    public String getToolTip() {
        String tt = super.getToolTip();
        if (this.getMin() != null) {
            tt = String.valueOf(tt) + "\nmin: " + this.getMin();
        }
        if (this.getMax() != null) {
            tt = String.valueOf(tt) + "\nmax: " + this.getMax();
        }
        return tt;
    }
}

