/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui.dialog;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.editor.table.TableLabelProvider;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import com.jaspersoft.studio.widgets.framework.WItemProperty;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.dialog.ItemPropertyElementDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ArrayDialog
extends PersistentLocationDialog {
    private TableViewer tableViewer;
    private List<String> deserializedValues;
    private ItemPropertyDescription<?> innerType;

    public ArrayDialog(Shell parentShell, String values, ItemPropertyDescription<?> innerType) {
        super(parentShell);
        this.innerType = innerType;
        ObjectMapper mapper = new ObjectMapper();
        try {
            String[] stringValues = new String[]{};
            if (values != null && !values.isEmpty()) {
                stringValues = (String[])mapper.readValue(values, String[].class);
            }
            this.deserializedValues = new ArrayList<String>(Arrays.asList(stringValues));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.deserializedValues = new ArrayList<String>();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ImportDialog_2);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.buildTable(composite);
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        bGroup.setBackground(parent.getBackground());
        NewButton bnew = new NewButton();
        bnew.createNewButtons(bGroup, this.tableViewer, new INewElement(){

            @Override
            public Object newElement(List<?> input, int pos) {
                ItemPropertyElementDialog dialog = new ItemPropertyElementDialog(UIUtils.getShell(), ArrayDialog.this.innerType, "", null, ExpressionContext.getGlobalContext()){

                    @Override
                    protected WItemProperty createProperty(Composite parent, ItemPropertyDescription<?> idDesc, IPropertyEditor editor) {
                        return new WItemProperty(parent, 4, this.ipDesc, editor){

                            @Override
                            public boolean isExpressionMode() {
                                return false;
                            }
                        };
                    }

                    @Override
                    protected void createExpressionCheckbox(Composite dialogArea) {
                    }
                };
                dialog.setHelpAvailable(false);
                if (dialog.open() == 0) {
                    return dialog.getStaticValue();
                }
                return null;
            }
        });
        bnew.setButtonText(Messages.ImportDialog_4);
        DeleteButton bdel = new DeleteButton();
        bdel.createDeleteButton(bGroup, this.tableViewer);
        this.tableViewer.setInput(this.deserializedValues);
        return composite;
    }

    public String getInnerValues() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(this.deserializedValues);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void buildTable(Composite composite) {
        Table table = new Table(composite, 67586);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 400;
        gd.minimumWidth = 400;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        this.tableViewer = new TableViewer(table);
        this.attachContentProvider(this.tableViewer);
        this.attachLabelProvider(this.tableViewer);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)tlayout);
        TableColumn[] column = new TableColumn[]{new TableColumn(table, 0)};
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
    }

    private void attachLabelProvider(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
    }

    private void attachContentProvider(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new ListContentProvider());
    }
}

