/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class ResourceBundleFilterDialog
extends FilteredResourcesSelectionDialog {
    private IJavaProject javaProject;

    public ResourceBundleFilterDialog(Shell shell, boolean multi, IJavaProject container) {
        super(shell, multi, (IContainer)container.getProject(), 1);
        this.javaProject = container;
    }

    private IResource[] getMembers(IContainer projectContainer) {
        try {
            IResource[] members = projectContainer.members();
            ArrayList<IResource> resources = new ArrayList<IResource>(Arrays.asList(members));
            String[] dependencies = this.javaProject.getRequiredProjectNames();
            IWorkspaceRoot rootWorkspace = this.javaProject.getResource().getWorkspace().getRoot();
            String[] stringArray = dependencies;
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                String projectName = stringArray[n2];
                IProject project = rootWorkspace.getProject(projectName);
                if (project.exists()) {
                    resources.addAll(Arrays.asList(project.members()));
                }
                ++n2;
            }
            return resources.toArray(new IResource[resources.size()]);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new IResource[0];
        }
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        if (itemsFilter instanceof FilteredResourcesSelectionDialog.ResourceFilter) {
            IProject projectContainer = this.javaProject.getProject();
            IResource[] members = this.getMembers((IContainer)projectContainer);
            progressMonitor.beginTask("Searching", members.length);
            ResourceProxyVisitor visitor = new ResourceProxyVisitor(contentProvider, (FilteredResourcesSelectionDialog.ResourceFilter)itemsFilter, progressMonitor);
            if (visitor.visit(projectContainer.createProxy())) {
                int i = 0;
                while (i < members.length) {
                    IResource member = members[i];
                    if (member.isAccessible()) {
                        member.accept((IResourceProxyVisitor)visitor, 0);
                    }
                    progressMonitor.worked(1);
                    if (progressMonitor.isCanceled()) break;
                    ++i;
                }
            }
        }
        progressMonitor.done();
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredResourcesSelectionDialog.ResourceFilter(this){

            public String getPattern() {
                String pattern = super.getPattern();
                if (pattern.isEmpty()) {
                    return "*";
                }
                return pattern;
            }

            public boolean matchItem(Object item) {
                if (!(item instanceof IResource)) {
                    return false;
                }
                IResource resource = (IResource)item;
                String name = resource.getName();
                if (!name.endsWith(".properties")) {
                    return false;
                }
                return super.matchItem(item);
            }
        };
    }

    public class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private FilteredItemsSelectionDialog.AbstractContentProvider proxyContentProvider;
        private FilteredResourcesSelectionDialog.ResourceFilter resourceFilter;
        private IProgressMonitor progressMonitor;

        public ResourceProxyVisitor(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredResourcesSelectionDialog.ResourceFilter resourceFilter, IProgressMonitor progressMonitor) throws CoreException {
            this.proxyContentProvider = contentProvider;
            this.resourceFilter = resourceFilter;
            this.progressMonitor = progressMonitor;
        }

        public boolean visit(IResourceProxy proxy) {
            if (this.progressMonitor.isCanceled()) {
                return false;
            }
            IResource resource = proxy.requestResource();
            this.proxyContentProvider.add((Object)resource, (FilteredItemsSelectionDialog.ItemsFilter)this.resourceFilter);
            if (resource.getType() == 2 && resource.isDerived() && !this.resourceFilter.isShowDerived()) {
                return false;
            }
            return resource.getType() != 1;
        }
    }
}

