/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.wizards.datasource;

import com.jaspersoft.studio.data.AWizardDataEditorComposite;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.IWizardDataEditorProvider;
import com.jaspersoft.studio.data.actions.CreateDataAdapterAction;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.data.ui.SimpleQueryWizardDataEditorComposite;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.datasource.MDatasources;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.utils.jobs.ProgressMonitorCheckerThread;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSWizardRunnablePage;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class StaticWizardDataSourcePage
extends JSSWizardRunnablePage {
    public static final String DISCOVERED_FIELDS = "discovered_fields";
    public static final String DISCOVERED_PARAMETERS = "discovered_parameters";
    public static final String DATASET_FIELDS = "dataset_fields";
    public static final String GROUP_FIELDS = "group_fields";
    public static final String DATASET_QUERY_LANGUAGE = "query_language";
    public static final String DATASET_PROPERTIES = "dataset_properties";
    public static final String DATASET_QUERY_TEXT = "query_text";
    public static final String EXTRA_PARAMETERS = "extra_parameters";
    public static final String ORDER_GROUP = "create_sort_fields";
    private Composite composite_editor = null;
    private AWizardDataEditorComposite activeEditor = null;
    private Label lblEmptyEditor = null;
    private Map<DataAdapterDescriptor, AWizardDataEditorComposite> editors = new HashMap<DataAdapterDescriptor, AWizardDataEditorComposite>();
    boolean firstLoad = true;
    protected Combo dataAdaptersCombo = null;
    List<DataAdapterDescriptor> dataAdapterDescriptors = new ArrayList<DataAdapterDescriptor>();
    private DataAdapterDescriptor selectedDataAdapterDescriptor = null;
    private PropertyChangeListener dsListner = arg0 -> this.loadSettings();
    private List<ADataAdapterStorage> storages;

    public StaticWizardDataSourcePage() {
        super("datasourcepage");
        this.setTitle(Messages.WizardDataSourcePage_datasource);
        this.setImageDescriptor(MDatasources.getIconDescriptor().getIcon32());
        this.setDescription(Messages.WizardDataSourcePage_description);
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_SELECT_DATASET;
    }

    public DataAdapterDescriptor getDataAdapter() {
        return this.selectedDataAdapterDescriptor;
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite_container = new Composite(parent, 0);
        this.setControl((Control)composite_container);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        composite_container.setLayout((Layout)layout);
        Label lblDataAdapter = new Label(composite_container, 0);
        lblDataAdapter.setText(Messages.WizardDataSourcePage_lblNewLabel_text);
        this.dataAdaptersCombo = new Combo(composite_container, 8);
        this.dataAdaptersCombo.addDisposeListener(e -> this.cleanDataAdapterStorageListeners());
        this.dataAdaptersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StaticWizardDataSourcePage.this.handleDataAdapterSelectionEvent(e);
            }
        });
        this.dataAdaptersCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnNew = new Button(composite_container, 0);
        btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateDataAdapterAction cda = new CreateDataAdapterAction();
                cda.run();
                if (cda.getNewDataAdapter() != null) {
                    StaticWizardDataSourcePage.this.firstLoad = true;
                    StaticWizardDataSourcePage.this.loadSettings();
                    int index = StaticWizardDataSourcePage.this.dataAdapterDescriptors.indexOf(cda.getNewDataAdapter());
                    if (index >= 0) {
                        StaticWizardDataSourcePage.this.dataAdaptersCombo.select(index);
                        StaticWizardDataSourcePage.this.handleDataAdapterSelectionEvent(null);
                    }
                }
            }
        });
        btnNew.setText(Messages.WizardDataSourcePage_btnNew_text);
        this.composite_editor = new Composite(composite_container, 0);
        this.composite_editor.setLayout((Layout)new StackLayout());
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 3;
        this.composite_editor.setLayoutData((Object)gd);
        this.lblEmptyEditor = new Label(this.composite_editor, 2048);
        this.lblEmptyEditor.setText(Messages.WizardDataSourcePage_lblThisDataAdapter_text);
    }

    public void loadSettings() {
        if (!this.firstLoad) {
            return;
        }
        this.firstLoad = false;
        this.dataAdapterDescriptors.clear();
        this.dataAdaptersCombo.removeAll();
        IProject selectedProject = null;
        JasperReportsConfiguration jConfig = null;
        if (this.getSettings() != null) {
            jConfig = (JasperReportsConfiguration)((Object)this.getSettings().get("jasperreports_configuration"));
            IFile f = (IFile)jConfig.get("ifile");
            if (this.getSettings().containsKey("file_path")) {
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(((IPath)this.getSettings().get("file_path")).toOSString());
                if (resource != null && resource.getProject() != null) {
                    selectedProject = resource.getProject();
                }
            } else if (this.getSettings().get("jasperreports_configuration") != null && f != null) {
                selectedProject = f.getProject();
            }
        }
        this.cleanDataAdapterStorageListeners();
        this.storages = new ArrayList<ADataAdapterStorage>();
        this.storages.add(DataAdapterManager.getPreferencesStorage());
        if (selectedProject != null) {
            this.storages.add(DataAdapterManager.getProjectStorage(selectedProject));
        }
        for (ADataAdapterStorage storage : this.storages) {
            if (jConfig != null && !jConfig.getEditorContext().isDataAdapterStorage(storage)) continue;
            ArrayList<DataAdapterDescriptor> das = new ArrayList<DataAdapterDescriptor>(storage.getDataAdapterDescriptors());
            Collections.sort(das, new Comparator<DataAdapterDescriptor>(){

                @Override
                public int compare(DataAdapterDescriptor o1, DataAdapterDescriptor o2) {
                    return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
                }
            });
            for (DataAdapterDescriptor d : das) {
                this.dataAdaptersCombo.add(storage.getLabel(d));
                this.dataAdapterDescriptors.add(d);
            }
            storage.addPropertyChangeListener(this.dsListner);
        }
        if (!this.dataAdapterDescriptors.isEmpty()) {
            if (!this.selectDataAdapter("One Empty Record") && !this.selectDataAdapter("Sample DB")) {
                this.dataAdaptersCombo.select(0);
            }
            this.handleDataAdapterSelectionEvent(null);
        }
    }

    private boolean selectDataAdapter(String name) {
        int i = 0;
        while (i < this.dataAdaptersCombo.getItemCount()) {
            if (this.dataAdapterDescriptors.get(i).getName().equals(name)) {
                this.dataAdaptersCombo.select(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    private void cleanDataAdapterStorageListeners() {
        if (this.storages != null) {
            for (ADataAdapterStorage s : this.storages) {
                s.removePropertyChangeListener(this.dsListner);
            }
        }
    }

    public void handleDataAdapterSelectionEvent(SelectionEvent event) {
        this.setErrorMessage(null);
        this.selectedDataAdapterDescriptor = null;
        if (this.dataAdaptersCombo.getSelectionIndex() >= 0) {
            DataAdapterDescriptor da;
            this.selectedDataAdapterDescriptor = da = this.dataAdapterDescriptors.get(this.dataAdaptersCombo.getSelectionIndex());
            AWizardDataEditorComposite editor = null;
            if (this.editors.containsKey(da)) {
                editor = this.editors.get(da);
            } else if (da instanceof IWizardDataEditorProvider) {
                editor = ((IWizardDataEditorProvider)((Object)da)).createDataEditorComposite(this.composite_editor, this);
                this.editors.put(da, editor);
            }
            if (editor != null) {
                if (editor != this.activeEditor) {
                    this.activeEditor = editor;
                    ((StackLayout)this.composite_editor.getLayout()).topControl = editor;
                    this.composite_editor.layout();
                }
            } else {
                this.activeEditor = null;
                ((StackLayout)this.composite_editor.getLayout()).topControl = this.lblEmptyEditor;
                this.composite_editor.layout();
            }
        }
        this.fireChangeEvent();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.loadSettings();
            this.composite_editor.redraw();
        }
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        if (this.activeEditor != null) {
            Object[] langs;
            this.getSettings().remove(DISCOVERED_FIELDS);
            Object lang = this.activeEditor.getQueryLanguage();
            if (lang == null && !Misc.isNullOrEmpty((Object[])(langs = this.selectedDataAdapterDescriptor.getLanguages()))) {
                lang = langs[0];
            }
            this.getSettings().put(DATASET_QUERY_LANGUAGE, lang);
            this.getSettings().put(DATASET_QUERY_TEXT, this.activeEditor.getQueryString());
            if (this.activeEditor instanceof SimpleQueryWizardDataEditorComposite) {
                this.getSettings().put(DATASET_PROPERTIES, ((SimpleQueryWizardDataEditorComposite)this.activeEditor).getDataset().getPropertiesMap());
            }
            UIUtils.getDisplay().asyncExec(() -> monitor.setTaskName("Getting fields..."));
            ProgressMonitorCheckerThread checker = new ProgressMonitorCheckerThread(monitor);
            checker.addListener(this.activeEditor);
            checker.start();
            this.setupParameters();
            List<JRDesignField> fields = this.activeEditor.readFields();
            if (fields != null && !fields.isEmpty() && this.getSettings() != null) {
                this.getSettings().put(DISCOVERED_FIELDS, fields);
            }
        } else {
            this.getSettings().remove(DATASET_QUERY_LANGUAGE);
            this.getSettings().remove(DATASET_QUERY_TEXT);
            this.getSettings().remove(DATASET_PROPERTIES);
        }
    }

    public void setupParameters() throws Exception {
        List<JRDesignParameter> prms;
        if (this.activeEditor != null && (prms = this.activeEditor.readParameters()) != null && !prms.isEmpty() && this.getSettings() != null) {
            this.getSettings().put(DISCOVERED_PARAMETERS, prms);
        }
    }

    @Override
    public boolean requireElaboration() {
        return this.activeEditor != null;
    }
}

