/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.wizards.group;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.group.MGroup;
import com.jaspersoft.studio.model.variable.MVariable;
import com.jaspersoft.studio.property.descriptor.expression.dialog.JRExpressionEditor;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class WizardBandGroupPage
extends WizardPage
implements IExpressionContextSetter {
    private MGroup group;
    private JasperDesign jrDesign;
    private Text grName;
    private List<Object> fList;
    private Table leftTable;
    private TableViewer leftTView;
    private ExpressionContext expContext;
    private Button bfield;

    public void setGroup(MGroup group) {
        this.group = group;
        JRDesignGroup ct = (JRDesignGroup)group.getValue();
        if (ct == null) {
            group.setValue(new JRDesignGroup());
        }
    }

    public MGroup getGroup() {
        return this.group;
    }

    public WizardBandGroupPage(JasperDesign jrDesign) {
        super("grouppage");
        this.setTitle(Messages.common_group);
        this.setDescription(Messages.WizardBandGroupPage_description);
        this.jrDesign = jrDesign;
        this.fList = ModelUtils.getReportObjects4Datasource(jrDesign.getMainDataset());
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)composite);
        Label lbl = new Label(composite, 0);
        lbl.setText(Messages.common_group_name);
        this.grName = new Text(composite, 2048);
        GridData gd = new GridData(768);
        this.grName.setLayoutData((Object)gd);
        this.grName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (WizardBandGroupPage.this.grName.getText() == null || WizardBandGroupPage.this.grName.getText().trim().equals("")) {
                    WizardBandGroupPage.this.setErrorMessage(Messages.WizardBandGroupPage_error_message_group_name_not_empty);
                    WizardBandGroupPage.this.setPageComplete(false);
                } else if (WizardBandGroupPage.this.jrDesign.getMainDesignDataset().getGroupsMap().get(WizardBandGroupPage.this.grName.getText()) != null) {
                    WizardBandGroupPage.this.setErrorMessage(Messages.WizardBandGroupPage_error_message_unique_name);
                    WizardBandGroupPage.this.setPageComplete(false);
                } else {
                    WizardBandGroupPage.this.setPageComplete(true);
                    WizardBandGroupPage.this.setErrorMessage(null);
                    WizardBandGroupPage.this.setMessage(WizardBandGroupPage.this.getDescription());
                    WizardBandGroupPage.this.group.setPropertyValue("name", WizardBandGroupPage.this.grName.getText());
                }
            }
        });
        this.grName.setText(ModelUtils.getDefaultName(this.jrDesign.getMainDesignDataset().getGroupsMap(), Messages.common_group));
        this.bfield = new Button(composite, 16);
        this.bfield.setText(Messages.WizardBandGroupPage_1);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.bfield.setLayoutData((Object)gd);
        this.bfield.setSelection(true);
        Button bexpr = new Button(composite, 16);
        bexpr.setText(Messages.WizardBandGroupPage_2);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        bexpr.setLayoutData((Object)gd);
        final Composite cmp = new Composite(composite, 0);
        final StackLayout stackLayout = new StackLayout();
        cmp.setLayout((Layout)stackLayout);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        cmp.setLayoutData((Object)gd);
        final Composite objCmp = this.createObjectFields(cmp);
        final Composite expCmp = this.createExpression(cmp);
        stackLayout.topControl = objCmp;
        this.bfield.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                stackLayout.topControl = objCmp;
                cmp.layout(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        bexpr.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                stackLayout.topControl = expCmp;
                cmp.layout(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "Jaspersoft.wizard");
    }

    private Composite createExpression(Composite cmp) {
        Composite composite = new Composite(cmp, 0);
        composite.setLayout((Layout)new GridLayout());
        Composite expCompo = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        expCompo.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        expCompo.setLayoutData((Object)gd);
        final Text dsExpr = new Text(expCompo, 2050);
        gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 100;
        dsExpr.setLayoutData((Object)gd);
        final Button dsExprDialog = new Button(expCompo, 8);
        dsExprDialog.setText("...");
        dsExprDialog.setLayoutData((Object)new GridData(2));
        dsExprDialog.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!ExpressionEditorSupportUtil.isExpressionEditorDialogOpen()) {
                    JRExpressionEditor wizard = new JRExpressionEditor();
                    JRDesignExpression mexp = (JRDesignExpression)WizardBandGroupPage.this.group.getPropertyValue("expression");
                    wizard.setValue(mexp);
                    wizard.setExpressionContext(WizardBandGroupPage.this.expContext);
                    WizardDialog dialog = ExpressionEditorSupportUtil.getExpressionEditorWizardDialog(dsExprDialog.getShell(), wizard);
                    dialog.create();
                    if (dialog.open() == 0) {
                        mexp = wizard.getValue();
                        WizardBandGroupPage.this.group.setPropertyValue("expression", mexp);
                        dsExpr.setText(mexp.getText());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        dsExpr.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardBandGroupPage.this.group.setPropertyValue("expression", dsExpr.getText());
            }
        });
        this.leftTView.setInput(this.fList);
        return composite;
    }

    private Composite createObjectFields(Composite cmp) {
        Composite composite = new Composite(cmp, 0);
        composite.setLayout((Layout)new GridLayout());
        this.leftTable = new Table(composite, 68100);
        this.leftTable.setLayoutData((Object)new GridData(1808));
        this.leftTable.setHeaderVisible(true);
        GridData tableData = new GridData(1808);
        tableData.heightHint = 300;
        this.leftTable.setLayoutData((Object)tableData);
        TableColumn[] col = new TableColumn[]{new TableColumn(this.leftTable, 0)};
        col[0].setText(Messages.common_report_objects);
        col[0].pack();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        this.leftTable.setLayout((Layout)tlayout);
        this.leftTView = new TableViewer(this.leftTable);
        this.leftTView.setContentProvider((IContentProvider)new ListContentProvider());
        this.leftTView.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
        this.leftTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection sel = (StructuredSelection)WizardBandGroupPage.this.leftTView.getSelection();
                if (!sel.isEmpty()) {
                    Object obj = sel.getFirstElement();
                    JRDesignExpression jrExpression = new JRDesignExpression();
                    if (obj instanceof JRDesignField) {
                        jrExpression.setText("$F{" + ((JRDesignField)obj).getName() + "}");
                    } else if (obj instanceof JRDesignVariable) {
                        jrExpression.setText("$V{" + ((JRDesignVariable)obj).getName() + "}");
                    }
                    WizardBandGroupPage.this.group.setPropertyValue("expression", jrExpression);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    private final class TLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof JRDesignField) {
                        return JaspersoftStudioPlugin.getInstance().getImage(MField.getIconDescriptor().getIcon16());
                    }
                    if (element instanceof JRDesignVariable) {
                        return JaspersoftStudioPlugin.getInstance().getImage(MVariable.getIconDescriptor().getIcon16());
                    }
                    if (!(element instanceof JRDesignParameter)) break;
                    return JaspersoftStudioPlugin.getInstance().getImage("icons/resources/parameter-report-16.png");
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof JRDesignField) {
                        return ((JRDesignField)element).getName();
                    }
                    if (element instanceof JRDesignVariable) {
                        return ((JRDesignVariable)element).getName();
                    }
                    if (!(element instanceof JRDesignParameter)) break;
                    return ((JRDesignParameter)element).getName();
                }
            }
            return "";
        }
    }
}

