/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.wizards.report;

import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;

public class ReportGenerator {
    public void processTemplate(JasperDesign jd, List<Object> fields, List<Object> groupFields) {
        JRDesignTextField fieldElement;
        JRDesignStaticText labelElement;
        JRBand detailBand;
        String reportType = Misc.nvl((Object)jd.getProperty("template.type"), (String)"tabular");
        boolean keepExtraGroups = false;
        boolean noLayoutChanges = false;
        if (jd.getProperty("template.keepExtraGroups") != null && jd.getProperty("template.keepExtraGroups").equals("true")) {
            keepExtraGroups = true;
        }
        if (groupFields != null) {
            int i = 0;
            while (i < groupFields.size()) {
                JRField gr = (JRField)groupFields.get(i);
                JRDesignGroup group = (JRDesignGroup)jd.getGroupsList().get(i);
                if (group.getGroupHeaderSection() != null && group.getGroupHeaderSection().getBands().length > 0) {
                    JRDesignTextField tf;
                    JRBand groupHeaderSection = group.getGroupHeaderSection().getBands()[0];
                    JRDesignStaticText st = ReportGenerator.findStaticTextElement((JRElementGroup)groupHeaderSection, "G" + (i + 1) + "Label");
                    if (st == null) {
                        st = ReportGenerator.findStaticTextElement((JRElementGroup)groupHeaderSection, "GroupLabel");
                    }
                    if (st == null) {
                        st = ReportGenerator.findStaticTextElement((JRElementGroup)groupHeaderSection, "Group Label");
                    }
                    if (st == null) {
                        st = ReportGenerator.findStaticTextElement((JRElementGroup)groupHeaderSection, "Label");
                    }
                    if (st == null) {
                        st = ReportGenerator.findStaticTextElement((JRElementGroup)groupHeaderSection, "Group name");
                    }
                    if (st != null) {
                        st.setText(gr.getName());
                    }
                    if ((tf = ReportGenerator.findTextFieldElement((JRElementGroup)groupHeaderSection, "G" + (i + 1) + "Field")) == null) {
                        tf = ReportGenerator.findTextFieldElement((JRElementGroup)groupHeaderSection, "GroupField");
                    }
                    if (tf == null) {
                        tf = ReportGenerator.findTextFieldElement((JRElementGroup)groupHeaderSection, "Group Field");
                    }
                    if (tf == null) {
                        tf = ReportGenerator.findTextFieldElement((JRElementGroup)groupHeaderSection, "Field");
                    }
                    if (tf != null) {
                        JRDesignExpression expression = ExprUtil.setValues(new JRDesignExpression(), "$F{" + gr.getName() + "}", gr.getValueClassName());
                        tf.setExpression((JRExpression)expression);
                    }
                }
                ++i;
            }
        }
        if (!keepExtraGroups && !noLayoutChanges && groupFields != null) {
            while (groupFields.size() < jd.getGroupsList().size()) {
                jd.removeGroup((JRGroup)((JRDesignGroup)jd.getGroupsList().get(groupFields.size())));
            }
        }
        JRBand jRBand = detailBand = jd.getDetailSection() != null && jd.getDetailSection().getBands() != null && jd.getDetailSection().getBands().length > 0 ? jd.getDetailSection().getBands()[0] : null;
        if (!noLayoutChanges && reportType != null && reportType.equals("tabular")) {
            int cols;
            JRDesignBand columnHeaderBand = (JRDesignBand)jd.getColumnHeader();
            labelElement = null;
            if (columnHeaderBand != null) {
                labelElement = ReportGenerator.findStaticTextElement((JRElementGroup)columnHeaderBand, "DetailLabel");
                if (labelElement == null) {
                    labelElement = ReportGenerator.findStaticTextElement((JRElementGroup)columnHeaderBand, "Label");
                }
                if (labelElement == null) {
                    labelElement = ReportGenerator.findStaticTextElement((JRElementGroup)columnHeaderBand, "Header");
                }
            }
            fieldElement = null;
            if (detailBand != null && (fieldElement = ReportGenerator.findTextFieldElement((JRElementGroup)detailBand, "DetailField")) == null) {
                fieldElement = ReportGenerator.findTextFieldElement((JRElementGroup)detailBand, "Field");
            }
            if (labelElement != null) {
                columnHeaderBand = labelElement.getElementGroup();
                this.removeElement((JRElementGroup)columnHeaderBand, (JRDesignElement)labelElement);
            }
            if (fieldElement != null) {
                detailBand = fieldElement.getElementGroup();
                this.removeElement((JRElementGroup)detailBand, (JRDesignElement)fieldElement);
            }
            int width = jd.getPageWidth() - jd.getRightMargin() - jd.getLeftMargin();
            if (detailBand != null && detailBand instanceof JRDesignFrame) {
                width = ((JRDesignFrame)detailBand).getWidth();
            }
            if ((cols = (fields != null ? fields.size() : 0) - (groupFields != null ? groupFields.size() : 0)) > 0) {
                width /= cols;
                int currentX = 0;
                if (fields != null) {
                    for (Object obj : fields) {
                        JRDesignField f = (JRDesignField)obj;
                        if (groupFields != null && groupFields.contains(f)) continue;
                        if (labelElement != null && columnHeaderBand != null) {
                            JRDesignStaticText newLabel = (JRDesignStaticText)labelElement.clone();
                            newLabel.setText(f.getName());
                            newLabel.setX(currentX);
                            newLabel.setWidth(width);
                            this.addElement((JRElementGroup)columnHeaderBand, (JRDesignElement)newLabel);
                        }
                        if (fieldElement != null && detailBand != null) {
                            JRDesignTextField newTextField = (JRDesignTextField)fieldElement.clone();
                            newTextField.setExpression((JRExpression)ExprUtil.setValues(new JRDesignExpression(), "$F{" + f.getName() + "}", f.getValueClassName()));
                            newTextField.setX(currentX);
                            newTextField.setWidth(width);
                            this.addElement((JRElementGroup)detailBand, (JRDesignElement)newTextField);
                        }
                        currentX += width;
                    }
                }
            }
        } else if (!noLayoutChanges && reportType != null && reportType.equals("columnar") && detailBand != null) {
            JRDesignBand detailBandField = (JRDesignBand)jd.getDetailSection().getBands()[0];
            labelElement = ReportGenerator.findStaticTextElement((JRElementGroup)detailBand, "DetailLabel");
            if (labelElement == null) {
                labelElement = ReportGenerator.findStaticTextElement((JRElementGroup)detailBand, "Label");
            }
            if (labelElement == null) {
                labelElement = ReportGenerator.findStaticTextElement((JRElementGroup)detailBand, "Header");
            }
            if ((fieldElement = ReportGenerator.findTextFieldElement((JRElementGroup)detailBandField, "DetailField")) == null) {
                fieldElement = ReportGenerator.findTextFieldElement((JRElementGroup)detailBandField, "Field");
            }
            if (labelElement != null) {
                detailBand = labelElement.getElementGroup();
                this.removeElement((JRElementGroup)detailBand, (JRDesignElement)labelElement);
            }
            if (fieldElement != null) {
                detailBandField = fieldElement.getElementGroup();
                this.removeElement((JRElementGroup)detailBandField, (JRDesignElement)fieldElement);
            }
            int currentY = 0;
            int rowHeight = 0;
            if (labelElement != null) {
                rowHeight = labelElement.getHeight();
            }
            if (fieldElement != null) {
                rowHeight = Math.max(rowHeight, fieldElement.getHeight());
            }
            if (fields != null) {
                for (Object obj : fields) {
                    JRDesignField f = (JRDesignField)obj;
                    if (groupFields != null && groupFields.contains(f)) continue;
                    if (labelElement != null) {
                        JRDesignStaticText newLabel = (JRDesignStaticText)labelElement.clone();
                        newLabel.setText(f.getName());
                        newLabel.setY(currentY);
                        this.addElement((JRElementGroup)detailBand, (JRDesignElement)newLabel);
                    }
                    if (fieldElement != null) {
                        JRDesignTextField newTextField = (JRDesignTextField)fieldElement.clone();
                        JRDesignExpression expression = ExprUtil.setValues(new JRDesignExpression(), "$F{" + f.getName() + "}", f.getValueClassName());
                        newTextField.setExpression((JRExpression)expression);
                        newTextField.setY(currentY);
                        this.addElement((JRElementGroup)detailBandField, (JRDesignElement)newTextField);
                    }
                    currentY += rowHeight;
                }
            }
            this.setGroupHeight((JRElementGroup)detailBand, currentY);
            this.setGroupHeight((JRElementGroup)detailBandField, currentY);
        }
    }

    public static JRDesignStaticText findStaticTextElement(JRElementGroup parent, String exp) {
        JRElement[] elements = parent.getElements();
        int i = 0;
        while (i < elements.length) {
            JRDesignStaticText ele2;
            JRElement ele = elements[i];
            if (ele instanceof JRDesignStaticText) {
                JRDesignStaticText st = (JRDesignStaticText)ele;
                if (st.getText() != null && st.getText().equalsIgnoreCase(exp)) {
                    return st;
                }
            } else if (ele instanceof JRElementGroup && (ele2 = ReportGenerator.findStaticTextElement((JRElementGroup)ele, exp)) != null) {
                return ele2;
            }
            ++i;
        }
        return null;
    }

    public static JRDesignTextField findTextFieldElement(JRElementGroup band, String exp) {
        JRElement[] elements = band.getElements();
        int i = 0;
        while (i < elements.length) {
            JRDesignTextField ele2;
            JRElement ele = elements[i];
            if (ele instanceof JRDesignTextField) {
                String s = ExprUtil.getExpressionText(((JRDesignTextField)ele).getExpression());
                if (s.startsWith("\"")) {
                    s = s.substring(1);
                }
                if (s.endsWith("\"")) {
                    s = s.substring(0, s.length() - 1);
                }
                if (s.equalsIgnoreCase(exp)) {
                    return (JRDesignTextField)ele;
                }
            } else if (ele instanceof JRElementGroup && (ele2 = ReportGenerator.findTextFieldElement((JRElementGroup)ele, exp)) != null) {
                return ele2;
            }
            ++i;
        }
        return null;
    }

    public void removeElement(JRElementGroup container, JRDesignElement element) {
        if (container instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)container).removeElement(element);
        }
        if (container instanceof JRDesignFrame) {
            ((JRDesignFrame)container).removeElement((JRElement)element);
        }
    }

    public void addElement(JRElementGroup container, JRDesignElement element) {
        if (container instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)container).addElement(element);
        }
        if (container instanceof JRDesignFrame) {
            ((JRDesignFrame)container).addElement((JRElement)element);
        }
    }

    private void setGroupHeight(JRElementGroup container, int currentY) {
        if (container instanceof JRDesignBand) {
            ((JRDesignBand)container).setHeight(Math.max(currentY, ((JRDesignBand)container).getHeight()));
        }
        if (container instanceof JRDesignFrame) {
            ((JRDesignFrame)container).setHeight(Math.max(currentY, ((JRDesignFrame)container).getHeight()));
        }
    }
}

