/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.animation.effects;

import java.util.List;
import org.eclipse.nebula.animation.effects.IEffect;

public class ParallelEffect
implements IEffect {
    IEffect[] effects = null;
    long length = 0L;
    Runnable onCancel;
    Runnable onStop;

    public ParallelEffect(IEffect[] effects) {
        this(effects, null, null);
    }

    public ParallelEffect(IEffect[] effects, Runnable onStop, Runnable onCancel) {
        this.effects = effects;
        this.onCancel = onCancel;
        this.onStop = onStop;
        if (effects != null) {
            IEffect e = null;
            int i = effects.length - 1;
            while (i >= 0) {
                e = effects[i];
                if (e.getLength() > this.length) {
                    this.length = e.getLength();
                }
                --i;
            }
        }
    }

    public ParallelEffect(List<?> effects) {
        this(effects, null, null);
    }

    public ParallelEffect(List<?> effects, Runnable onStop, Runnable onCancel) {
        this((IEffect[])effects.toArray(), onStop, onCancel);
    }

    @Override
    public void cancel() {
        if (this.effects != null) {
            int i = this.effects.length - 1;
            while (i >= 0) {
                this.effects[i].cancel();
                --i;
            }
        }
        if (this.onCancel != null) {
            this.onCancel.run();
        }
    }

    @Override
    public void doEffect(long time) {
        if (this.effects != null) {
            int i = this.effects.length - 1;
            while (i >= 0) {
                this.effects[i].doEffect(time);
                --i;
            }
        }
        if (this.onStop != null && this.isDone()) {
            this.onStop.run();
        }
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public boolean isDone() {
        if (this.effects != null) {
            boolean done = true;
            int i = this.effects.length - 1;
            while (i >= 0) {
                if (!this.effects[i].isDone()) {
                    done = false;
                }
                --i;
            }
            return done;
        }
        return true;
    }
}

