/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.gallery;

import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public abstract class AbstractGridGroupRenderer
extends AbstractGalleryGroupRenderer {
    static final int DEFAULT_SIZE = 96;
    protected int minMargin;
    protected int margin;
    protected boolean autoMargin;
    protected int itemWidth = 96;
    protected int itemHeight = 96;
    public static final String H_COUNT = "g.h";
    public static final String V_COUNT = "g.v";
    protected static final String EMPTY_STRING = "";
    private static final int END = 0;
    private static final int START = 1;
    private boolean alwaysExpanded = false;

    @Override
    public void draw(GC gc, GalleryItem group, int x, int y, int clipX, int clipY, int clipWidth, int clipHeight) {
    }

    @Override
    public GalleryItem getItem(GalleryItem group, Point coords) {
        return null;
    }

    @Override
    public Rectangle getSize(GalleryItem item) {
        return null;
    }

    @Override
    public void layout(GC gc, GalleryItem group) {
    }

    public boolean isAlwaysExpanded() {
        return this.alwaysExpanded;
    }

    protected boolean isGroupExpanded(GalleryItem item) {
        if (this.alwaysExpanded) {
            return true;
        }
        if (item == null) {
            return false;
        }
        return item.isExpanded();
    }

    public void setAlwaysExpanded(boolean alwaysExpanded) {
        this.alwaysExpanded = alwaysExpanded;
    }

    public int getMinMargin() {
        return this.minMargin;
    }

    public int getItemWidth() {
        return this.itemWidth;
    }

    public void setItemWidth(int itemWidth) {
        this.itemWidth = itemWidth;
        this.updateGallery();
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public void setItemHeight(int itemHeight) {
        this.itemHeight = itemHeight;
        this.updateGallery();
    }

    private void updateGallery() {
        if (this.gallery != null) {
            this.gallery.updateStructuralValues(null, true);
            this.gallery.updateScrollBarsProperties();
            this.gallery.redraw();
        }
    }

    public void setItemSize(int width, int height) {
        this.itemHeight = height;
        this.itemWidth = width;
        this.updateGallery();
    }

    public void setMinMargin(int minMargin) {
        this.minMargin = minMargin;
        this.updateGallery();
    }

    public boolean isAutoMargin() {
        return this.autoMargin;
    }

    public void setAutoMargin(boolean autoMargin) {
        this.autoMargin = autoMargin;
        this.updateGallery();
    }

    protected int calculateMargins(int size, int count, int itemSize) {
        int margin = this.minMargin;
        return margin += Math.round((float)(size - this.minMargin - count * (itemSize + this.minMargin)) / (float)(count + 1));
    }

    protected Point getSize(int nbx, int nby, int itemSizeX, int itemSizeY, int minMargin, int autoMargin) {
        int x = 0;
        int y = 0;
        if (this.gallery.isVertical()) {
            x = nbx * itemSizeX + (nbx - 1) * this.margin + 2 * minMargin;
            y = nby * itemSizeY + nby * minMargin;
        } else {
            x = nbx * itemSizeX + nbx * minMargin;
            y = nby * itemSizeY + (nby - 1) * this.margin + 2 * minMargin;
        }
        return new Point(x, y);
    }

    protected void drawItem(GC gc, int index, boolean selected, GalleryItem parent, int offsetY) {
        if (Gallery.DEBUG) {
            System.out.println("Draw item ? " + index);
        }
        if (index < parent.getItemCount()) {
            int yPixelPos;
            int xPixelPos;
            int posY;
            int posX;
            int hCount = (Integer)parent.getData(H_COUNT);
            int vCount = (Integer)parent.getData(V_COUNT);
            if (Gallery.DEBUG) {
                System.out.println("hCount :  " + hCount + " vCount : " + vCount);
            }
            if (this.gallery.isVertical()) {
                posX = index % hCount;
                posY = (index - posX) / hCount;
            } else {
                posY = index % vCount;
                posX = (index - posY) / vCount;
            }
            GalleryItem item = parent.getItem(index);
            if (item == null) {
                return;
            }
            GalleryItem gItem = item;
            if (this.gallery.isVertical()) {
                xPixelPos = posX * (this.itemWidth + this.margin) + this.margin;
                yPixelPos = posY * (this.itemHeight + this.minMargin) - this.gallery.translate + (parent == null ? 0 : parent.y + offsetY);
                gItem.x = xPixelPos;
                gItem.y = yPixelPos + this.gallery.translate;
            } else {
                xPixelPos = posX * (this.itemWidth + this.minMargin) - this.gallery.translate + (parent == null ? 0 : parent.x + offsetY);
                yPixelPos = posY * (this.itemHeight + this.margin) + this.margin;
                gItem.x = xPixelPos + this.gallery.translate;
                gItem.y = yPixelPos;
            }
            gItem.height = this.itemHeight;
            gItem.width = this.itemWidth;
            this.gallery.sendPaintItemEvent(item, index, gc, xPixelPos, yPixelPos, this.itemWidth, this.itemHeight);
            if (this.gallery.getItemRenderer() != null) {
                this.gallery.getItemRenderer().setSelected(selected);
                if (Gallery.DEBUG) {
                    System.out.println("itemRender.draw");
                }
                Rectangle oldClipping = gc.getClipping();
                gc.setClipping(oldClipping.intersection(new Rectangle(xPixelPos, yPixelPos, this.itemWidth, this.itemHeight)));
                this.gallery.getItemRenderer().draw(gc, gItem, index, xPixelPos, yPixelPos, this.itemWidth, this.itemHeight);
                gc.setClipping(oldClipping);
                if (Gallery.DEBUG) {
                    System.out.println("itemRender done");
                }
            }
        }
    }

    protected int[] getVisibleItems(GalleryItem group, int x, int y, int clipX, int clipY, int clipWidth, int clipHeight, int offset) {
        int[] indexes;
        if (this.gallery.isVertical()) {
            int lastItem;
            int lastLine;
            int count = (Integer)group.getData(H_COUNT);
            int firstLine = (clipY - y - offset - this.minMargin) / (this.itemHeight + this.minMargin);
            if (firstLine < 0) {
                firstLine = 0;
            }
            int firstItem = firstLine * count;
            if (Gallery.DEBUG) {
                System.out.println("First line : " + firstLine);
            }
            if ((lastLine = (clipY - y - offset + clipHeight - this.minMargin) / (this.itemHeight + this.minMargin)) < firstLine) {
                lastLine = firstLine;
            }
            if (Gallery.DEBUG) {
                System.out.println("Last line : " + lastLine);
            }
            if ((lastItem = (lastLine + 1) * count) - firstItem == 0) {
                return null;
            }
            indexes = new int[lastItem - firstItem];
            int i = 0;
            while (i < lastItem - firstItem) {
                indexes[i] = firstItem + i;
                ++i;
            }
        } else {
            int lastItem;
            int lastLine;
            int count = (Integer)group.getData(V_COUNT);
            int firstLine = (clipX - x - offset - this.minMargin) / (this.itemWidth + this.minMargin);
            if (firstLine < 0) {
                firstLine = 0;
            }
            int firstItem = firstLine * count;
            if (Gallery.DEBUG) {
                System.out.println("First line : " + firstLine);
            }
            if ((lastLine = (clipX - x - offset + clipWidth - this.minMargin) / (this.itemWidth + this.minMargin)) < firstLine) {
                lastLine = firstLine;
            }
            if (Gallery.DEBUG) {
                System.out.println("Last line : " + lastLine);
            }
            if ((lastItem = (lastLine + 1) * count) - firstItem == 0) {
                return null;
            }
            indexes = new int[lastItem - firstItem];
            int i = 0;
            while (i < lastItem - firstItem) {
                indexes[i] = firstItem + i;
                ++i;
            }
        }
        return indexes;
    }

    protected Point gridLayout(int size, int nbItems, int itemSize) {
        int x = 0;
        int y = 0;
        if (nbItems == 0) {
            return new Point(x, y);
        }
        x = (size - this.minMargin) / (itemSize + this.minMargin);
        if (x > 0) {
            y = (int)Math.ceil((double)nbItems / (double)x);
        } else {
            y = nbItems;
            x = 1;
        }
        return new Point(x, y);
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean mouseDown(GalleryItem group, MouseEvent e, Point coords) {
        return false;
    }

    @Override
    public void preLayout(GC gc) {
        this.margin = this.minMargin;
        super.preLayout(gc);
    }

    protected Point getLayoutData(GalleryItem item) {
        Integer hCount = (Integer)item.getData(H_COUNT);
        Integer vCount = (Integer)item.getData(V_COUNT);
        if (hCount == null || vCount == null) {
            return null;
        }
        return new Point(hCount.intValue(), vCount.intValue());
    }

    protected Rectangle getSize(GalleryItem item, int offsetY) {
        GalleryItem parent = item.getParentItem();
        if (parent != null) {
            int index = parent.indexOf(item);
            Point layoutData = this.getLayoutData(parent);
            if (layoutData == null) {
                return null;
            }
            int hCount = layoutData.x;
            int vCount = layoutData.y;
            if (Gallery.DEBUG) {
                System.out.println("hCount :  " + hCount + " vCount : " + vCount);
            }
            if (this.gallery.isVertical()) {
                int posX = index % hCount;
                int posY = (index - posX) / hCount;
                int xPixelPos = posX * (this.itemWidth + this.margin) + this.margin;
                int yPixelPos = posY * (this.itemHeight + this.minMargin) + (parent == null ? 0 : parent.y + offsetY);
                return new Rectangle(xPixelPos, yPixelPos, this.itemWidth, this.itemHeight);
            }
            int posY = index % vCount;
            int posX = (index - posY) / vCount;
            int yPixelPos = posY * (this.itemHeight + this.margin) + this.margin;
            int xPixelPos = posX * (this.itemWidth + this.minMargin) + (parent == null ? 0 : parent.x + offsetY);
            return new Rectangle(xPixelPos, yPixelPos, this.itemWidth, this.itemHeight);
        }
        return null;
    }

    protected GalleryItem getItem(GalleryItem group, Point coords, int offsetY) {
        int itemNb;
        if (Gallery.DEBUG) {
            System.out.println("getitem " + coords.x + " " + coords.y);
        }
        if (this.gallery.isVertical()) {
            Integer tmp = (Integer)group.getData(H_COUNT);
            if (tmp == null) {
                return null;
            }
            int hCount = tmp;
            int posX = (coords.x - this.margin) / (this.itemWidth + this.margin);
            int posOnItem = (coords.x - this.margin) % (this.itemWidth + this.margin);
            if (posOnItem > this.itemWidth || posOnItem < 0) {
                return null;
            }
            if (posX >= hCount) {
                return null;
            }
            if (coords.y - group.y < offsetY) {
                return null;
            }
            int posY = (coords.y - group.y - offsetY) / (this.itemHeight + this.minMargin);
            if ((coords.y - group.y - offsetY) % (this.itemHeight + this.minMargin) > this.itemHeight) {
                return null;
            }
            itemNb = posX + posY * hCount;
        } else {
            Integer tmp = (Integer)group.getData(V_COUNT);
            if (tmp == null) {
                return null;
            }
            int vCount = tmp;
            int posY = (coords.y - this.margin) / (this.itemHeight + this.margin);
            int posOnItem = (coords.y - this.margin) % (this.itemHeight + this.margin);
            if (posOnItem > this.itemHeight || posOnItem < 0) {
                return null;
            }
            if (posY >= vCount) {
                return null;
            }
            if (coords.x - group.x < offsetY) {
                return null;
            }
            int posX = (coords.x - group.x - offsetY) / (this.itemWidth + this.minMargin);
            if ((coords.x - group.x - offsetY) % (this.itemWidth + this.minMargin) > this.itemWidth) {
                return null;
            }
            itemNb = posY + posX * vCount;
        }
        if (Gallery.DEBUG) {
            System.out.println("Item found : " + itemNb);
        }
        if (itemNb < group.getItemCount()) {
            return group.getItem(itemNb);
        }
        return null;
    }

    private GalleryItem goLeft(GalleryItem group, int posParam) {
        int pos = posParam - 1;
        if (pos < 0) {
            GalleryItem item = null;
            GalleryItem currentGroup = group;
            while (item == null && currentGroup != null) {
                currentGroup = this.getPreviousGroup(currentGroup);
                item = this.getFirstItem(currentGroup, 0);
            }
            return item;
        }
        return group.getItem(pos);
    }

    private GalleryItem goRight(GalleryItem group, int posParam) {
        int pos = posParam + 1;
        if (pos >= group.getItemCount()) {
            GalleryItem item = null;
            GalleryItem currentGroup = group;
            while (item == null && currentGroup != null) {
                currentGroup = this.getNextGroup(currentGroup);
                item = this.getFirstItem(currentGroup, 1);
            }
            return item;
        }
        return group.getItem(pos);
    }

    private GalleryItem goUp(GalleryItem group, int posParam, int hCount, int lineCount) {
        if (lineCount == 0) {
            return null;
        }
        if (posParam - hCount * lineCount >= 0) {
            return group.getItem(posParam - hCount * lineCount);
        }
        GalleryItem next = this.goUp(group, posParam, hCount);
        if (next == null) {
            return null;
        }
        GalleryItem newItem = null;
        int i = 1;
        while (i < lineCount) {
            newItem = this.goUp(next.getParentItem(), next.getParentItem().indexOf(next), hCount);
            if (newItem == next || newItem == null) break;
            next = newItem;
            ++i;
        }
        return next;
    }

    private GalleryItem goDown(GalleryItem group, int posParam, int hCount, int lineCount) {
        if (lineCount == 0) {
            return null;
        }
        if (posParam + hCount * lineCount < group.getItemCount()) {
            return group.getItem(posParam + hCount * lineCount);
        }
        GalleryItem next = this.goDown(group, posParam, hCount);
        if (next == null) {
            return null;
        }
        GalleryItem newItem = null;
        int i = 1;
        while (i < lineCount) {
            newItem = this.goDown(next.getParentItem(), next.getParentItem().indexOf(next), hCount);
            if (newItem == next || newItem == null) break;
            next = newItem;
            ++i;
        }
        return next;
    }

    private GalleryItem goUp(GalleryItem group, int posParam, int hCount) {
        int colPos = posParam % hCount;
        int pos = posParam - hCount;
        if (pos < 0) {
            GalleryItem item = null;
            GalleryItem currentGroup = group;
            while (item == null && currentGroup != null) {
                currentGroup = this.getPreviousGroup(currentGroup);
                item = this.getItemAt(currentGroup, colPos, 0);
            }
            return item;
        }
        return group.getItem(pos);
    }

    private GalleryItem goDown(GalleryItem group, int posParam, int hCount) {
        int colPos = posParam % hCount;
        int pos = posParam + hCount;
        if (pos >= group.getItemCount()) {
            GalleryItem item = null;
            GalleryItem currentGroup = group;
            while (item == null && currentGroup != null) {
                currentGroup = this.getNextGroup(currentGroup);
                item = this.getItemAt(currentGroup, colPos, 1);
            }
            return item;
        }
        return group.getItem(pos);
    }

    private int getMaxVisibleLines() {
        if (this.gallery.isVertical()) {
            return this.gallery.getClientArea().height / this.itemHeight;
        }
        return this.gallery.getClientArea().width / this.itemWidth;
    }

    @Override
    public GalleryItem getNextItem(GalleryItem item, int key) {
        if (this.gallery.getItemCount() == 0) {
            return null;
        }
        if (item == null) {
            GalleryItem firstGroup;
            if (this.gallery.getItemCount() > 0 && (firstGroup = this.gallery.getItem(0)) != null && firstGroup.getItemCount() > 0) {
                return firstGroup.getItem(0);
            }
            return null;
        }
        if (item.getParentItem() == null) {
            return null;
        }
        GalleryItem group = item.getParentItem();
        switch (key) {
            case 0x1000007: {
                this.gallery.getItem(0).setExpanded(true);
                return this.getFirstItem(this.gallery.getItem(0), 1);
            }
            case 0x1000008: {
                this.gallery.getItem(this.gallery.getItemCount() - 1).setExpanded(true);
                return this.getFirstItem(this.gallery.getItem(this.gallery.getItemCount() - 1), 0);
            }
        }
        int pos = group.indexOf(item);
        GalleryItem next = null;
        if (this.gallery.isVertical()) {
            int hCount = (Integer)group.getData(H_COUNT);
            int maxVisibleRows = this.getMaxVisibleLines();
            switch (key) {
                case 0x1000003: {
                    next = this.goLeft(group, pos);
                    break;
                }
                case 0x1000004: {
                    next = this.goRight(group, pos);
                    break;
                }
                case 0x1000001: {
                    next = this.goUp(group, pos, hCount, 1);
                    break;
                }
                case 0x1000002: {
                    next = this.goDown(group, pos, hCount, 1);
                    break;
                }
                case 0x1000005: {
                    next = this.goUp(group, pos, hCount, Math.max(maxVisibleRows - 1, 1));
                    break;
                }
                case 0x1000006: {
                    next = this.goDown(group, pos, hCount, Math.max(maxVisibleRows - 1, 1));
                }
            }
        } else {
            int vCount = (Integer)group.getData(V_COUNT);
            int maxVisibleColumns = this.getMaxVisibleLines();
            switch (key) {
                case 0x1000003: {
                    next = this.goUp(group, pos, vCount);
                    break;
                }
                case 0x1000004: {
                    next = this.goDown(group, pos, vCount);
                    break;
                }
                case 0x1000001: {
                    next = this.goLeft(group, pos);
                    break;
                }
                case 0x1000002: {
                    next = this.goRight(group, pos);
                    break;
                }
                case 0x1000005: {
                    next = this.goUp(group, pos, vCount * Math.max(maxVisibleColumns - 1, 1));
                    break;
                }
                case 0x1000006: {
                    next = this.goDown(group, pos, vCount * Math.max(maxVisibleColumns - 1, 1));
                }
            }
        }
        return next;
    }

    private GalleryItem getPreviousGroup(GalleryItem group) {
        int gPos = this.gallery.indexOf(group);
        while (gPos > 0) {
            GalleryItem newGroup = this.gallery.getItem(gPos - 1);
            if (this.isGroupExpanded(newGroup)) {
                return newGroup;
            }
            --gPos;
        }
        return null;
    }

    private GalleryItem getNextGroup(GalleryItem group) {
        int gPos = this.gallery.indexOf(group);
        while (gPos < this.gallery.getItemCount() - 1) {
            GalleryItem newGroup = this.gallery.getItem(gPos + 1);
            if (this.isGroupExpanded(newGroup)) {
                return newGroup;
            }
            ++gPos;
        }
        return null;
    }

    private GalleryItem getFirstItem(GalleryItem group, int from) {
        if (group == null) {
            return null;
        }
        switch (from) {
            case 0: {
                return group.getItem(group.getItemCount() - 1);
            }
        }
        return group.getItem(0);
    }

    private GalleryItem getItemAt(GalleryItem group, int pos, int from) {
        if (group == null) {
            return null;
        }
        int hCount = (Integer)group.getData(H_COUNT);
        int offset = 0;
        switch (from) {
            case 0: {
                if (group.getItemCount() == 0) {
                    return null;
                }
                int endPos = group.getItemCount() % hCount;
                if (endPos == 0) {
                    endPos = hCount - 1;
                    --offset;
                }
                if (pos < endPos) {
                    int nbLines = group.getItemCount() / hCount + offset;
                    return group.getItem(nbLines * hCount + pos);
                }
                return group.getItem((group.getItemCount() / hCount + offset) * hCount + endPos - 1);
            }
        }
        if (pos >= group.getItemCount()) {
            return group.getItem(group.getItemCount() - 1);
        }
        return group.getItem(pos);
    }
}

