/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.subclipse.ui.util.LinkList;

public class OpenBugUrlAction
extends WorkbenchWindowAction {
    @Override
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        Object[] selectedObjects = this.selection.toArray();
        HashSet<String> urlsSet = new HashSet<String>();
        int i = 0;
        while (i < selectedObjects.length) {
            if (selectedObjects[i] instanceof ILogEntry) {
                ILogEntry logEntry = (ILogEntry)selectedObjects[i];
                try {
                    ProjectProperties projectProperties = ProjectProperties.getProjectProperties(logEntry.getResource().getResource());
                    LinkList linkList = projectProperties.getLinkList(logEntry.getComment());
                    String[] urls = linkList.getUrls();
                    int j = 0;
                    while (j < urls.length) {
                        urlsSet.add(urls[j]);
                        ++j;
                    }
                }
                catch (Exception e) {
                    this.handle(e, null, null);
                }
            }
            ++i;
        }
        i = 0;
        Iterator it = urlsSet.iterator();
        while (it.hasNext()) {
            try {
                PlatformUI.getWorkbench().getBrowserSupport().createBrowser("bugurlbrowser" + i++).openURL(new URL((String)it.next()));
            }
            catch (Exception e) {
                this.handle(e, null, null);
            }
        }
    }

    @Override
    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    @Override
    protected boolean isEnabled() throws TeamException {
        Object[] selectedObjects = this.selection.toArray();
        int i = 0;
        while (i < selectedObjects.length) {
            if (selectedObjects[i] instanceof ILogEntry) {
                ILogEntry logEntry = (ILogEntry)selectedObjects[i];
                ProjectProperties projectProperties = ProjectProperties.getProjectProperties(logEntry.getResource().getResource());
                if (projectProperties == null) {
                    return false;
                }
                LinkList linkList = projectProperties.getLinkList(logEntry.getComment());
                return linkList.getUrls().length != 0;
            }
            ++i;
        }
        return false;
    }
}

