/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui;

public class SvnVersion {
    private int major;
    private int minor;
    private int patch;
    private int revision;
    public static final SvnVersion VERSION_1_8_11 = new SvnVersion(1, 8, 11, 0);

    public SvnVersion() {
    }

    public SvnVersion(int major, int minor, int patch, int revision) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.revision = revision;
    }

    public SvnVersion(String version) {
        String[] split = version.split("\\.");
        if (split.length > 0) {
            this.major = Integer.parseInt(split[0]);
        }
        if (split.length > 1) {
            this.minor = Integer.parseInt(split[1]);
        }
        if (split.length > 2) {
            int index = split[2].indexOf(" ");
            if (index == -1) {
                this.patch = Integer.parseInt(split[2]);
            } else {
                this.patch = Integer.parseInt(split[2].substring(0, index));
                int revIndex = split[2].indexOf("(r");
                if (revIndex != -1) {
                    this.revision = Integer.parseInt(split[2].substring(revIndex + 2).replace(")", ""));
                }
            }
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int getRevision() {
        return this.revision;
    }

    public boolean isNewerThanOrEqualTo(SvnVersion compareToVersion) {
        return this.compareTo(compareToVersion) >= 0;
    }

    public int compareTo(SvnVersion compareToVersion) {
        int from = 0;
        int to = 0;
        if (compareToVersion.getMajor() != this.major) {
            from = this.major;
            to = compareToVersion.getMajor();
        } else if (compareToVersion.getMinor() != this.minor) {
            from = this.minor;
            to = compareToVersion.getMinor();
        } else if (compareToVersion.getPatch() != this.patch) {
            from = this.patch;
            to = compareToVersion.getPatch();
        } else {
            from = this.revision;
            to = compareToVersion.getRevision();
        }
        return Integer.valueOf(from).compareTo(to);
    }

    public String toString() {
        return String.valueOf(this.major) + "." + this.minor + "." + this.patch + " (r" + this.revision + ")";
    }
}

