/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.SVNAction;
import org.tigris.subversion.subclipse.ui.compare.ResourceEditionNode;
import org.tigris.subversion.subclipse.ui.compare.SVNCompareEditorInput;
import org.tigris.subversion.subclipse.ui.compare.SVNFolderCompareEditorInput;
import org.tigris.subversion.subclipse.ui.compare.internal.Utilities;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CompareRemoteResourcesAction
extends SVNAction {
    private ISVNRemoteResource[] remoteResources;
    private ISVNResource[] localResources;
    private SVNRevision[] pegRevisions;
    private IResource localResource;

    @Override
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                String localCharset;
                ISVNRemoteResource[] editions = CompareRemoteResourcesAction.this.getSelectedRemoteResources();
                if (editions == null || editions.length != 2) {
                    Object[] selectedObjects = CompareRemoteResourcesAction.this.selection.toArray();
                    if (selectedObjects.length == 2 && selectedObjects[0] instanceof ILogEntry && selectedObjects[1] instanceof ILogEntry) {
                        ILogEntry logEntry1 = (ILogEntry)selectedObjects[0];
                        ILogEntry logEntry2 = (ILogEntry)selectedObjects[1];
                        try {
                            RemoteFolder folder1 = new RemoteFolder(logEntry1.getResource().getRepository(), logEntry1.getResource().getUrl(), (SVNRevision)logEntry1.getRevision());
                            RemoteFolder folder2 = new RemoteFolder(logEntry2.getResource().getRepository(), logEntry2.getResource().getUrl(), (SVNRevision)logEntry2.getRevision());
                            this.compareFolders((ISVNRemoteFolder)folder1, (ISVNRemoteFolder)folder2);
                        }
                        catch (Exception exception) {}
                    } else {
                        MessageDialog.openError((Shell)CompareRemoteResourcesAction.this.getShell(), (String)Policy.bind("CompareRemoteResourcesAction.unableToCompare"), (String)Policy.bind("CompareRemoteResourcesAction.selectTwoResources"));
                    }
                    return;
                }
                if (editions[0] instanceof ISVNRemoteFolder && editions[1] instanceof ISVNRemoteFolder) {
                    this.compareFolders((ISVNRemoteFolder)editions[0], (ISVNRemoteFolder)editions[1]);
                    return;
                }
                ResourceEditionNode left = new ResourceEditionNode(editions[0]);
                ResourceEditionNode right = new ResourceEditionNode(editions[1]);
                if (CompareRemoteResourcesAction.this.localResource != null && (localCharset = Utilities.getCharset(CompareRemoteResourcesAction.this.localResource)) != null) {
                    try {
                        left.setCharset(localCharset);
                        right.setCharset(localCharset);
                    }
                    catch (CoreException coreException) {}
                }
                CompareUI.openCompareEditorOnPage((CompareEditorInput)new SVNCompareEditorInput(left, right), (IWorkbenchPage)CompareRemoteResourcesAction.this.getTargetPage());
            }

            private void compareFolders(ISVNRemoteFolder folder1, ISVNRemoteFolder folder2) {
                SVNRevision pegRevision1 = null;
                SVNRevision pegRevision2 = null;
                pegRevision1 = CompareRemoteResourcesAction.this.pegRevisions != null && CompareRemoteResourcesAction.this.pegRevisions.length > 0 ? CompareRemoteResourcesAction.this.pegRevisions[0] : SVNRevision.HEAD;
                pegRevision2 = CompareRemoteResourcesAction.this.pegRevisions != null && CompareRemoteResourcesAction.this.pegRevisions.length > 1 ? CompareRemoteResourcesAction.this.pegRevisions[1] : pegRevision1;
                SVNFolderCompareEditorInput compareEditorInput = new SVNFolderCompareEditorInput(folder1, pegRevision1, folder2, pegRevision2);
                if (CompareRemoteResourcesAction.this.localResources != null && CompareRemoteResourcesAction.this.localResources.length > 1) {
                    compareEditorInput.setLocalResource1(CompareRemoteResourcesAction.this.localResources[0]);
                    compareEditorInput.setLocalResource2(CompareRemoteResourcesAction.this.localResources[1]);
                }
                CompareUI.openCompareEditorOnPage((CompareEditorInput)compareEditorInput, (IWorkbenchPage)CompareRemoteResourcesAction.this.getTargetPage());
            }
        }, false, 2);
    }

    @Override
    protected boolean isEnabled() {
        Object[] selectedObjects;
        boolean enabled;
        ISVNRemoteResource[] resources = this.getSelectedRemoteResources();
        boolean bl = enabled = resources.length == 2 && resources[0].isContainer() == resources[1].isContainer();
        if (!enabled && (selectedObjects = this.selection.toArray()).length == 2 && selectedObjects[0] instanceof ILogEntry && selectedObjects[1] instanceof ILogEntry) {
            ILogEntry logEntry1 = (ILogEntry)selectedObjects[0];
            ILogEntry logEntry2 = (ILogEntry)selectedObjects[1];
            if (logEntry1.getResource() != null && logEntry1.getResource().isFolder() && logEntry2.getResource() != null && logEntry2.getResource().isFolder()) {
                enabled = true;
            }
        }
        return enabled;
    }

    @Override
    protected String getImageId() {
        return "Menu Compare";
    }

    public void setRemoteResources(ISVNRemoteResource[] remoteResources) {
        this.remoteResources = remoteResources;
    }

    public void setPegRevisions(SVNRevision[] pegRevisions) {
        this.pegRevisions = pegRevisions;
    }

    @Override
    protected ISVNRemoteResource[] getSelectedRemoteResources() {
        if (this.remoteResources != null) {
            return this.remoteResources;
        }
        return super.getSelectedRemoteResources();
    }

    public void setLocalResources(ISVNResource[] localResources) {
        this.localResources = localResources;
    }

    public void setLocalResource(IResource localResource) {
        this.localResource = localResource;
    }
}

