/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.commands.GetStatusCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.wizards.WizardDialogWithPersistedLocation;
import org.tigris.subversion.subclipse.ui.wizards.generatediff.GenerateDiffFileWizard;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.utils.SVNStatusUtils;

public class GenerateDiffFileAction
extends WorkbenchWindowAction {
    private IResource[] modifiedResources;
    private ArrayList unaddedList;
    private HashMap statusMap;

    @Override
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.statusMap = new HashMap();
        this.unaddedList = new ArrayList();
        String title = Policy.bind("GenerateSVNDiff.title");
        final IResource[] resources = this.getSelectedResources();
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    GenerateDiffFileAction.this.modifiedResources = GenerateDiffFileAction.this.getModifiedResources(resources, monitor);
                }
                catch (SVNException e) {
                    SVNUIPlugin.log(4, e.getMessage(), e);
                }
            }
        }, true, 2);
        if (this.modifiedResources == null || this.modifiedResources.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Policy.bind("GenerateSVNDiff.title"), (String)Policy.bind("GenerateSVNDiff.noDiffsFoundMsg"));
            return;
        }
        IResource[] unaddedResources = new IResource[this.unaddedList.size()];
        this.unaddedList.toArray(unaddedResources);
        GenerateDiffFileWizard wizard = new GenerateDiffFileWizard((IStructuredSelection)new StructuredSelection((Object[])this.modifiedResources), unaddedResources, this.statusMap);
        wizard.setWindowTitle(title);
        wizard.setSelectedResources(this.getSelectedResources());
        WizardDialogWithPersistedLocation dialog = new WizardDialogWithPersistedLocation(this.getShell(), (IWizard)wizard, "GenerateDiffFileWizard");
        dialog.setMinimumPageSize(350, 250);
        dialog.open();
    }

    @Override
    protected boolean isEnabled() throws TeamException {
        boolean isEnabled = super.isEnabled();
        return isEnabled;
    }

    @Override
    protected boolean isEnabledForMultipleResources() {
        return true;
    }

    @Override
    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }

    @Override
    protected String getImageId() {
        return "Menu Diff";
    }

    @Override
    protected IResource[] getModifiedResources(IResource[] resources, IProgressMonitor iProgressMonitor) throws SVNException {
        ArrayList<IResource> modified = new ArrayList<IResource>();
        ArrayList<IResource> unversionedFolders = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            if (svnResource.getRepository() != null) {
                GetStatusCommand command = new GetStatusCommand(svnResource, true, false);
                command.run(iProgressMonitor);
                ISVNStatus[] statuses = command.getStatuses();
                int j = 0;
                while (j < statuses.length) {
                    ISVNLocalResource localResource;
                    IResource currentResource;
                    if ((SVNStatusUtils.isReadyForCommit((ISVNStatus)statuses[j]) || SVNStatusUtils.isMissing((ISVNStatus)statuses[j])) && (currentResource = SVNWorkspaceRoot.getResourceFor((IResource)resource, (ISVNStatus)statuses[j])) != null && !(localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)currentResource)).isIgnored()) {
                        if (!SVNStatusUtils.isManaged((ISVNStatus)statuses[j])) {
                            if (!this.isSymLink(currentResource)) {
                                if (currentResource.getType() != 1) {
                                    unversionedFolders.add(currentResource);
                                } else if (!modified.contains(currentResource)) {
                                    modified.add(currentResource);
                                    if (currentResource instanceof IContainer) {
                                        this.statusMap.put(currentResource, statuses[j].getPropStatus());
                                    } else {
                                        this.statusMap.put(currentResource, statuses[j].getTextStatus());
                                    }
                                    if (this.addToUnadded(currentResource)) {
                                        this.unaddedList.add(currentResource);
                                    }
                                }
                            }
                        } else if (!modified.contains(currentResource)) {
                            modified.add(currentResource);
                            if (currentResource instanceof IContainer) {
                                this.statusMap.put(currentResource, statuses[j].getPropStatus());
                            } else {
                                this.statusMap.put(currentResource, statuses[j].getTextStatus());
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        IResource[] unaddedResources = this.getUnaddedResources(unversionedFolders, iProgressMonitor);
        int i2 = 0;
        while (i2 < unaddedResources.length) {
            if (!modified.contains(unaddedResources[i2])) {
                if (unaddedResources[i2].getType() == 1) {
                    modified.add(unaddedResources[i2]);
                    this.statusMap.put(unaddedResources[i2], SVNStatusKind.UNVERSIONED);
                }
                if (this.addToUnadded(unaddedResources[i2])) {
                    this.unaddedList.add(unaddedResources[i2]);
                }
            }
            ++i2;
        }
        return modified.toArray(new IResource[modified.size()]);
    }

    private IResource[] getUnaddedResources(List resources, IProgressMonitor iProgressMonitor) throws SVNException {
        final ArrayList unadded = new ArrayList();
        final SVNException[] exception = new SVNException[1];
        for (IResource resource : resources) {
            if (!resource.exists()) continue;
            try {
                resource.accept(new IResourceVisitor(){

                    public boolean visit(IResource aResource) {
                        block6: {
                            ISVNLocalResource svnResource;
                            block5: {
                                svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)aResource);
                                if (!svnResource.isIgnored()) break block5;
                                return false;
                            }
                            if (!svnResource.isManaged()) break block6;
                            return true;
                        }
                        try {
                            if (aResource.getType() == 2 && GenerateDiffFileAction.this.isSymLink(aResource)) {
                                return false;
                            }
                        }
                        catch (SVNException e) {
                            exception[0] = e;
                        }
                        unadded.add(aResource);
                        return aResource.getType() == 2;
                    }
                }, 2, false);
            }
            catch (CoreException e) {
                throw SVNException.wrapException((CoreException)e);
            }
            if (exception[0] == null) continue;
            throw exception[0];
        }
        return unadded.toArray(new IResource[unadded.size()]);
    }

    protected boolean isSymLink(IResource resource) {
        File file;
        block3: {
            file = resource.getLocation().toFile();
            try {
                if (file.exists()) break block3;
                return true;
            }
            catch (IOException iOException) {
                return true;
            }
        }
        String cnnpath = file.getCanonicalPath();
        String abspath = file.getAbsolutePath();
        return !abspath.equals(cnnpath);
    }

    private boolean addToUnadded(IResource resource) {
        IResource parent = resource;
        while (parent != null) {
            if (!this.unaddedList.contains(parent = parent.getParent())) continue;
            return false;
        }
        return true;
    }
}

