/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RemoteResourceTransfer
extends ByteArrayTransfer {
    private static final String REMOTERESOURCENAME = "ISVNRemoteResource";
    private static final int REMOTERESOURCEID = RemoteResourceTransfer.registerType((String)"ISVNRemoteResource");
    private static RemoteResourceTransfer _instance = new RemoteResourceTransfer();

    public static RemoteResourceTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof ISVNRemoteResource)) {
            return;
        }
        if (this.isSupportedType(transferData)) {
            byte[] buffer = this.toByteArray((ISVNRemoteResource)object);
            super.javaToNative((Object)buffer, transferData);
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData)) {
            return null;
        }
        byte[] buffer = (byte[])super.nativeToJava(transferData);
        if (buffer == null) {
            return null;
        }
        return this.fromByteArray(buffer);
    }

    public byte[] toByteArray(ISVNRemoteResource remoteResource) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream writeOut = new DataOutputStream(out);
            writeOut.writeBoolean(remoteResource.isFolder());
            writeOut.writeUTF(remoteResource.getUrl().toString());
            writeOut.writeUTF(remoteResource.getRepository().getUrl().toString());
            writeOut.writeUTF(remoteResource.getRevision().toString());
            writeOut.writeUTF(remoteResource.getLastChangedRevision().toString());
            writeOut.writeLong(remoteResource.getDate().getTime());
            if (remoteResource.getAuthor() != null) {
                writeOut.writeUTF(remoteResource.getAuthor());
            }
            writeOut.close();
            return out.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Object fromByteArray(byte[] buffer) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(buffer);
            DataInputStream readIn = new DataInputStream(in);
            boolean isFolder = readIn.readBoolean();
            SVNUrl urlResource = new SVNUrl(readIn.readUTF());
            String location = readIn.readUTF();
            SVNRevision revision = SVNRevision.getRevision((String)readIn.readUTF());
            SVNRevision.Number lastChangedRevision = (SVNRevision.Number)SVNRevision.getRevision((String)readIn.readUTF());
            Date date = new Date(readIn.readLong());
            String author = null;
            try {
                author = readIn.readUTF();
            }
            catch (Exception exception) {}
            ISVNRepositoryLocation repositoryLocation = SVNProviderPlugin.getPlugin().getRepository(location);
            if (isFolder) {
                return new RemoteFolder(null, repositoryLocation, urlResource, revision, lastChangedRevision, date, author);
            }
            return new RemoteFile(null, repositoryLocation, urlResource, revision, lastChangedRevision, date, author);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String[] getTypeNames() {
        return new String[]{REMOTERESOURCENAME};
    }

    protected int[] getTypeIds() {
        return new int[]{REMOTERESOURCEID};
    }
}

