/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.compare.BaseDiffNode;
import org.tigris.subversion.subclipse.ui.compare.MultipleSelectionNode;
import org.tigris.subversion.subclipse.ui.compare.ResourceEditionNode;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalResourceNode;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public final class RevisionAwareDifferencer
extends Differencer {
    private static final int NODE_EQUAL = 0;
    private static final int NODE_NOT_EQUAL = 1;
    private static final int NODE_UNKNOWN = 2;
    private File[] diffFiles;
    private List changedResources;
    private SVNDiffSummary[] diffSummary;
    private String projectRelativePath;

    public RevisionAwareDifferencer() {
    }

    public RevisionAwareDifferencer(File[] diffFiles) {
        this.diffFiles = diffFiles;
    }

    public RevisionAwareDifferencer(SVNLocalResourceNode left, ResourceEditionNode right, File diffFile, SVNRevision pegRevision) {
        block9: {
            if (diffFile == null) {
                ISVNClientAdapter client = null;
                try {
                    try {
                        this.diffSummary = null;
                        client = SVNProviderPlugin.getPlugin().getSVNClientManager().getSVNClient();
                        if (pegRevision == null) {
                            pegRevision = SVNRevision.HEAD;
                        }
                        this.diffSummary = client.diffSummarize(left.getLocalResource().getUrl(), left.getLocalResource().getRevision(), right.getRemoteResource().getUrl(), right.getRemoteResource().getRevision(), 5, true);
                        this.projectRelativePath = left.getLocalResource().getResource().getProjectRelativePath().toString();
                        if (left.getLocalResource().isFolder() && this.projectRelativePath.length() > 0) {
                            this.projectRelativePath = String.valueOf(this.projectRelativePath) + "/";
                        }
                    }
                    catch (Exception exception) {
                        SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
                    throw throwable;
                }
                SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
            } else {
                this.diffFiles = new File[1];
                this.diffFiles[0] = diffFile;
            }
        }
    }

    protected boolean contentsEqual(Object input1, Object input2) {
        if (input1 instanceof MultipleSelectionNode) {
            return true;
        }
        int compare = input1 instanceof SVNLocalResourceNode ? this.compareStatusAndRevisions(input1, input2) : this.compareEditions(input1, input2);
        if (compare == 0) {
            return true;
        }
        if (compare == 1) {
            return false;
        }
        return super.contentsEqual(input1, input2);
    }

    protected Object visit(Object data, int result, Object ancestor, Object left, Object right) {
        return new BaseDiffNode((IDiffContainer)data, result, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
    }

    protected void updateProgress(IProgressMonitor progressMonitor, Object node) {
        if (node instanceof ITypedElement) {
            ITypedElement element = (ITypedElement)node;
            progressMonitor.subTask(Policy.bind("CompareEditorInput.fileProgress", new String[]{element.getName()}));
            progressMonitor.worked(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int compareStatusAndRevisions(Object left, Object right) {
        String rightLocation;
        ISVNLocalResource localResource = null;
        if (left instanceof SVNLocalResourceNode) {
            localResource = ((SVNLocalResourceNode)((Object)left)).getLocalResource();
        }
        ISVNRemoteResource edition = null;
        if (right instanceof ResourceEditionNode) {
            edition = ((ResourceEditionNode)right).getRemoteResource();
        }
        if (localResource == null) return 2;
        if (edition == null) {
            return 2;
        }
        if (localResource.isFolder() && edition.isContainer()) {
            return 0;
        }
        if (localResource.isFolder() != edition.isContainer()) {
            return 1;
        }
        String leftLocation = localResource.getRepository().getLocation();
        if (!leftLocation.equals(rightLocation = edition.getRepository().getLocation())) {
            return 2;
        }
        LocalResourceStatus localStatus = null;
        try {
            localStatus = localResource.getStatus();
            if (localStatus == null) {
                return 2;
            }
            if (!localResource.isDirty() && localResource.getResource().getProjectRelativePath().toString().equals(edition.getProjectRelativePath()) && localStatus.getLastChangedRevision().equals((Object)edition.getLastChangedRevision())) {
                return 0;
            }
            if (localResource.isDirty()) return 2;
            if (localResource.isFolder()) return 2;
            if (this.changedResources == null && this.diffFiles != null) {
                this.parseDiffs();
            }
            if (this.changedResources != null) {
                if (!this.changedResources.contains(localResource.getResource().getLocation().toString())) return 0;
                return 1;
            }
            int i = 0;
            while (true) {
                if (i >= this.diffSummary.length) {
                    return 0;
                }
                if (localResource.getResource().getProjectRelativePath().toString().equals(this.projectRelativePath)) return 1;
                if (localResource.getResource().getProjectRelativePath().toString().equals(String.valueOf(this.projectRelativePath) + this.diffSummary[i].getPath())) {
                    return 1;
                }
                ++i;
            }
        }
        catch (SVNException sVNException) {
            return 2;
        }
    }

    protected int compareEditions(Object left, Object right) {
        String rightLocation;
        ISVNRemoteResource leftEdition = null;
        if (left instanceof ResourceEditionNode) {
            leftEdition = ((ResourceEditionNode)left).getRemoteResource();
        }
        ISVNRemoteResource rightEdition = null;
        if (right instanceof ResourceEditionNode) {
            rightEdition = ((ResourceEditionNode)right).getRemoteResource();
        }
        if (leftEdition == null || rightEdition == null) {
            return 2;
        }
        if (leftEdition.isContainer() && rightEdition.isContainer()) {
            return 0;
        }
        if (leftEdition.isContainer() != rightEdition.isContainer()) {
            return 1;
        }
        String leftLocation = leftEdition.getRepository().getLocation();
        if (!leftLocation.equals(rightLocation = rightEdition.getRepository().getLocation())) {
            return 2;
        }
        if (leftEdition.getUrl().equals((Object)rightEdition.getUrl()) && leftEdition.getLastChangedRevision().equals((Object)rightEdition.getLastChangedRevision())) {
            return 0;
        }
        return 2;
    }

    private void parseDiffs() {
        this.changedResources = new ArrayList();
        int i = 0;
        while (i < this.diffFiles.length) {
            this.parseFile(this.diffFiles[i]);
            ++i;
        }
    }

    private void parseFile(File diffFile) {
        block15: {
            BufferedReader input = null;
            try {
                try {
                    input = new BufferedReader(new FileReader(diffFile));
                    String line = null;
                    while ((line = input.readLine()) != null) {
                        if (!line.startsWith("Index:")) continue;
                        this.changedResources.add(line.substring(7));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

