/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.conflicts;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.svnclientadapter.ISVNProperty;

public class PropertyConflict {
    private String propertyName;
    private String oldLocalValue;
    private String newLocalValue;
    private String oldIncomingValue;
    private String newIncomingValue;

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getOldLocalValue() {
        return this.oldLocalValue;
    }

    public void setOldLocalValue(String oldLocalValue) {
        this.oldLocalValue = oldLocalValue;
    }

    public String getNewLocalValue() {
        return this.newLocalValue;
    }

    public void setNewLocalValue(String newLocalValue) {
        this.newLocalValue = newLocalValue;
    }

    public String getOldIncomingValue() {
        return this.oldIncomingValue;
    }

    public void setOldIncomingValue(String oldIncomingValue) {
        this.oldIncomingValue = oldIncomingValue;
    }

    public String getNewIncomingValue() {
        return this.newIncomingValue;
    }

    public void setNewIncomingValue(String newIncomingValue) {
        this.newIncomingValue = newIncomingValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PropertyConflict) {
            PropertyConflict compareTo = (PropertyConflict)obj;
            return compareTo.getPropertyName().equals(this.propertyName);
        }
        return super.equals(obj);
    }

    public static PropertyConflict[] getPropertyConflicts(ISVNLocalResource svnResource) throws Exception {
        PropertyConflict[] propertyConflicts = null;
        String conflictFileContents = PropertyConflict.getConflictSummary(svnResource);
        if (conflictFileContents != null) {
            ArrayList<PropertyConflict> propertyConflictList = new ArrayList<PropertyConflict>();
            ISVNProperty[] properties = svnResource.getSvnProperties();
            int i = 0;
            while (i < properties.length) {
                if (conflictFileContents.indexOf("property '" + properties[i].getName() + "'") != -1) {
                    PropertyConflict conflict = new PropertyConflict();
                    conflict.setPropertyName(properties[i].getName());
                    propertyConflictList.add(conflict);
                }
                ++i;
            }
            propertyConflicts = new PropertyConflict[propertyConflictList.size()];
            propertyConflictList.toArray(propertyConflicts);
        }
        return propertyConflicts;
    }

    public static String getConflictSummary(ISVNLocalResource svnResource) throws Exception {
        String conflictSummary = null;
        IResource resource = svnResource.getResource();
        IFile conflictFile = null;
        if (resource instanceof IContainer) {
            conflictFile = ((IContainer)resource).getFile((IPath)new Path("dir_conflicts.prej"));
        } else {
            IContainer parent = resource.getParent();
            if (parent != null) {
                conflictFile = parent.getFile((IPath)new Path(String.valueOf(resource.getName()) + ".prej"));
            }
        }
        if (conflictFile != null && conflictFile.exists()) {
            conflictSummary = PropertyConflict.getConflictFileContents(new File(conflictFile.getLocation().toString()));
        }
        return conflictSummary;
    }

    private static String getConflictFileContents(File conflictFile) throws IOException {
        StringBuffer fileData = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(conflictFile));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }
}

