/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.conflicts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.tigris.subversion.subclipse.core.resources.SVNTreeConflict;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.conflicts.OpenFileInSystemEditorAction;
import org.tigris.subversion.subclipse.ui.conflicts.ResolveTreeConflictAction;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;

public class TreeConflictsView
extends ViewPart {
    public static final String VIEW_ID = "org.tigris.subversion.subclipse.ui.conflicts.TreeConflictsView";
    private IResource resource;
    private List treeConflicts;
    private ArrayList folderList;
    private TreeViewer treeViewer;
    private Action refreshAction;
    private OpenFileInSystemEditorAction openAction;
    private IDialogSettings settings = SVNUIPlugin.getPlugin().getDialogSettings();
    private boolean disposed;
    private static TreeConflictsView view;
    private String[] columnHeaders = new String[]{Policy.bind("TreeConflictsView.resource"), Policy.bind("TreeConflictsView.description")};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(75, 75, true), new ColumnWeightData(450, 450, true)};

    public TreeConflictsView() {
        view = this;
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        this.treeViewer = new TreeViewer(parent, 65536);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConflictsLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new ConflictsContentProvider());
        this.treeViewer.setUseHashlookup(true);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.treeViewer.getControl().setLayoutData((Object)layoutData);
        TableLayout tableLayout = new TableLayout();
        this.treeViewer.getTree().setLayout((Layout)tableLayout);
        DisposeListener disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TreeColumn col = (TreeColumn)e.getSource();
                if (col.getWidth() > 0) {
                    TreeConflictsView.this.settings.put("TreeConflictsView.col." + col.getText(), col.getWidth());
                }
            }
        };
        int i = 0;
        while (i < this.columnHeaders.length) {
            TreeColumn tc = new TreeColumn(this.treeViewer.getTree(), 0, i);
            tc.setResizable(this.columnLayouts[i].resizable);
            tc.setText(this.columnHeaders[i]);
            this.setColumnWidth(tableLayout, disposeListener, tc, i);
            ++i;
        }
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setLinesVisible(false);
        this.treeViewer.setInput((Object)this);
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent evt) {
                TreeConflictsView.this.openAction.run();
            }
        });
        this.createMenus();
        this.createToolbar();
        String path = this.settings.get("TreeConflictsView.resource");
        if (path != null) {
            boolean container = this.settings.getBoolean("TreeConflictsView.container");
            this.resource = container ? ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(path)) : ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
        }
        if (this.resource == null) {
            this.setContentDescription(Policy.bind("TreeConflictsView.noResource"));
        } else {
            this.setContentDescription(this.resource.getFullPath().toString());
        }
    }

    private void setColumnWidth(TableLayout layout, DisposeListener disposeListener, TreeColumn col, int colIndex) {
        String columnWidth = null;
        columnWidth = this.settings.get("TreeConflictsView.col." + col.getText());
        if (columnWidth == null || columnWidth.equals("0")) {
            layout.addColumnData(this.columnLayouts[colIndex]);
        } else {
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(Integer.parseInt(columnWidth), true));
        }
        col.addDisposeListener(disposeListener);
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void showTreeConflictsFor(IResource resource) {
        this.resource = resource;
        this.refreshAction.setEnabled(true);
        this.setContentDescription(resource.getFullPath().toString());
        if (resource.getFullPath() != null) {
            this.settings.put("TreeConflictsView.resource", resource.getLocation().toString());
            this.settings.put("TreeConflictsView.container", resource instanceof IContainer);
        }
        this.refresh();
    }

    public void dispose() {
        this.disposed = true;
        super.dispose();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public IResource getResource() {
        return this.resource;
    }

    public static boolean refresh(IResource[] resources) {
        if (view == null || view.isDisposed() || view.getResource() == null) {
            return false;
        }
        int i = 0;
        while (i < resources.length) {
            if (view.getResource().equals((Object)resources[i]) || resources[i].getFullPath().toString().startsWith(view.getResource().getFullPath().toString())) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        view.refresh();
                    }
                });
                return true;
            }
            ++i;
        }
        return false;
    }

    public void refresh() {
        if (this.disposed || this.resource == null) {
            return;
        }
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                TreeConflictsView.this.folderList = new ArrayList();
                TreeConflictsView.this.treeConflicts = new ArrayList();
                ISVNClientAdapter client = null;
                try {
                    try {
                        client = SVNWorkspaceRoot.getSVNResourceFor((IResource)TreeConflictsView.this.resource).getRepository().getSVNClient();
                        ISVNStatus[] statuses = client.getStatus(TreeConflictsView.this.resource.getLocation().toFile(), true, false, true);
                        int i = 0;
                        while (i < statuses.length) {
                            if (statuses[i].hasTreeConflict()) {
                                IContainer parent;
                                SVNTreeConflict treeConflict = new SVNTreeConflict(statuses[i]);
                                IResource treeConflictResource = treeConflict.getResource();
                                if (treeConflictResource instanceof IContainer && !TreeConflictsView.this.folderList.contains(treeConflictResource)) {
                                    TreeConflictsView.this.folderList.add(treeConflict);
                                }
                                if (!(treeConflictResource instanceof IContainer || (parent = treeConflictResource.getParent()) == null || parent instanceof IWorkspaceRoot || TreeConflictsView.this.folderList.contains(parent))) {
                                    TreeConflictsView.this.folderList.add(parent);
                                }
                                TreeConflictsView.this.treeConflicts.add(treeConflict);
                            }
                            ++i;
                        }
                        TreeConflictsView.this.treeViewer.refresh();
                        TreeConflictsView.this.treeViewer.expandAll();
                    }
                    catch (Exception e) {
                        SVNUIPlugin.log(4, e.getMessage(), e);
                        SVNWorkspaceRoot.getSVNResourceFor((IResource)TreeConflictsView.this.resource).getRepository().returnSVNClient(client);
                    }
                }
                finally {
                    SVNWorkspaceRoot.getSVNResourceFor((IResource)TreeConflictsView.this.resource).getRepository().returnSVNClient(client);
                }
            }
        });
    }

    private void createMenus() {
        this.openAction = new OpenFileInSystemEditorAction(this.getSite().getPage(), (ISelectionProvider)this.treeViewer);
        MenuManager menuMgr = new MenuManager("#TreeConflictsViewPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TreeConflictsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    private void createToolbar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)this.getRefreshAction());
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.update(false);
    }

    private Action getRefreshAction() {
        if (this.refreshAction == null) {
            this.refreshAction = new Action(Policy.bind("TreeConflictsView.refresh"), SVNUIPlugin.getPlugin().getImageDescriptor("elcl16/refresh.gif")){

                public void run() {
                    TreeConflictsView.this.refresh();
                }
            };
            this.refreshAction.setToolTipText(Policy.bind("TreeConflictsView.refreshView"));
            this.refreshAction.setDisabledImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("dlcl16/refresh.gif"));
            this.refreshAction.setHoverImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("clcl16/refresh.gif"));
            if (this.resource == null) {
                this.refreshAction.setEnabled(false);
            }
        }
        return this.refreshAction;
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.resource != null) {
            SVNTreeConflict treeConflict;
            boolean conflictSelected = false;
            boolean enableOpen = false;
            IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
            for (Object element : selection) {
                if (!(element instanceof SVNTreeConflict)) continue;
                conflictSelected = true;
                treeConflict = (SVNTreeConflict)element;
                if (!(treeConflict.getResource() instanceof IFile) || !treeConflict.getResource().exists()) continue;
                enableOpen = true;
                break;
            }
            if (enableOpen) {
                manager.add((IAction)this.openAction);
            }
            if (enableOpen && selection.size() == 1) {
                MenuManager submenu = new MenuManager(Policy.bind("TreeConflictsView.openWith"));
                treeConflict = (SVNTreeConflict)selection.getFirstElement();
                submenu.add((IContributionItem)new OpenWithMenu(this.getSite().getPage(), (IAdaptable)treeConflict.getResource()));
                manager.add((IContributionItem)submenu);
            }
            manager.add((IContributionItem)new Separator());
            if (selection.size() == 1) {
                if (conflictSelected) {
                    manager.add((IAction)new ResolveTreeConflictAction((ISelectionProvider)this.treeViewer, (IWorkbenchPart)this));
                }
                PropertyDialogAction propertiesAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)Display.getDefault().getActiveShell()), (ISelectionProvider)this.treeViewer);
                manager.add((IAction)propertiesAction);
                manager.add((IContributionItem)new Separator());
            }
            manager.add((IAction)this.getRefreshAction());
        }
    }

    class ConflictsContentProvider
    extends WorkbenchContentProvider {
        ConflictsContentProvider() {
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof SVNTreeConflict) {
                return ((SVNTreeConflict)element).getResource() instanceof IContainer;
            }
            return true;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (TreeConflictsView.this.treeConflicts == null) {
                return new Object[0];
            }
            if (parentElement instanceof TreeConflictsView) {
                Object[] folderArray = new Object[TreeConflictsView.this.folderList.size()];
                TreeConflictsView.this.folderList.toArray(folderArray);
                this.sort(folderArray);
                return folderArray;
            }
            if (parentElement instanceof IContainer) {
                return this.getFolderChildren((IResource)parentElement);
            }
            if (parentElement instanceof SVNTreeConflict && ((SVNTreeConflict)parentElement).getResource() instanceof IContainer) {
                return this.getFolderChildren(((SVNTreeConflict)parentElement).getResource());
            }
            return new Object[0];
        }

        private Object[] getFolderChildren(IResource parentElement) {
            ArrayList<SVNTreeConflict> childList = new ArrayList<SVNTreeConflict>();
            for (SVNTreeConflict treeConflict : TreeConflictsView.this.treeConflicts) {
                if (treeConflict.getResource() instanceof IContainer || treeConflict.getResource().getParent() == null || !treeConflict.getResource().getParent().getFullPath().toString().equals(parentElement.getFullPath().toString())) continue;
                childList.add(treeConflict);
            }
            Object[] children = new Object[childList.size()];
            childList.toArray(children);
            this.sort(children);
            return children;
        }

        private void sort(Object[] items) {
            Arrays.sort(items, new Comparator(){

                public int compare(Object o1, Object o2) {
                    IResource r2;
                    SVNTreeConflict tc;
                    IResource r1;
                    if (o1 instanceof IResource) {
                        r1 = (IResource)o1;
                    } else {
                        tc = (SVNTreeConflict)o1;
                        r1 = tc.getResource();
                    }
                    if (o2 instanceof IResource) {
                        r2 = (IResource)o2;
                    } else {
                        tc = (SVNTreeConflict)o2;
                        r2 = tc.getResource();
                    }
                    return r1.getFullPath().toString().compareTo(r2.getFullPath().toString());
                }
            });
        }
    }

    class ConflictsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ConflictsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                IResource elementResource = element instanceof SVNTreeConflict ? ((SVNTreeConflict)element).getResource() : (IResource)element;
                Image image = !elementResource.exists() && elementResource.getName().indexOf(".") == -1 ? WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider().getImage((Object)ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(elementResource.getFullPath().toString()))) : WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider().getImage((Object)elementResource);
                return image;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof SVNTreeConflict) {
                        SVNTreeConflict treeConflict = (SVNTreeConflict)element;
                        if (treeConflict.getResource() instanceof IContainer) {
                            return treeConflict.getResource().getFullPath().toString();
                        }
                        return treeConflict.getResource().getName();
                    }
                    return ((IResource)element).getFullPath().toString();
                }
                case 1: {
                    if (element instanceof SVNTreeConflict) {
                        return ((SVNTreeConflict)element).getDescription();
                    }
                    return "";
                }
            }
            return null;
        }
    }
}

