/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNExternal;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.BranchTagCommand;
import org.tigris.subversion.subclipse.core.commands.GetRemoteResourceCommand;
import org.tigris.subversion.subclipse.core.commands.SwitchToUrlCommand;
import org.tigris.subversion.subclipse.core.history.Alias;
import org.tigris.subversion.subclipse.core.history.AliasManager;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.operations.RepositoryProviderOperation;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class BranchTagOperation
extends RepositoryProviderOperation {
    private SVNUrl[] sourceUrls;
    private SVNUrl destinationUrl;
    private SVNRevision revision;
    private boolean createOnServer;
    private boolean makeParents;
    private String message;
    private Alias newAlias;
    private boolean switchAfterTagBranch;
    private boolean branchCreated = false;
    private boolean multipleTransactions = true;
    private SVNExternal[] svnExternals;

    public BranchTagOperation(IWorkbenchPart part, IResource[] resources, SVNUrl[] sourceUrls, SVNUrl destinationUrl, boolean createOnServer, SVNRevision revision, String message) {
        super(part, resources);
        this.sourceUrls = sourceUrls;
        this.destinationUrl = destinationUrl;
        this.createOnServer = createOnServer;
        this.revision = revision;
        this.message = message;
    }

    @Override
    protected String getTaskName() {
        return Policy.bind("BranchTagOperation.taskName");
    }

    @Override
    protected String getTaskName(SVNTeamProvider provider) {
        return Policy.bind("BranchTagOperation.0", provider.getProject().getName());
    }

    @Override
    protected void execute(SVNTeamProvider provider, IResource[] resources, IProgressMonitor monitor) throws SVNException, InterruptedException {
        block30: {
            if (this.branchCreated) {
                return;
            }
            this.branchCreated = true;
            monitor.beginTask(null, 100);
            try {
                try {
                    BranchTagCommand command = new BranchTagCommand(provider.getSVNWorkspaceRoot(), this.getResources(), this.sourceUrls, this.destinationUrl, this.message, this.createOnServer, this.revision);
                    command.setMakeParents(this.makeParents);
                    command.setMultipleTransactions(this.multipleTransactions);
                    command.run(Policy.subMonitorFor(monitor, 1000));
                    if (this.svnExternals != null) {
                        ArrayList<SVNUrl> copyToUrls = new ArrayList<SVNUrl>();
                        ArrayList<String> fileList = new ArrayList<String>();
                        HashMap<String, String> copyToMap = new HashMap<String, String>();
                        SVNExternal[] sVNExternalArray = this.svnExternals;
                        int n = this.svnExternals.length;
                        int n2 = 0;
                        while (n2 < n) {
                            SVNExternal svnExternal = sVNExternalArray[n2];
                            if (svnExternal.isSelected() && !fileList.contains(svnExternal.getFile().getAbsolutePath())) {
                                fileList.add(svnExternal.getFile().getAbsolutePath());
                                IResource[] localResources = SVNWorkspaceRoot.getResourcesFor((IPath)new Path(svnExternal.getFile().getPath()));
                                ISVNRemoteResource remoteResource = SVNWorkspaceRoot.getBaseResourceFor((IResource)localResources[0]);
                                SVNUrl[] sVNUrlArray = this.sourceUrls;
                                int n3 = this.sourceUrls.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    SVNUrl sourceUrl = sVNUrlArray[n4];
                                    if (remoteResource.getUrl().toString().startsWith(sourceUrl.toString())) {
                                        SVNUrl copyToUrl = null;
                                        SVNUrl destinationUrl = command.getDestinationUrl(sourceUrl.toString());
                                        if (remoteResource.getUrl().toString().equals(sourceUrl.toString())) {
                                            copyToUrl = destinationUrl;
                                        } else {
                                            try {
                                                copyToUrl = new SVNUrl(destinationUrl + remoteResource.getUrl().toString().substring(sourceUrl.toString().length()));
                                            }
                                            catch (MalformedURLException malformedURLException) {}
                                        }
                                        if (copyToUrl == null) break;
                                        copyToUrls.add(copyToUrl);
                                        copyToMap.put(copyToUrl.toString(), svnExternal.getFile().getAbsolutePath());
                                        break;
                                    }
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                        if (copyToUrls.size() > 0) {
                            ISVNClientAdapter svnClient = null;
                            try {
                                try {
                                    svnClient = provider.getSVNWorkspaceRoot().getRepository().getSVNClient();
                                    for (SVNUrl copyToUrl : copyToUrls) {
                                        String updatedProperty = this.getUpdatedSvnExternalsProperty(copyToUrl, copyToMap);
                                        ISVNInfo info = svnClient.getInfo(copyToUrl);
                                        svnClient.propertySet(copyToUrl, info.getRevision(), "svn:externals", updatedProperty, Policy.bind("BranchTagOperation.3"));
                                    }
                                }
                                catch (Exception e) {
                                    throw SVNException.wrapException((Exception)e);
                                }
                            }
                            finally {
                                provider.getSVNWorkspaceRoot().getRepository().returnSVNClient(svnClient);
                            }
                        }
                    }
                    SVNUIPlugin.getPlugin().getRepositoryManager().resourceCreated(null, null);
                    if (this.newAlias != null) {
                        this.updateBranchTagProperty(resources[0]);
                    }
                    if (!this.switchAfterTagBranch) break block30;
                    int i = 0;
                    while (i < this.sourceUrls.length) {
                        SVNUrl switchDestinationUrl = command.getDestinationUrl(this.sourceUrls[i].toString());
                        GetRemoteResourceCommand getRemoteResourceCommand = new GetRemoteResourceCommand(provider.getSVNWorkspaceRoot().getRepository(), switchDestinationUrl, SVNRevision.HEAD);
                        try {
                            getRemoteResourceCommand.run(null);
                        }
                        catch (SVNException e) {
                            if (e.getStatus().getCode() == -6) {
                                switchDestinationUrl = this.destinationUrl;
                            }
                            throw e;
                        }
                        resources = this.getResources();
                        SwitchToUrlCommand switchToUrlCommand = new SwitchToUrlCommand(provider.getSVNWorkspaceRoot(), resources[i], switchDestinationUrl, SVNRevision.HEAD);
                        switchToUrlCommand.run(Policy.subMonitorFor(monitor, 100));
                        ++i;
                    }
                }
                catch (SVNException e) {
                    if (e.operationInterrupted()) {
                        this.showCancelledMessage();
                    } else {
                        this.collectStatus(e.getStatus());
                    }
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    @Override
    protected ISchedulingRule getSchedulingRule(SVNTeamProvider provider) {
        IResource[] resources = this.getResources();
        if (resources == null) {
            return super.getSchedulingRule(provider);
        }
        IResourceRuleFactory ruleFactory = provider.getRuleFactory();
        HashSet<ISchedulingRule> rules = new HashSet<ISchedulingRule>();
        int i = 0;
        while (i < resources.length) {
            rules.add(ruleFactory.modifyRule((IResource)resources[i].getProject()));
            ++i;
        }
        return MultiRule.combine((ISchedulingRule[])rules.toArray(new ISchedulingRule[rules.size()]));
    }

    private String getUpdatedSvnExternalsProperty(SVNUrl copyToUrl, Map<String, String> copyToMap) {
        String filePath = copyToMap.get(copyToUrl.toString());
        StringBuffer updatedProperty = new StringBuffer();
        SVNExternal[] sVNExternalArray = this.svnExternals;
        int n = this.svnExternals.length;
        int n2 = 0;
        while (n2 < n) {
            SVNExternal checkExternal = sVNExternalArray[n2];
            if (checkExternal.getFile().getAbsolutePath().equals(filePath)) {
                if (updatedProperty.length() > 0) {
                    updatedProperty.append("\n");
                }
                updatedProperty.append(checkExternal.toString());
            }
            ++n2;
        }
        return updatedProperty.toString();
    }

    private void updateBranchTagProperty(IResource resource) {
        AliasManager aliasManager = new AliasManager(resource, false);
        Alias[] branchAliases = aliasManager.getBranches();
        Alias[] tagAliases = aliasManager.getTags();
        StringBuffer propertyValue = new StringBuffer();
        int i = 0;
        while (i < branchAliases.length) {
            if (branchAliases[i].getRevision() > 0) {
                if (propertyValue.length() > 0) {
                    propertyValue.append("\n");
                }
                Alias branch = branchAliases[i];
                propertyValue.append(String.valueOf(branch.getRevision()) + "," + branch.getName());
                if (branch.getRelativePath() != null) {
                    propertyValue.append("," + branch.getRelativePath());
                }
                if (branch.isBranch()) {
                    propertyValue.append(",branch");
                } else {
                    propertyValue.append(",tag");
                }
            }
            ++i;
        }
        i = 0;
        while (i < tagAliases.length) {
            if (tagAliases[i].getRevision() > 0) {
                if (propertyValue.length() > 0) {
                    propertyValue.append("\n");
                }
                Alias tag = tagAliases[i];
                propertyValue.append(String.valueOf(tag.getRevision()) + "," + tag.getName());
                if (tag.getRelativePath() != null) {
                    propertyValue.append("," + tag.getRelativePath());
                }
                if (tag.isBranch()) {
                    propertyValue.append(",branch");
                } else {
                    propertyValue.append(",tag");
                }
            }
            ++i;
        }
        if (propertyValue.length() > 0) {
            propertyValue.append("\n");
        }
        propertyValue.append(String.valueOf(this.newAlias.getRevision()) + "," + this.newAlias.getName() + "," + this.newAlias.getRelativePath());
        if (this.newAlias.isBranch()) {
            propertyValue.append(",branch");
        } else {
            propertyValue.append(",tag");
        }
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
        try {
            svnResource.setSvnProperty("subclipse:tags", propertyValue.toString(), false);
        }
        catch (SVNException sVNException) {}
    }

    public void setNewAlias(Alias newAlias) {
        this.newAlias = newAlias;
    }

    public void switchAfterTagBranchOperation(boolean switchAfterTagBranchOperation) {
        this.switchAfterTagBranch = switchAfterTagBranchOperation;
    }

    public void setMakeParents(boolean makeParents) {
        this.makeParents = makeParents;
    }

    public void setMultipleTransactions(boolean multipleTransactions) {
        this.multipleTransactions = multipleTransactions;
    }

    public void setSvnExternals(SVNExternal[] svnExternals) {
        this.svnExternals = svnExternals;
    }
}

