/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.ImportCommand;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.operations.SVNOperation;

public class ImportOperation
extends SVNOperation {
    private File directory;
    private ISVNRemoteFolder folder;
    private String commitComment;
    private boolean recurse;

    public ImportOperation(IWorkbenchPart part, ISVNRemoteFolder folder, File directory, String comment, boolean recurse) {
        super(part);
        this.folder = folder;
        this.directory = directory;
        this.commitComment = comment;
        this.recurse = recurse;
    }

    @Override
    protected String getTaskName() {
        return Policy.bind("ImportOperation.taskName");
    }

    protected String getTaskName(SVNTeamProvider provider) {
        return Policy.bind("ImportOperation.0", this.directory.toString());
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws SVNException, InterruptedException {
        monitor.beginTask(null, 100);
        try {
            try {
                ImportCommand command = new ImportCommand(this.folder, this.directory, this.commitComment, this.recurse);
                command.run(monitor);
            }
            catch (SVNException e) {
                if (e.operationInterrupted()) {
                    this.showCancelledMessage();
                } else {
                    this.collectStatus(e.getStatus());
                }
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

