/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.ui.synchronize.ChangeSetDiffNode;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.subscriber.CommitSynchronizeOperation;

public class CommitSynchronizeAction
extends SynchronizeModelAction {
    private ArrayList changeSets;

    public CommitSynchronizeAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    public CommitSynchronizeAction(String text, ISynchronizePageConfiguration configuration, ISelectionProvider selectionProvider) {
        super(text, configuration, selectionProvider);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4});
    }

    private static void collectAllNodes(IDiffElement element, Set nodes, List selected) {
        boolean added = false;
        if (element.getKind() != 0) {
            nodes.add(element);
            added = true;
        }
        if (element instanceof IDiffContainer) {
            if (added) {
                int i = 0;
                while (i < selected.size()) {
                    Object object = selected.get(i);
                    if (object instanceof IDiffElement && object != element) {
                        IDiffContainer parent = ((IDiffElement)object).getParent();
                        while (parent != null) {
                            if (parent == element) {
                                return;
                            }
                            parent = parent.getParent();
                        }
                    }
                    ++i;
                }
            }
            IDiffElement[] children = ((IDiffContainer)element).getChildren();
            int i = 0;
            while (i < children.length) {
                CommitSynchronizeAction.collectAllNodes(children[i], nodes, selected);
                ++i;
            }
        }
    }

    protected final IDiffElement[] getFilteredDiffElementsOverride() {
        List selected = this.getStructuredSelection().toList();
        HashSet result = new HashSet();
        int i = 0;
        while (i < selected.size()) {
            Object object = selected.get(i);
            if (object instanceof IDiffElement) {
                CommitSynchronizeAction.collectAllNodes((IDiffElement)object, result, selected);
            }
            ++i;
        }
        Iterator it = result.iterator();
        ArrayList<IDiffElement> filtered = new ArrayList<IDiffElement>();
        while (it.hasNext()) {
            SyncInfo info;
            IDiffElement e = (IDiffElement)it.next();
            if (!(e instanceof SyncInfoModelElement) || (info = ((SyncInfoModelElement)e).getSyncInfo()) == null || !this.getSyncInfoFilter().select(info)) continue;
            filtered.add(e);
        }
        return filtered.toArray(new IDiffElement[filtered.size()]);
    }

    protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        this.changeSets = new ArrayList();
        elements = this.getFilteredDiffElementsOverride();
        String url = null;
        ChangeSet changeSet = null;
        IStructuredSelection selection = this.getStructuredSelection();
        Iterator iter = selection.iterator();
        String proposedComment = "";
        while (iter.hasNext()) {
            ISynchronizeModelElement synchronizeModelElement = (ISynchronizeModelElement)iter.next();
            proposedComment = this.getProposedComment(proposedComment, synchronizeModelElement);
            if (!(synchronizeModelElement instanceof ChangeSetDiffNode)) {
                IResource resource;
                if (url != null || selection.size() != 1 || (resource = synchronizeModelElement.getResource()) == null) continue;
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                try {
                    url = svnResource.getStatus().getUrlString();
                    if (url != null && resource.getType() != 1) continue;
                    url = Util.getParentUrl((ISVNLocalResource)svnResource);
                }
                catch (SVNException e) {
                    if (e.operationInterrupted()) continue;
                    SVNUIPlugin.log(4, e.getMessage(), e);
                }
                continue;
            }
            if (selection.size() != 1) continue;
            ChangeSetDiffNode changeSetDiffNode = (ChangeSetDiffNode)synchronizeModelElement;
            changeSet = changeSetDiffNode.getSet();
        }
        CommitSynchronizeOperation operation = new CommitSynchronizeOperation(configuration, elements, url, proposedComment);
        operation.setChangeSet(changeSet);
        return operation;
    }

    private String getProposedComment(String proposedComment, ISynchronizeModelElement synchronizeModelElement) {
        ChangeSet set;
        if (synchronizeModelElement instanceof ChangeSetDiffNode && !this.changeSets.contains(set = ((ChangeSetDiffNode)synchronizeModelElement).getSet())) {
            this.changeSets.add(set);
            if (proposedComment.length() > 0) {
                proposedComment = String.valueOf(proposedComment) + System.getProperty("line.separator");
            }
            return String.valueOf(proposedComment) + set.getComment();
        }
        IDiffContainer parent = synchronizeModelElement.getParent();
        while (parent != null) {
            if (parent instanceof ChangeSetDiffNode) {
                ChangeSet set2 = ((ChangeSetDiffNode)parent).getSet();
                if (!this.changeSets.contains(set2)) {
                    this.changeSets.add(set2);
                    if (proposedComment.length() > 0) {
                        proposedComment = String.valueOf(proposedComment) + System.getProperty("line.separator");
                    }
                    return String.valueOf(proposedComment) + set2.getComment();
                }
                parent = parent.getParent();
                continue;
            }
            parent = parent.getParent();
        }
        return proposedComment;
    }
}

