/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.svnproperties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.tigris.subversion.subclipse.core.IResourceStateChangeListener;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.conflicts.PropertyConflict;
import org.tigris.subversion.subclipse.ui.settings.UnversionedCustomProperty;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class SvnRevPropertiesView
extends ViewPart {
    public static final String VIEW_ID = "org.tigris.subversion.subclipse.ui.svnproperties.SvnRevPropertiesView";
    private TableViewer tableViewer;
    private TextViewer textViewer;
    private ISVNLocalResource resource;
    private ISVNRemoteResource remoteResource;
    private Action refreshAction;
    private Label statusLabel;
    private PropertyConflict[] conflicts;

    private TableViewer createTable(Composite parent) {
        Table table = new Table(parent, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData(1808);
        table.setLayoutData((Object)gridData);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(table);
        this.createColumns(table, layout);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PropertiesLabelProvider());
        return this.tableViewer;
    }

    protected TextViewer createText(Composite parent) {
        return new TextViewer(parent, 586);
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        this.statusLabel = new Label(parent, 16384);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.statusLabel.setLayoutData((Object)gridData);
        SashForm sashForm = new SashForm(parent, 512);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.tableViewer = this.createTable((Composite)sashForm);
        this.textViewer = this.createText((Composite)sashForm);
        sashForm.setWeights(new int[]{70, 30});
        this.contributeActions();
    }

    private Action getRefreshAction() {
        if (this.refreshAction == null) {
            SVNUIPlugin plugin = SVNUIPlugin.getPlugin();
            this.refreshAction = new Action(Policy.bind("SvnPropertiesView.refreshLabel"), plugin.getImageDescriptor("elcl16/refresh.gif")){

                public void run() {
                    try {
                        if (SvnRevPropertiesView.this.resource != null) {
                            SvnRevPropertiesView.this.showSvnProperties(SvnRevPropertiesView.this.resource);
                        } else if (SvnRevPropertiesView.this.remoteResource != null) {
                            SvnRevPropertiesView.this.showSvnProperties(SvnRevPropertiesView.this.remoteResource);
                        }
                    }
                    catch (SVNException sVNException) {}
                    SvnRevPropertiesView.this.refresh();
                }
            };
            this.refreshAction.setToolTipText(Policy.bind("SvnPropertiesView.refresh"));
            this.refreshAction.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/refresh.gif"));
            this.refreshAction.setHoverImageDescriptor(plugin.getImageDescriptor("clcl16/refresh.gif"));
        }
        return this.refreshAction;
    }

    public void contributeActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.add((IAction)this.getRefreshAction());
        tbm.update(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.tableViewer.getControl(), "org.tigris.subversion.subclipse.ui.rev_properties_view_context");
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection == null || !(selection instanceof IStructuredSelection)) {
                    SvnRevPropertiesView.this.textViewer.setDocument((IDocument)new Document(""));
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                if (ss.size() != 1) {
                    SvnRevPropertiesView.this.textViewer.setDocument((IDocument)new Document(""));
                    return;
                }
                ISVNProperty property = (ISVNProperty)ss.getFirstElement();
                SvnRevPropertiesView.this.textViewer.setDocument((IDocument)new Document(property.getValue()));
            }
        });
    }

    private void createColumns(Table table, TableLayout layout) {
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(false);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("SvnPropertiesView.propertyName"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("SvnPropertiesView.propertyValue"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(120, true));
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public void refresh() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ISVNProperty[] props = SvnRevPropertiesView.this.getSvnRevProperties();
                    SvnRevPropertiesView.this.tableViewer.setInput((Object)props);
                    SvnRevPropertiesView.this.tableViewer.refresh();
                }
                catch (SVNException sVNException) {}
            }
        });
    }

    private void updateStatus() {
        this.conflicts = null;
        if (this.resource == null && this.remoteResource == null) {
            this.statusLabel.setText("");
            return;
        }
        if (this.resource != null) {
            try {
                LocalResourceStatus status = this.resource.getStatus();
                if (!this.resource.isManaged()) {
                    this.statusLabel.setText(Policy.bind("SvnPropertiesView.resourceNotManaged"));
                } else if (status.getPropStatus().equals((Object)SVNStatusKind.MODIFIED)) {
                    this.statusLabel.setText(Policy.bind("SvnPropertiesView.somePropertiesModified"));
                } else if (status.getPropStatus().equals((Object)SVNStatusKind.NORMAL)) {
                    this.statusLabel.setText(Policy.bind("SvnPropertiesView.noPropertiesModified"));
                } else if (status.getPropStatus().equals((Object)SVNStatusKind.CONFLICTED)) {
                    this.statusLabel.setText(Policy.bind("SvnPropertiesView.conflictOnProperties"));
                    try {
                        this.conflicts = PropertyConflict.getPropertyConflicts(this.resource);
                    }
                    catch (Exception exception) {}
                } else {
                    this.statusLabel.setText("");
                }
            }
            catch (SVNException sVNException) {
                this.statusLabel.setText(Policy.bind("SvnPropertiesView.errorGettingStatus"));
            }
        }
    }

    public void clearSvnProperties() {
        this.setContentDescription("");
        this.updateStatus();
    }

    public void showSvnProperties(ISVNLocalResource resource) throws SVNException {
        this.resource = resource;
        this.remoteResource = null;
        if (resource != null) {
            if (resource.isManaged()) {
                if (resource.getRevision() != null) {
                    this.setContentDescription(Policy.bind("SvnRevPropertiesView.titleWithTwoArguments", resource.getRevision().toString(), resource.getName()));
                }
            } else {
                this.setContentDescription(Policy.bind("SvnRevPropertiesView.titleWithOneArgument", resource.getName()));
            }
        } else {
            this.setContentDescription("");
        }
        this.updateStatus();
    }

    public void showSvnProperties(ISVNRemoteResource resource) throws SVNException {
        this.remoteResource = resource;
        this.resource = null;
        if (this.remoteResource != null) {
            if (this.remoteResource.getRevision() != null) {
                this.setContentDescription(Policy.bind("SvnRevPropertiesView.titleWithTwoArguments", this.remoteResource.getRevision().toString(), this.remoteResource.getName()));
            }
        } else {
            this.setContentDescription("");
        }
        this.updateStatus();
    }

    private ISVNProperty[] getSvnRevProperties() throws SVNException {
        if (this.resource != null && this.resource.isManaged()) {
            SVNRevision rev = this.resource.getRevision();
            ISVNRemoteResource remoteResource = this.resource.getRemoteResource(rev);
            return UnversionedCustomProperty.getSvnRevisionProperties(remoteResource.getUrl(), rev, null);
        }
        if (this.remoteResource != null) {
            SVNRevision rev = this.remoteResource.getRevision();
            return UnversionedCustomProperty.getSvnRevisionProperties(this.remoteResource.getUrl(), rev, null);
        }
        return null;
    }

    class PropertiesLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element != null && SvnRevPropertiesView.this.conflicts != null) {
                ISVNProperty svnProperty = (ISVNProperty)element;
                int i = 0;
                while (i < SvnRevPropertiesView.this.conflicts.length) {
                    if (SvnRevPropertiesView.this.conflicts[i].getPropertyName().equals(svnProperty.getName())) {
                        return SVNUIPlugin.getImage("ovr16/prop_conflicted_ov.gif");
                    }
                    ++i;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == null) {
                return "";
            }
            ISVNProperty svnProperty = (ISVNProperty)element;
            String result = null;
            switch (columnIndex) {
                case 1: {
                    result = svnProperty.getName();
                    break;
                }
                case 2: {
                    result = svnProperty.getValue();
                }
            }
            if (result == null) {
                result = "";
            }
            return result;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class ResourceStateChangeListener
    implements IResourceStateChangeListener {
        ResourceStateChangeListener() {
        }

        public void resourceSyncInfoChanged(IResource[] changedResources) {
            int i = 0;
            while (i < changedResources.length) {
                if (SvnRevPropertiesView.this.resource != null && changedResources[i].equals((Object)SvnRevPropertiesView.this.resource.getIResource())) {
                    SvnRevPropertiesView.this.refresh();
                }
                ++i;
            }
        }

        public void resourceModified(IResource[] changedResources) {
        }

        public void projectConfigured(IProject project) {
        }

        public void projectDeconfigured(IProject project) {
        }

        public void initialize() {
        }
    }
}

