/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.text.ParseException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.ui.DepthComboHelper;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.wizards.CheckoutWizard;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CheckoutWizardCheckoutAsMultiplePage
extends WizardPage {
    private Label textLabel;
    private Button projectsButton;
    private Text projectNamePrefixText;
    private Text projectNameSuffixText;
    private Label previewText;
    private Button existingButton;
    private Text revisionText;
    private Button headButton;
    private Combo depthCombo;
    private Button ignoreExternalsButton;
    private Button forceButton;
    private static final int REVISION_WIDTH_HINT = 40;
    private static final int NAME_WIDTH_HINT = 60;

    public CheckoutWizardCheckoutAsMultiplePage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        CheckoutWizard wizard = (CheckoutWizard)this.getWizard();
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        outerContainer.setLayout((Layout)layout);
        outerContainer.setLayoutData((Object)new GridData(768));
        this.textLabel = new Label(outerContainer, 0);
        GridData data = new GridData(768);
        this.textLabel.setLayoutData((Object)data);
        if (wizard.getRemoteFolders() != null) {
            this.textLabel.setText(Policy.bind("CheckoutWizardCheckoutAsPage.multiple", Integer.toString(wizard.getRemoteFolders().length)));
        }
        this.projectsButton = new Button(outerContainer, 16);
        this.projectsButton.setText(Policy.bind("CheckoutWizardCheckoutAsPage.projects"));
        Group projectGroup = new Group(outerContainer, 0);
        projectGroup.setText(Policy.bind("CheckoutWizardCheckoutAsPage.projectNaming"));
        GridLayout projectLayout = new GridLayout();
        projectLayout.numColumns = 4;
        projectGroup.setLayout((Layout)projectLayout);
        projectGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.projectNamePrefixText = new Text((Composite)projectGroup, 2048);
        data = new GridData();
        data.widthHint = 60;
        this.projectNamePrefixText.setLayoutData((Object)data);
        this.projectNamePrefixText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CheckoutWizard wizard = (CheckoutWizard)CheckoutWizardCheckoutAsMultiplePage.this.getWizard();
                wizard.setProjectNamePrefix(CheckoutWizardCheckoutAsMultiplePage.this.projectNamePrefixText.getText().trim());
                CheckoutWizardCheckoutAsMultiplePage.this.setPreview();
            }
        });
        Label projectTextLabel = new Label((Composite)projectGroup, 0);
        projectTextLabel.setText("<default_name>");
        this.projectNameSuffixText = new Text((Composite)projectGroup, 2048);
        data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 60;
        this.projectNameSuffixText.setLayoutData((Object)data);
        this.projectNameSuffixText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CheckoutWizard wizard = (CheckoutWizard)CheckoutWizardCheckoutAsMultiplePage.this.getWizard();
                wizard.setProjectNameSuffix(CheckoutWizardCheckoutAsMultiplePage.this.projectNameSuffixText.getText().trim());
                CheckoutWizardCheckoutAsMultiplePage.this.setPreview();
            }
        });
        Composite previewGroup = new Composite((Composite)projectGroup, 0);
        GridLayout previewLayout = new GridLayout();
        previewLayout.numColumns = 2;
        previewGroup.setLayout((Layout)previewLayout);
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 4;
        previewGroup.setLayoutData((Object)data);
        Label previewLabel = new Label(previewGroup, 0);
        previewLabel.setText(Policy.bind("CheckoutWizardCheckoutAsPage.namePreview"));
        this.previewText = new Label(previewGroup, 0);
        data = new GridData(768);
        this.previewText.setLayoutData((Object)data);
        this.previewText.setText("default_name");
        this.existingButton = new Button(outerContainer, 16);
        this.existingButton.setText(Policy.bind("CheckoutWizardCheckoutAsPage.existing"));
        this.existingButton.setEnabled(false);
        this.existingButton.setVisible(false);
        this.projectsButton.setSelection(true);
        Composite revisionGroup = new Composite(outerContainer, 0);
        GridLayout revisionLayout = new GridLayout();
        revisionLayout.numColumns = 3;
        revisionGroup.setLayout((Layout)revisionLayout);
        data = new GridData(4, 4, true, false);
        revisionGroup.setLayoutData((Object)data);
        this.headButton = new Button(revisionGroup, 32);
        this.headButton.setText(Policy.bind("CheckoutWizard.head"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.headButton.setLayoutData((Object)data);
        this.headButton.setSelection(true);
        Label revisionLabel = new Label(revisionGroup, 0);
        revisionLabel.setText(Policy.bind("CheckoutWizard.revision"));
        this.revisionText = new Text(revisionGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.revisionText.setLayoutData((Object)data);
        this.revisionText.setEnabled(false);
        Button logButton = new Button(revisionGroup, 8);
        logButton.setText(Policy.bind("MergeDialog.showLog"));
        logButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutWizardCheckoutAsMultiplePage.this.showLog();
            }
        });
        SelectionAdapter revisionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutWizardCheckoutAsMultiplePage.this.revisionText.setEnabled(!CheckoutWizardCheckoutAsMultiplePage.this.headButton.getSelection());
                if (!CheckoutWizardCheckoutAsMultiplePage.this.headButton.getSelection()) {
                    CheckoutWizardCheckoutAsMultiplePage.this.revisionText.selectAll();
                    CheckoutWizardCheckoutAsMultiplePage.this.revisionText.setFocus();
                }
            }
        };
        this.headButton.addSelectionListener((SelectionListener)revisionListener);
        Group parameterGroup = new Group(outerContainer, 0);
        GridLayout parameterLayout = new GridLayout();
        parameterLayout.numColumns = 2;
        parameterGroup.setLayout((Layout)parameterLayout);
        data = new GridData(4, 4, true, false, 3, 1);
        parameterGroup.setLayoutData((Object)data);
        Label depthLabel = new Label((Composite)parameterGroup, 0);
        depthLabel.setText(Policy.bind("SvnDialog.depth"));
        this.depthCombo = new Combo((Composite)parameterGroup, 8);
        DepthComboHelper.addDepths(this.depthCombo, false, "Fully recursive");
        this.ignoreExternalsButton = new Button((Composite)parameterGroup, 32);
        this.ignoreExternalsButton.setText(Policy.bind("SvnDialog.ignoreExternals"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.ignoreExternalsButton.setLayoutData((Object)data);
        this.forceButton = new Button((Composite)parameterGroup, 32);
        this.forceButton.setText(Policy.bind("SvnDialog.force"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.forceButton.setLayoutData((Object)data);
        this.forceButton.setSelection(true);
        this.setMessage(Policy.bind("CheckoutWizardCheckoutAsPage.text"));
        this.setControl((Control)outerContainer);
    }

    public void setText(String text) {
        this.textLabel.setText(text);
    }

    private void setPreview() {
        this.previewText.setText(String.valueOf(this.projectNamePrefixText.getText().trim()) + "default_name" + this.projectNameSuffixText.getText().trim());
    }

    private void showLog() {
        HistoryDialog dialog = new HistoryDialog(this.getShell(), this.getCommonParent());
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        this.revisionText.setText(Long.toString(selectedEntries[0].getRevision().getNumber()));
        this.revisionText.setEnabled(true);
        this.headButton.setSelection(false);
    }

    private ISVNRemoteResource getCommonParent() {
        ISVNRemoteFolder[] remoteFolders = ((CheckoutWizard)this.getWizard()).getRemoteFolders();
        if (remoteFolders.length == 1) {
            return remoteFolders[0];
        }
        ISVNRemoteFolder commonParent = null;
        ISVNRemoteFolder parent = remoteFolders[0];
        while (commonParent == null) {
            if ((parent = parent.getParent()) == null) break;
            int i = 1;
            while (i < remoteFolders.length) {
                if (!remoteFolders[i].getUrl().toString().startsWith(parent.getUrl().toString())) break;
                ++i;
            }
            commonParent = parent;
        }
        return commonParent;
    }

    public SVNRevision getRevision() {
        if (this.headButton.getSelection()) {
            return SVNRevision.HEAD;
        }
        SVNRevision svnRevision = null;
        try {
            svnRevision = SVNRevision.getRevision((String)this.revisionText.getText().trim());
        }
        catch (ParseException parseException) {}
        if (svnRevision == null) {
            return SVNRevision.HEAD;
        }
        return svnRevision;
    }

    public int getDepth() {
        return DepthComboHelper.getDepth(this.depthCombo);
    }

    public boolean isIgnoreExternals() {
        return this.ignoreExternalsButton.getSelection();
    }

    public boolean isForce() {
        return this.forceButton.getSelection();
    }
}

