/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.wizards.ClosableWizardDialog;

public class WizardDialogWithPersistedLocation
extends ClosableWizardDialog {
    private String id;
    private IDialogSettings settings;

    public WizardDialogWithPersistedLocation(Shell parentShell, IWizard newWizard, String id) {
        super(parentShell, newWizard);
        this.id = id;
        this.settings = SVNUIPlugin.getPlugin().getDialogSettings();
    }

    protected void cancelPressed() {
        this.saveLocation();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.saveLocation();
        super.okPressed();
    }

    protected Point getInitialLocation(Point initialSize) {
        try {
            int x = this.settings.getInt(String.valueOf(this.id) + ".location.x");
            int y = this.settings.getInt(String.valueOf(this.id) + ".location.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(initialSize);
        }
    }

    protected Point getInitialSize() {
        try {
            int x = this.settings.getInt(String.valueOf(this.id) + ".size.x");
            int y = this.settings.getInt(String.valueOf(this.id) + ".size.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialSize();
        }
    }

    protected void saveLocation() {
        int x = this.getShell().getLocation().x;
        int y = this.getShell().getLocation().y;
        this.settings.put(String.valueOf(this.id) + ".location.x", x);
        this.settings.put(String.valueOf(this.id) + ".location.y", y);
        x = this.getShell().getSize().x;
        y = this.getShell().getSize().y;
        this.settings.put(String.valueOf(this.id) + ".size.x", x);
        this.settings.put(String.valueOf(this.id) + ".size.y", y);
    }
}

