/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.dialogs;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.properties.SVNPropertyDefinition;
import org.tigris.subversion.subclipse.core.properties.SVNPropertyManager;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialogPage;
import org.tigris.subversion.svnclientadapter.ISVNProperty;

public class SvnWizardSetPropertyPage
extends SvnWizardDialogPage {
    private ISVNProperty property;
    private ISVNLocalResource svnResource;
    private Combo propertyNameText;
    private Text propertyValueText;
    private Text fileText;
    private Button textRadio;
    private Button fileRadio;
    private Button browseButton;
    private Label statusMessageLabel;
    private Button recurseCheckbox;
    private String propertyName;
    private String propertyValue;
    private File propertyFile;
    private boolean recurse;
    private ArrayList allPropertyTypes = new ArrayList();
    private SVNPropertyDefinition[] propertyTypes;
    private ArrayList propertyNames;
    private int prop;

    public SvnWizardSetPropertyPage(ISVNLocalResource svnResource) {
        this(svnResource, null);
    }

    public SvnWizardSetPropertyPage(ISVNLocalResource svnResource, ISVNProperty property) {
        super("SetSvnPropertyDialog", Policy.bind("SetSvnPropertyDialog.title"));
        this.property = property;
        this.svnResource = svnResource;
    }

    @Override
    public void createButtonsForButtonBar(Composite parent, SvnWizardDialog wizardDialog) {
    }

    @Override
    public void createControls(Composite parent) {
        Listener updateEnablementsListener = new Listener(){

            public void handleEvent(Event event) {
                SvnWizardSetPropertyPage.this.updateEnablements();
            }
        };
        Listener validateListener = new Listener(){

            public void handleEvent(Event event) {
                SvnWizardSetPropertyPage.this.validate();
            }
        };
        Listener updatePropertiesListener = new Listener(){

            public void handleEvent(Event event) {
                SvnWizardSetPropertyPage.this.validate();
            }
        };
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        area.setLayout((Layout)gridLayout);
        area.setLayoutData((Object)new GridData(1808));
        Label label = new Label(area, 16384);
        label.setLayoutData((Object)new GridData());
        label.setText(Policy.bind("SetSvnPropertyDialog.propertyName"));
        this.propertyNameText = new Combo(area, 2048);
        this.propertyNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.property != null) {
            this.propertyNameText.setText(this.property.getName());
            this.propertyNameText.setEnabled(false);
        }
        this.getPropertyTypes();
        this.propertyNameText.addListener(24, validateListener);
        this.propertyNameText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                SvnWizardSetPropertyPage.this.getProperty();
            }
        });
        this.propertyNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                SvnWizardSetPropertyPage.this.getProperty();
            }
        });
        Group group = new Group(area, 0);
        group.setText(Policy.bind("SetSvnPropertyDialog.propertyContent"));
        group.setLayoutData((Object)new GridData(4, 4, false, true, 2, 1));
        group.setLayout((Layout)new GridLayout(2, false));
        this.textRadio = new Button((Composite)group, 16);
        this.textRadio.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.textRadio.setText(Policy.bind("SetSvnPropertyDialog.enterTextProperty"));
        this.textRadio.addListener(13, updateEnablementsListener);
        this.textRadio.setSelection(true);
        this.propertyValueText = new Text((Composite)group, 2818);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.heightHint = 100;
        gridData.widthHint = 400;
        gridData.horizontalIndent = 15;
        this.propertyValueText.setLayoutData((Object)gridData);
        this.fileRadio = new Button((Composite)group, 16);
        this.fileRadio.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.fileRadio.setText(Policy.bind("SetSvnPropertyDialog.useFile"));
        this.fileRadio.addListener(13, updateEnablementsListener);
        this.fileText = new Text((Composite)group, 2052);
        GridData fileTextData = new GridData(4, 0x1000000, true, false);
        fileTextData.horizontalIndent = 15;
        this.fileText.setLayoutData((Object)fileTextData);
        this.fileText.setEditable(false);
        this.browseButton = new Button((Composite)group, 8);
        this.browseButton.setLayoutData((Object)new GridData());
        this.browseButton.setText(Policy.bind("SetSvnPropertyDialog.browse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(SvnWizardSetPropertyPage.this.getShell(), 4096);
                String res = fileDialog.open();
                if (res != null) {
                    SvnWizardSetPropertyPage.this.fileText.setText(res);
                    SvnWizardSetPropertyPage.this.validate();
                }
            }
        });
        this.recurseCheckbox = new Button(area, 32);
        this.recurseCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.recurseCheckbox.setText(Policy.bind("SetSvnPropertyDialog.setPropertyRecursively"));
        this.recurseCheckbox.setSelection(false);
        if (!this.svnResource.isFolder()) {
            this.recurseCheckbox.setEnabled(false);
        }
        this.recurseCheckbox.addListener(13, updatePropertiesListener);
        this.statusMessageLabel = new Label(area, 16384);
        this.statusMessageLabel.setText("");
        GridData data = new GridData(4, 4, false, false, 2, 1);
        this.statusMessageLabel.setLayoutData((Object)data);
        this.statusMessageLabel.setFont(parent.getFont());
        if (this.property != null) {
            this.propertyValueText.setText(this.property.getValue());
            this.getProperty();
        }
        this.propertyValueText.addListener(24, updatePropertiesListener);
        this.propertyValueText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4 && (e.stateMask & 0x40000) != 0) {
                    e.doit = false;
                    if (SvnWizardSetPropertyPage.this.isPageComplete()) {
                        ((SvnWizard)SvnWizardSetPropertyPage.this.getWizard()).finishAndClose();
                    }
                }
            }
        });
        this.updateEnablements();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)area, "org.tigris.subversion.subclipse.ui.set_svn_property_dialog_context");
    }

    @Override
    public String getWindowTitle() {
        return Policy.bind("SetSvnPropertyDialog.title");
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public boolean performFinish() {
        return true;
    }

    @Override
    public void saveSettings() {
    }

    @Override
    public void setMessage() {
        this.setMessage(Policy.bind("SetSvnPropertyDialog.message"));
    }

    private boolean isNewProperty() {
        return this.property == null;
    }

    private void getPropertyTypes() {
        if (this.svnResource.isFolder()) {
            SVNPropertyDefinition[] allProperties = SVNPropertyManager.getInstance().getPropertyTypes();
            int i = 0;
            while (i < allProperties.length) {
                this.allPropertyTypes.add(allProperties[i]);
                ++i;
            }
            this.propertyTypes = SVNPropertyManager.getInstance().getFolderPropertyTypes();
        } else {
            this.propertyTypes = SVNPropertyManager.getInstance().getFilePropertyTypes();
        }
        this.propertyNames = new ArrayList();
        int i = 0;
        while (i < this.propertyTypes.length) {
            this.propertyNameText.add(this.propertyTypes[i].getName());
            this.propertyNames.add(this.propertyTypes[i].getName());
            ++i;
        }
    }

    private void updateEnablements() {
        if (this.textRadio.getSelection()) {
            this.browseButton.setEnabled(false);
            this.fileText.setEnabled(false);
            this.propertyValueText.setEnabled(true);
        } else {
            this.browseButton.setEnabled(true);
            this.fileText.setEnabled(true);
            this.propertyValueText.setEnabled(false);
        }
        this.validate();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public File getPropertyFile() {
        return this.propertyFile;
    }

    public boolean getRecurse() {
        return this.recurse;
    }

    private void updateProperties() {
        this.propertyName = this.propertyNameText.getText();
        if (this.textRadio.getSelection()) {
            this.propertyFile = null;
            this.propertyValue = this.propertyValueText.getText();
        } else {
            this.propertyFile = new File(this.fileText.getText());
            this.propertyValue = null;
        }
        this.recurse = this.recurseCheckbox.getSelection();
    }

    private void validate() {
        SVNPropertyDefinition checkDefinition;
        int index;
        this.updateProperties();
        if (this.propertyName.equals("")) {
            this.setError("");
            return;
        }
        if (this.isNewProperty()) {
            try {
                SVNUIPlugin.getPlugin().disableConsoleListener();
                if (this.svnResource.getSvnProperty(this.getPropertyName()) != null) {
                    this.setError(Policy.bind("SetSvnPropertyDialog.anotherPropertyHasSameName"));
                    return;
                }
            }
            catch (SVNException sVNException) {
            }
            finally {
                SVNUIPlugin.getPlugin().enableConsoleListener();
            }
        }
        if (this.textRadio.getSelection() && this.prop != -1) {
            if (this.propertyTypes[this.prop].isBoolean() && !this.propertyValue.equals("true") && !this.propertyValue.equals("false")) {
                this.setError(Policy.bind("SetSvnPropertyDialog.boolean"));
                return;
            }
            if (this.propertyTypes[this.prop].isNumber()) {
                try {
                    Integer.parseInt(this.propertyValue);
                }
                catch (Exception exception) {
                    this.setError(Policy.bind("SetSvnPropertyDialog.number"));
                    return;
                }
            }
            if (this.propertyTypes[this.prop].isUrl() && (!this.propertyName.equals("bugtraq:url") || !this.propertyValue.startsWith("^/") && !this.propertyValue.startsWith("/"))) {
                try {
                    new URL(this.propertyValue);
                }
                catch (Exception exception) {
                    this.setError(Policy.bind("SetSvnPropertyDialog.url"));
                    return;
                }
            }
        }
        if (this.svnResource.isFolder() && !this.recurseCheckbox.getSelection() && this.prop == -1 && (index = this.allPropertyTypes.indexOf(checkDefinition = new SVNPropertyDefinition(this.propertyName, null))) != -1) {
            this.setError(Policy.bind("SetSvnPropertyDialog.recurseRequired"));
            return;
        }
        if (this.propertyFile != null) {
            if (this.fileText.getText().equals("")) {
                this.setError("");
            } else if (!this.getPropertyFile().exists()) {
                this.setError(Policy.bind("SetSvnPropertyDialog.fileDoesNotExist"));
                return;
            }
        }
        this.setError(null);
    }

    private void setError(String text) {
        if (text == null) {
            this.statusMessageLabel.setText("");
            this.setPageComplete(true);
        } else {
            this.statusMessageLabel.setText(text);
            this.statusMessageLabel.setForeground(JFaceColors.getErrorText((Display)this.getShell().getDisplay()));
            this.setPageComplete(false);
        }
    }

    private void getProperty() {
        this.prop = this.propertyNames.indexOf(this.propertyNameText.getText());
        if (this.prop != -1) {
            this.propertyNameText.setToolTipText(this.propertyTypes[this.prop].getDescription());
            this.recurseCheckbox.setEnabled(this.svnResource.isFolder() && this.propertyTypes[this.prop].isAllowRecurse());
            if (!this.recurseCheckbox.getEnabled()) {
                this.recurseCheckbox.setSelection(false);
            }
        } else {
            this.recurseCheckbox.setEnabled(this.svnResource.isFolder());
        }
        this.validate();
    }
}

