/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.dialogs;

import java.text.ParseException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.DepthComboHelper;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.conflicts.SVNConflictResolver;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialogPage;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SvnWizardUpdatePage
extends SvnWizardDialogPage {
    private static final int REVISION_WIDTH_HINT = 40;
    private IResource[] resources;
    private Text revisionText;
    private Button logButton;
    private Button headButton;
    private Combo depthCombo;
    private Button setDepthButton;
    private Button ignoreExternalsButton;
    private Button forceButton;
    private Button textConflictPromptButton;
    private Button textConflictMarkButton;
    private Button propertyConflictPromptButton;
    private Button propertyConflictMarkButton;
    private Button binaryConflictPromptButton;
    private Button binaryConflictMarkButton;
    private Button binaryConflictUserButton;
    private Button binaryConflictIncomingButton;
    private Button treeConflictPromptButton;
    private Button treeConflictMarkButton;
    private Button treeConflictUserButton;
    private Button treeConflictResolveButton;
    private SVNConflictResolver conflictResolver;
    private SVNRevision revision;
    private int depth;
    private boolean setDepth;
    private boolean ignoreExternals;
    private boolean force;
    private String[] urlStrings;
    private String commonRoot;
    private long defaultRevision;

    public SvnWizardUpdatePage(IResource[] resources) {
        super("UpdateDialogWithConflictHandling2", Policy.bind("UpdateDialog.title"));
        this.resources = resources;
    }

    public SvnWizardUpdatePage(String name, IResource[] resources) {
        super(name, Policy.bind("UpdateDialog.title"));
        this.resources = resources;
    }

    @Override
    public void createButtonsForButtonBar(Composite parent, SvnWizardDialog wizardDialog) {
    }

    @Override
    public void createControls(Composite parent) {
        String defaultDepth;
        this.commonRoot = this.getCommonRoot();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        final Composite revisionGroup = new Composite(composite, 0);
        GridLayout revisionLayout = new GridLayout();
        revisionLayout.numColumns = 3;
        revisionLayout.marginWidth = 0;
        revisionLayout.marginHeight = 0;
        revisionGroup.setLayout((Layout)revisionLayout);
        data = new GridData(4, 4, true, false);
        revisionGroup.setLayoutData((Object)data);
        this.headButton = new Button(revisionGroup, 32);
        this.headButton.setText(Policy.bind("SvnWizardUpdatePage.head"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.headButton.setLayoutData((Object)data);
        this.headButton.setSelection(true);
        if (this.commonRoot == null) {
            this.headButton.setEnabled(false);
        }
        Label revisionLabel = new Label(revisionGroup, 0);
        revisionLabel.setText(Policy.bind("SvnWizardUpdatePage.revision"));
        this.revisionText = new Text(revisionGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.revisionText.setLayoutData((Object)data);
        this.revisionText.setEnabled(false);
        if (this.defaultRevision > 0L) {
            this.revisionText.setText(Long.toString(this.defaultRevision));
        }
        this.revisionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SvnWizardUpdatePage.this.setPageComplete(SvnWizardUpdatePage.this.canFinish());
            }
        });
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.revisionText.addFocusListener((FocusListener)focusListener);
        this.logButton = new Button(revisionGroup, 8);
        this.logButton.setText(Policy.bind("MergeDialog.showLog"));
        this.logButton.setEnabled(false);
        this.logButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SvnWizardUpdatePage.this.showLog();
            }
        });
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SvnWizardUpdatePage.this.revisionText.setEnabled(!SvnWizardUpdatePage.this.headButton.getSelection());
                SvnWizardUpdatePage.this.logButton.setEnabled(!SvnWizardUpdatePage.this.headButton.getSelection());
                SvnWizardUpdatePage.this.setPageComplete(SvnWizardUpdatePage.this.canFinish());
                if (!SvnWizardUpdatePage.this.headButton.getSelection()) {
                    SvnWizardUpdatePage.this.revisionText.selectAll();
                    SvnWizardUpdatePage.this.revisionText.setFocus();
                }
            }
        };
        this.headButton.addSelectionListener((SelectionListener)listener);
        Group parameterGroup = new Group(composite, 0);
        GridLayout parameterLayout = new GridLayout();
        parameterLayout.numColumns = 2;
        parameterGroup.setLayout((Layout)parameterLayout);
        data = new GridData(4, 4, true, false, 3, 1);
        parameterGroup.setLayoutData((Object)data);
        Label depthLabel = new Label((Composite)parameterGroup, 0);
        depthLabel.setText(Policy.bind("SvnDialog.depth"));
        this.depthCombo = new Combo((Composite)parameterGroup, 8);
        switch (this.depth) {
            case 2: {
                defaultDepth = "Only this item";
                break;
            }
            case 1: {
                defaultDepth = "Exclude";
                break;
            }
            case 3: {
                defaultDepth = "Only file children";
                break;
            }
            case 4: {
                defaultDepth = "Immediate children, including folders";
                break;
            }
            case 5: {
                defaultDepth = "Fully recursive";
                break;
            }
            default: {
                defaultDepth = "Working copy";
            }
        }
        DepthComboHelper.addDepths(this.depthCombo, true, true, defaultDepth);
        this.depthCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (SvnWizardUpdatePage.this.depthCombo.getText().equals("Exclude")) {
                    SvnWizardUpdatePage.this.setDepthButton.setSelection(true);
                    SvnWizardUpdatePage.this.setDepthButton.setEnabled(false);
                    SvnWizardUpdatePage.this.ignoreExternalsButton.setVisible(false);
                    SvnWizardUpdatePage.this.forceButton.setVisible(false);
                    revisionGroup.setVisible(false);
                } else {
                    SvnWizardUpdatePage.this.setDepthButton.setEnabled(true);
                    SvnWizardUpdatePage.this.ignoreExternalsButton.setVisible(true);
                    SvnWizardUpdatePage.this.forceButton.setVisible(true);
                    revisionGroup.setVisible(true);
                }
                SvnWizardUpdatePage.this.setPageComplete(SvnWizardUpdatePage.this.canFinish());
            }
        });
        this.setDepthButton = new Button((Composite)parameterGroup, 32);
        this.setDepthButton.setText(Policy.bind("SvnDialog.setDepth"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.setDepthButton.setLayoutData((Object)data);
        this.setDepthButton.setSelection(this.setDepth);
        this.ignoreExternalsButton = new Button((Composite)parameterGroup, 32);
        this.ignoreExternalsButton.setText(Policy.bind("SvnDialog.ignoreExternals"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.ignoreExternalsButton.setLayoutData((Object)data);
        this.forceButton = new Button((Composite)parameterGroup, 32);
        this.forceButton.setText(Policy.bind("SvnDialog.force"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.forceButton.setLayoutData((Object)data);
        this.forceButton.setSelection(true);
        Group conflictGroup = new Group(composite, 0);
        conflictGroup.setText(Policy.bind("SvnWizardUpdatePage.0"));
        GridLayout conflictLayout = new GridLayout();
        conflictLayout.numColumns = 1;
        conflictGroup.setLayout((Layout)conflictLayout);
        conflictGroup.setLayoutData((Object)new GridData(768));
        Group textGroup = new Group((Composite)conflictGroup, 0);
        textGroup.setText(Policy.bind("SvnWizardUpdatePage.1"));
        GridLayout textLayout = new GridLayout();
        textLayout.numColumns = 1;
        textGroup.setLayout((Layout)textLayout);
        textGroup.setLayoutData((Object)new GridData(768));
        this.textConflictPromptButton = new Button((Composite)textGroup, 16);
        this.textConflictPromptButton.setText(Policy.bind("SvnWizardUpdatePage.2"));
        this.textConflictMarkButton = new Button((Composite)textGroup, 16);
        this.textConflictMarkButton.setText(Policy.bind("SvnWizardUpdatePage.3"));
        Group binaryGroup = new Group((Composite)conflictGroup, 0);
        binaryGroup.setText(Policy.bind("SvnWizardUpdatePage.4"));
        GridLayout binaryLayout = new GridLayout();
        binaryLayout.numColumns = 1;
        binaryGroup.setLayout((Layout)binaryLayout);
        binaryGroup.setLayoutData((Object)new GridData(768));
        this.binaryConflictPromptButton = new Button((Composite)binaryGroup, 16);
        this.binaryConflictPromptButton.setText(Policy.bind("SvnWizardUpdatePage.5"));
        this.binaryConflictMarkButton = new Button((Composite)binaryGroup, 16);
        this.binaryConflictMarkButton.setText(Policy.bind("SvnWizardUpdatePage.6"));
        this.binaryConflictUserButton = new Button((Composite)binaryGroup, 16);
        this.binaryConflictUserButton.setText(Policy.bind("SvnWizardUpdatePage.7"));
        this.binaryConflictIncomingButton = new Button((Composite)binaryGroup, 16);
        this.binaryConflictIncomingButton.setText(Policy.bind("SvnWizardUpdatePage.8"));
        Group propertyGroup = new Group((Composite)conflictGroup, 0);
        propertyGroup.setText(Policy.bind("SvnWizardUpdatePage.9"));
        GridLayout propertyLayout = new GridLayout();
        propertyLayout.numColumns = 1;
        propertyGroup.setLayout((Layout)propertyLayout);
        propertyGroup.setLayoutData((Object)new GridData(768));
        this.propertyConflictPromptButton = new Button((Composite)propertyGroup, 16);
        this.propertyConflictPromptButton.setText(Policy.bind("SvnWizardUpdatePage.10"));
        this.propertyConflictMarkButton = new Button((Composite)propertyGroup, 16);
        this.propertyConflictMarkButton.setText(Policy.bind("SvnWizardUpdatePage.11"));
        Group treeConflictGroup = new Group((Composite)conflictGroup, 0);
        treeConflictGroup.setText(Policy.bind("SvnWizardUpdatePage.12"));
        GridLayout treeConflictLayout = new GridLayout();
        treeConflictLayout.numColumns = 1;
        treeConflictGroup.setLayout((Layout)treeConflictLayout);
        treeConflictGroup.setLayoutData((Object)new GridData(768));
        this.treeConflictPromptButton = new Button((Composite)treeConflictGroup, 16);
        this.treeConflictPromptButton.setText(Policy.bind("SvnWizardUpdatePage.10"));
        this.treeConflictMarkButton = new Button((Composite)treeConflictGroup, 16);
        this.treeConflictMarkButton.setText(Policy.bind("SvnWizardUpdatePage.11"));
        this.treeConflictUserButton = new Button((Composite)treeConflictGroup, 16);
        this.treeConflictUserButton.setText(Policy.bind("SvnWizardUpdatePage.13"));
        this.treeConflictResolveButton = new Button((Composite)treeConflictGroup, 16);
        this.treeConflictResolveButton.setText(Policy.bind("SvnWizardUpdatePage.14"));
        this.textConflictMarkButton.setSelection(true);
        this.binaryConflictMarkButton.setSelection(true);
        this.propertyConflictMarkButton.setSelection(true);
        this.treeConflictMarkButton.setSelection(true);
        this.setPageComplete(this.canFinish());
    }

    @Override
    public String getWindowTitle() {
        return Policy.bind("UpdateDialog.update");
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public boolean performFinish() {
        if (this.headButton.getSelection()) {
            this.revision = SVNRevision.HEAD;
        } else {
            try {
                this.revision = SVNRevision.getRevision((String)this.revisionText.getText().trim());
            }
            catch (ParseException parseException) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("UpdateDialog.title"), (String)Policy.bind("UpdateDialog.invalid"));
                return false;
            }
        }
        this.setDepth = this.setDepthButton.getSelection();
        this.ignoreExternals = this.ignoreExternalsButton.getSelection();
        this.force = this.forceButton.getSelection();
        this.depth = DepthComboHelper.getDepth(this.depthCombo);
        this.conflictResolver = new SVNConflictResolver(this.resources[0], this.getTextConflictHandling(), this.getBinaryConflictHandling(), this.getPropertyConflictHandling(), this.getTreeConflictHandling());
        return true;
    }

    @Override
    public void saveSettings() {
    }

    public SVNConflictResolver getConflictResolver() {
        return this.conflictResolver;
    }

    public int getTextConflictHandling() {
        if (this.textConflictMarkButton.getSelection()) {
            return 0;
        }
        return 6;
    }

    public int getBinaryConflictHandling() {
        if (this.binaryConflictIncomingButton.getSelection()) {
            return 2;
        }
        if (this.binaryConflictUserButton.getSelection()) {
            return 3;
        }
        if (this.binaryConflictMarkButton.getSelection()) {
            return 0;
        }
        return 6;
    }

    public int getPropertyConflictHandling() {
        if (this.propertyConflictMarkButton.getSelection()) {
            return 0;
        }
        return 6;
    }

    public int getTreeConflictHandling() {
        if (this.treeConflictMarkButton.getSelection()) {
            return 0;
        }
        if (this.treeConflictResolveButton.getSelection()) {
            return 6;
        }
        if (this.treeConflictUserButton.getSelection()) {
            return 5;
        }
        return -1;
    }

    @Override
    public void setMessage() {
        this.setMessage(Policy.bind("UpdateDialog.message"));
    }

    public void setDefaultRevision(long defaultRevision) {
        this.defaultRevision = defaultRevision;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setSetDepth(boolean setDepth) {
        this.setDepth = setDepth;
    }

    private boolean canFinish() {
        return this.headButton.getSelection() || this.revisionText.getText().trim().length() > 0;
    }

    protected void showLog() {
        ISVNRemoteFile remoteResource = null;
        try {
            remoteResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resources[0]).getRepository().getRemoteFile(new SVNUrl(this.commonRoot));
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)e.toString());
            return;
        }
        if (remoteResource == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)(String.valueOf(Policy.bind("MergeDialog.urlError")) + " " + this.commonRoot));
            return;
        }
        HistoryDialog dialog = new HistoryDialog(this.getShell(), (ISVNRemoteResource)remoteResource);
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        this.revisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
        this.setPageComplete(this.canFinish());
    }

    private String getCommonRoot() {
        ArrayList<String> urlList = new ArrayList<String>();
        int i = 0;
        while (i < this.resources.length) {
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resources[i]);
            try {
                String anUrl = svnResource.getStatus().getUrlString();
                if (anUrl != null) {
                    urlList.add(anUrl);
                }
            }
            catch (SVNException sVNException) {}
            ++i;
        }
        this.urlStrings = new String[urlList.size()];
        urlList.toArray(this.urlStrings);
        if (this.urlStrings.length == 0) {
            return null;
        }
        String urlString = this.urlStrings[0];
        if (this.urlStrings.length == 1) {
            return urlString;
        }
        String commonRoot = null;
        int i2 = 0;
        block3: while (i2 < urlString.length()) {
            String partialPath = urlString.substring(0, i2 + 1);
            if (partialPath.endsWith("/")) {
                int j = 1;
                while (j < this.urlStrings.length) {
                    if (!this.urlStrings[j].startsWith(partialPath)) break block3;
                    ++j;
                }
                commonRoot = partialPath.substring(0, i2);
            }
            ++i2;
        }
        return commonRoot;
    }

    public SVNRevision getRevision() {
        return this.revision;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isSetDepth() {
        return this.setDepth;
    }

    public boolean isIgnoreExternals() {
        return this.ignoreExternals;
    }

    public boolean isForce() {
        return this.force;
    }
}

