/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.sharing;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.ChooseUrlDialog;
import org.tigris.subversion.subclipse.ui.wizards.SVNWizardPage;
import org.tigris.subversion.subclipse.ui.wizards.sharing.ISVNRepositoryLocationProvider;

public class DirectorySelectionPage
extends SVNWizardPage {
    private ISVNRepositoryLocationProvider repositoryLocationProvider;
    Button useProjectNameButton;
    Button useSpecifiedNameButton;
    Text text;
    Button browseButton;
    Text urlText;
    String result;
    boolean useProjectName = true;
    private String lastLocation;
    private IDialogSettings settings = SVNUIPlugin.getPlugin().getDialogSettings();
    private static final String LAST_PARENT = "DirectorySelectionPage.lastParent_";

    public DirectorySelectionPage(String pageName, String title, ImageDescriptor titleImage, ISVNRepositoryLocationProvider repositoryLocationProvider) {
        super(pageName, title, titleImage);
        this.repositoryLocationProvider = repositoryLocationProvider;
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 3);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.sharing_module_page_context");
        this.useProjectNameButton = this.createRadioButton(composite, Policy.bind("ModuleSelectionPage.moduleIsProject"), 3);
        this.useSpecifiedNameButton = this.createRadioButton(composite, Policy.bind("ModuleSelectionPage.specifyModule"), 1);
        this.text = DirectorySelectionPage.createTextField(composite);
        this.text.setEnabled(false);
        this.text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                DirectorySelectionPage.this.setUrlText();
                DirectorySelectionPage.this.result = DirectorySelectionPage.this.text.getText().trim();
                if (DirectorySelectionPage.this.result.length() == 0) {
                    DirectorySelectionPage.this.result = null;
                    DirectorySelectionPage.this.setPageComplete(false);
                } else {
                    DirectorySelectionPage.this.setPageComplete(true);
                }
            }
        });
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.text.addFocusListener((FocusListener)focusListener);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(Policy.bind("SharingWizard.browse"));
        this.browseButton.setEnabled(false);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                try {
                    ISVNRepositoryLocation repositoryLocation = DirectorySelectionPage.this.repositoryLocationProvider.getLocation();
                    ChooseUrlDialog dialog = new ChooseUrlDialog(DirectorySelectionPage.this.getShell(), (IResource)DirectorySelectionPage.this.repositoryLocationProvider.getProject());
                    dialog.setRepositoryLocation(repositoryLocation);
                    if (dialog.open() == 0 && dialog.getUrl() != null) {
                        DirectorySelectionPage.this.text.setText(String.valueOf(dialog.getUrl().toString().substring(repositoryLocation.getLocation().length() + 1)) + "/" + DirectorySelectionPage.this.repositoryLocationProvider.getProject().getName());
                        DirectorySelectionPage.this.text.setFocus();
                        DirectorySelectionPage.this.text.setSelection(DirectorySelectionPage.this.text.getText().indexOf(DirectorySelectionPage.this.repositoryLocationProvider.getProject().getName()), DirectorySelectionPage.this.text.getText().length());
                    }
                }
                catch (Exception exception) {}
            }
        });
        Group urlGroup = new Group(composite, 0);
        urlGroup.setText(Policy.bind("SharingWizard.url"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        urlGroup.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.horizontalSpan = 3;
        urlGroup.setLayoutData((Object)data);
        this.urlText = DirectorySelectionPage.createTextField((Composite)urlGroup);
        this.urlText.setEditable(false);
        this.initializeSelection();
        this.setUrlText();
        this.useProjectNameButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectorySelectionPage.this.setUrlText();
                DirectorySelectionPage.this.useProjectName = DirectorySelectionPage.this.useProjectNameButton.getSelection();
                if (DirectorySelectionPage.this.useProjectName) {
                    DirectorySelectionPage.this.text.setEnabled(false);
                    DirectorySelectionPage.this.browseButton.setEnabled(false);
                    DirectorySelectionPage.this.result = null;
                    DirectorySelectionPage.this.setPageComplete(true);
                } else {
                    DirectorySelectionPage.this.text.setEnabled(true);
                    DirectorySelectionPage.this.text.setFocus();
                    DirectorySelectionPage.this.text.selectAll();
                    DirectorySelectionPage.this.browseButton.setEnabled(true);
                    DirectorySelectionPage.this.result = DirectorySelectionPage.this.text.getText();
                    if (DirectorySelectionPage.this.result.length() == 0) {
                        DirectorySelectionPage.this.result = null;
                        DirectorySelectionPage.this.setPageComplete(false);
                    } else {
                        DirectorySelectionPage.this.setPageComplete(true);
                    }
                }
            }
        });
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    private void initializeSelection() {
        String lastParent = null;
        try {
            lastParent = this.settings.get(LAST_PARENT + this.repositoryLocationProvider.getLocation().getLocation());
            if (lastParent != null && lastParent.length() > 0) {
                this.useSpecifiedNameButton.setSelection(true);
                this.useProjectNameButton.setSelection(false);
                this.text.setEnabled(true);
                this.text.setFocus();
                this.browseButton.setEnabled(true);
                this.text.setText(String.valueOf(lastParent) + "/" + this.repositoryLocationProvider.getProject().getName());
                this.text.setSelection(this.text.getText().indexOf(this.repositoryLocationProvider.getProject().getName()), this.text.getText().length());
            }
        }
        catch (TeamException teamException) {}
        if (lastParent == null) {
            this.useSpecifiedNameButton.setSelection(false);
            this.text.setText("");
            this.text.setEnabled(false);
            this.browseButton.setEnabled(false);
            this.useProjectNameButton.setSelection(true);
        }
    }

    public String getDirectoryName() {
        return this.result;
    }

    public boolean useProjectName() {
        return this.useProjectName;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.useSpecifiedNameButton.getSelection()) {
                this.useSpecifiedNameButton.setFocus();
            } else {
                this.useProjectNameButton.setFocus();
            }
            try {
                String location = this.repositoryLocationProvider.getLocation().getLocation();
                if (this.lastLocation == null || !this.lastLocation.equals(location)) {
                    this.initializeSelection();
                }
                this.lastLocation = location;
            }
            catch (TeamException teamException) {}
            this.setUrlText();
        }
    }

    private void setUrlText() {
        try {
            if (this.useProjectNameButton.getSelection()) {
                this.urlText.setText(String.valueOf(this.repositoryLocationProvider.getLocation().getLocation()) + "/" + this.repositoryLocationProvider.getProject().getName());
                this.settings.put(LAST_PARENT + this.repositoryLocationProvider.getLocation().getLocation(), "");
            } else {
                this.urlText.setText(String.valueOf(this.repositoryLocationProvider.getLocation().getLocation()) + "/" + this.text.getText().trim());
                int index = this.text.getText().lastIndexOf("/");
                if (index == -1) {
                    this.settings.put(LAST_PARENT + this.repositoryLocationProvider.getLocation().getLocation(), "");
                } else {
                    this.settings.put(LAST_PARENT + this.repositoryLocationProvider.getLocation().getLocation(), this.text.getText().substring(0, index));
                }
            }
        }
        catch (Exception exception) {}
    }
}

