/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.sharing;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.util.AdaptableList;
import org.tigris.subversion.subclipse.ui.wizards.SVNWizardPage;

public class SvnFoldersExistWarningPage
extends SVNWizardPage {
    private TableViewer table;
    private Button continueButton;
    private IFolder[] svnFolders;

    public SvnFoldersExistWarningPage(String pageName, String title, ImageDescriptor titleImage, IFolder[] svnFolders) {
        super(pageName, title, titleImage);
        this.svnFolders = svnFolders;
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.createWrappingLabel(composite, Policy.bind("SVNFoldersExistWarningPage.description"), 0, 1);
        this.table = this.createTable(composite, 1);
        this.table.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.table.setLabelProvider((IBaseLabelProvider)new SvnFoldersLabelProvider());
        Arrays.sort(this.svnFolders, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                IFolder folder1 = (IFolder)obj1;
                IFolder folder2 = (IFolder)obj2;
                return folder1.getFullPath().toOSString().compareTo(folder2.getFullPath().toOSString());
            }
        });
        AdaptableList input = new AdaptableList((IAdaptable[])this.svnFolders);
        this.table.setInput((Object)input);
        this.continueButton = new Button(composite, 32);
        this.continueButton.setText(Policy.bind("SVNFoldersExistWarningPage.continue"));
        this.continueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SvnFoldersExistWarningPage.this.setPageComplete(SvnFoldersExistWarningPage.this.continueButton.getSelection());
            }
        });
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }

    protected TableViewer createTable(Composite parent, int span) {
        Table table = new Table(parent, 2816);
        GridData data = new GridData(1808);
        data.horizontalSpan = span;
        data.heightHint = 125;
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        table.setLayout((Layout)layout);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("SVNFoldersExistWarningPage.folders"));
        table.setHeaderVisible(true);
        return new TableViewer(table);
    }

    class SvnFoldersLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();

        SvnFoldersLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return this.workbenchLabelProvider.getImage(element);
        }

        public String getColumnText(Object element, int columnIndex) {
            IFolder folder = (IFolder)element;
            return folder.getFullPath().toOSString();
        }
    }
}

