/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.rcp.workspace;

import com.jaspersoft.studio.ConfigurationManager;
import com.jaspersoft.studio.rcp.messages.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class PickWorkspaceDialog
extends TitleAreaDialog {
    public static final String JSS_DEFAULT_WS = "JaspersoftWorkspace";
    @Deprecated
    private static final String E3_KEY_WS_ROOT_DIR = "wsRootDir";
    private static final String E4_KEY_WS_ROOT_DIR = "wsRootDirVER2";
    private static final String E4_KEY_LAST_USED_WORKSPACES = "wsLastUsedWorkspacesVER2";
    private static Preferences preferences = Preferences.userNodeForPackage(PickWorkspaceDialog.class);
    private static final String DIALOG_MSG = Messages.PickWorkspaceDialog_InfoMsg;
    private static final String DIALOG_SELECTION_INFO = Messages.PickWorkspaceDialog_SelectionMsg;
    private static final String DIALOG_MISSING_DIR_ERROR = Messages.PickWorkspaceDialog_DirNotSetMsg;
    private Combo workspacePathCombo;
    private List<String> lastUsedWorkspaces;
    private static final String splitChar = "#";
    private static final int maxHistory = 20;
    private boolean switchWorkspace;
    private boolean suggestNew;
    private String selectedWorkspaceRootLocation;

    public PickWorkspaceDialog(boolean switchWorkspace, Image wizardImage, boolean suggestNew) {
        super(Display.getDefault().getActiveShell());
        this.switchWorkspace = switchWorkspace;
        if (wizardImage != null) {
            this.setTitleImage(wizardImage);
        }
        this.suggestNew = suggestNew;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.switchWorkspace) {
            newShell.setText(Messages.PickWorkspaceDialog_SwitchWSTitle);
        } else {
            newShell.setText(Messages.PickWorkspaceDialog_SelectWSTitle);
        }
    }

    public static String getLastSetWorkspaceDirectory() {
        String lastWSDir = preferences.get(E4_KEY_WS_ROOT_DIR, null);
        if (lastWSDir == null) {
            lastWSDir = preferences.get(E3_KEY_WS_ROOT_DIR, null);
        }
        if (lastWSDir == null) {
            lastWSDir = String.valueOf(System.getProperty("user.home")) + File.separator + JSS_DEFAULT_WS;
        }
        return lastWSDir;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.PickWorkspaceDialog_Title);
        this.setMessage(DIALOG_MSG);
        try {
            Composite inner = new Composite(parent, 0);
            inner.setLayout((Layout)new GridLayout(3, false));
            inner.setLayoutData((Object)new GridData(4, 4, true, true));
            CLabel label = new CLabel(inner, 0);
            label.setText(Messages.PickWorkspaceDialog_WSRootPathLabel);
            label.setLayoutData((Object)new GridData(16384, 4, false, false));
            this.workspacePathCombo = new Combo(inner, 2048);
            this.workspacePathCombo.setLayoutData((Object)new GridData(4, 4, true, false));
            String wsRoot = preferences.get(E4_KEY_WS_ROOT_DIR, "");
            if (wsRoot == null || wsRoot.length() == 0) {
                wsRoot = this.getWorkspacePathSuggestion();
            }
            this.workspacePathCombo.setText(wsRoot == null ? "" : wsRoot);
            this.workspacePathCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PickWorkspaceDialog.this.setMessage(DIALOG_MSG);
                }
            });
            String lastUsed = preferences.get(E4_KEY_LAST_USED_WORKSPACES, "");
            this.lastUsedWorkspaces = new ArrayList<String>();
            if (lastUsed != null) {
                String[] all;
                String[] stringArray = all = lastUsed.split(splitChar);
                int n = all.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    this.lastUsedWorkspaces.add(str);
                    ++n2;
                }
            }
            for (String last : this.lastUsedWorkspaces) {
                this.workspacePathCombo.add(last);
            }
            Button browse = new Button(inner, 8);
            browse.setText(Messages.PickWorkspaceDialog_BrowseBtn);
            browse.setLayoutData((Object)new GridData(131072, 4, false, false));
            browse.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DirectoryDialog dd = new DirectoryDialog(PickWorkspaceDialog.this.getParentShell());
                    dd.setText(Messages.PickWorkspaceDialog_SelectWSRootMsg);
                    dd.setMessage(DIALOG_SELECTION_INFO);
                    dd.setFilterPath(PickWorkspaceDialog.this.workspacePathCombo.getText());
                    String pick = dd.open();
                    if (pick == null) {
                        if (PickWorkspaceDialog.this.workspacePathCombo.getText().length() == 0) {
                            PickWorkspaceDialog.this.setMessage(DIALOG_MISSING_DIR_ERROR, 3);
                        }
                    } else {
                        PickWorkspaceDialog.this.setMessage(DIALOG_MSG);
                        PickWorkspaceDialog.this.workspacePathCombo.setText(pick);
                    }
                }
            });
            return inner;
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    public String getSelectedWorkspaceLocation() {
        return this.selectedWorkspaceRootLocation;
    }

    private String getWorkspacePathSuggestion() {
        StringBuffer buf = new StringBuffer();
        String uHome = System.getProperty("user.home");
        if (uHome == null) {
            uHome = "c:" + File.separator + "temp";
        }
        buf.append(uHome);
        buf.append(File.separator);
        buf.append(JSS_DEFAULT_WS);
        if (this.suggestNew) {
            buf.append("V2");
        }
        return buf.toString();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public static void copyFiles(File src, File dest) throws IOException {
        if (!src.exists()) {
            throw new IOException(NLS.bind((String)Messages.PickWorkspaceDialog_SourceNotFoundMsg, (Object)src.getAbsolutePath()));
        }
        if (!src.canRead()) {
            throw new IOException(NLS.bind((String)Messages.PickWorkspaceDialog_CannotReadMsg, (Object)src.getAbsolutePath()));
        }
        if (src.isDirectory()) {
            if (!dest.exists() && !dest.mkdirs()) {
                throw new IOException(String.valueOf(Messages.PickWorkspaceDialog_CannoCreateDirMsg) + dest.getAbsolutePath());
            }
            String[] list = src.list();
            int i = 0;
            while (i < list.length) {
                File dest1 = new File(dest, list[i]);
                File src1 = new File(src, list[i]);
                PickWorkspaceDialog.copyFiles(src1, dest1);
                ++i;
            }
        } else {
            FileInputStream fin = null;
            FileOutputStream fout = null;
            byte[] buffer = new byte[4096];
            try {
                try {
                    int bytesRead;
                    fin = new FileInputStream(src);
                    fout = new FileOutputStream(dest);
                    while ((bytesRead = fin.read(buffer)) >= 0) {
                        fout.write(buffer, 0, bytesRead);
                    }
                }
                catch (IOException e) {
                    IOException wrapper = new IOException(NLS.bind((String)Messages.PickWorkspaceDialog_UnableToCopyMsg, (Object)src.getAbsolutePath(), (Object)dest.getAbsolutePath()));
                    wrapper.initCause(e);
                    wrapper.setStackTrace(e.getStackTrace());
                    throw wrapper;
                }
            }
            finally {
                if (fin != null) {
                    fin.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
        }
    }

    protected void okPressed() {
        int i;
        String str = this.workspacePathCombo.getText();
        if (str.length() == 0) {
            this.setMessage(DIALOG_MISSING_DIR_ERROR, 3);
            return;
        }
        String ret = PickWorkspaceDialog.checkWorkspaceDirectory(this.getParentShell(), str, false, true);
        if (ret != null) {
            this.setMessage(ret, 3);
            return;
        }
        if (FileUtils.isSameLocation((String)str, (String)ConfigurationManager.getCurrentWorkspaceLocation())) {
            this.setMessage(Messages.PickWorkspaceDialog_SameWorkspaceErrorMsg, 3);
            return;
        }
        this.lastUsedWorkspaces.remove(str);
        if (!this.lastUsedWorkspaces.contains(str)) {
            this.lastUsedWorkspaces.add(0, str);
        }
        if (this.lastUsedWorkspaces.size() > 20) {
            ArrayList<String> remove = new ArrayList<String>();
            i = 20;
            while (i < this.lastUsedWorkspaces.size()) {
                remove.add(this.lastUsedWorkspaces.get(i));
                ++i;
            }
            this.lastUsedWorkspaces.removeAll(remove);
        }
        StringBuffer buf = new StringBuffer();
        i = 0;
        while (i < this.lastUsedWorkspaces.size()) {
            buf.append(this.lastUsedWorkspaces.get(i));
            if (i != this.lastUsedWorkspaces.size() - 1) {
                buf.append(splitChar);
            }
            ++i;
        }
        preferences.put(E4_KEY_LAST_USED_WORKSPACES, buf.toString());
        boolean ok = PickWorkspaceDialog.checkAndCreateWorkspaceRoot(str);
        if (!ok) {
            this.setMessage(Messages.PickWorkspaceDialog_UnableToCreateWSMsg);
            return;
        }
        this.selectedWorkspaceRootLocation = str;
        preferences.put(E4_KEY_WS_ROOT_DIR, str);
        super.okPressed();
    }

    public static String checkWorkspaceDirectory(Shell parentShell, String workspaceLocation, boolean askCreate, boolean fromDialog) {
        File f = new File(workspaceLocation);
        if (!f.exists() && askCreate) {
            boolean create = MessageDialog.openConfirm((Shell)parentShell, (String)Messages.PickWorkspaceDialog_NewDirectoryTitle, (String)Messages.PickWorkspaceDialog_CreateDirQuestion);
            if (create) {
                try {
                    f.mkdirs();
                }
                catch (Exception exception) {
                    return Messages.PickWorkspaceDialog_ErrorCreatingDirsMsg;
                }
            }
            if (!f.exists()) {
                return Messages.PickWorkspaceDialog_DirNotExistMsg;
            }
            if (!f.canRead()) {
                return Messages.PickWorkspaceDialog_DirNotReadableMsg;
            }
            if (!f.isDirectory()) {
                return Messages.PickWorkspaceDialog_PathIsNotDirMsg;
            }
        }
        return null;
    }

    public static boolean checkAndCreateWorkspaceRoot(String wsRoot) {
        try {
            File fRoot = new File(wsRoot);
            if (!fRoot.exists()) {
                fRoot.mkdirs();
            }
            return true;
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }
}

