/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book;

import com.jaspersoft.studio.book.JRBookActivator;
import com.jaspersoft.studio.book.ThumbnailCacheItem;
import com.jaspersoft.studio.book.model.MReportPart;
import com.jaspersoft.studio.jasper.JSSReportConverter;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.jasper.ExtensionLoader;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.imageio.ImageIO;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignPart;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.part.PartComponent;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleGraphics2DExporterOutput;
import net.sf.jasperreports.export.SimpleGraphics2DReportConfiguration;
import net.sf.jasperreports.parts.subreport.SubreportPartComponent;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryResourceContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import net.sf.jasperreports.repo.SimpleRepositoryResourceContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.graphics.Device;

public class ReportThumbnailsManager {
    public static final int THUMBNAIL_SIZE = 120;
    public static final int SHADOW_SIZE = 4;
    private static Map<String, ThumbnailCacheItem> cachedItems = new HashMap<String, ThumbnailCacheItem>();
    private static Map<String, DatedItem<JRReport>> cachedReports = new HashMap<String, DatedItem<JRReport>>();
    private static HashSet<String> loadingItems = new HashSet();
    private static Image ERROR_IMAGE = null;
    private static String ERROR_IMAGE_LOCATION = "/icons/report_no_preview.png";
    private static Map<String, org.eclipse.swt.graphics.Image> temporarySwap = new HashMap<String, org.eclipse.swt.graphics.Image>();

    private static Image getErrorImage() {
        if (ERROR_IMAGE == null) {
            try {
                ERROR_IMAGE = ImageIO.read(new File(JRBookActivator.getDefault().getFileLocation(ERROR_IMAGE_LOCATION)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ERROR_IMAGE;
    }

    public static File findFile(String location, JasperReportsConfiguration context) {
        IFile file;
        block19: {
            InputStream in = null;
            try {
                IFile file2 = (IFile)context.get("ifile");
                String parentPath = file2.getParent().getLocation().toFile().getAbsolutePath();
                SimpleRepositoryResourceContext resContext = SimpleRepositoryResourceContext.of((String)parentPath);
                SimpleRepositoryContext repoContext = SimpleRepositoryContext.of((JasperReportsContext)context, (RepositoryResourceContext)resContext);
                in = RepositoryUtil.getInstance((RepositoryContext)repoContext).getInputStreamFromLocation(location);
                if (in instanceof FileInputStream) {
                    Field pathField = FileInputStream.class.getDeclaredField("path");
                    pathField.setAccessible(true);
                    String path = (String)pathField.get(in);
                    if (path != null) {
                        File file3 = new File(path);
                        FileUtils.closeStream((Closeable)in);
                        return file3;
                    }
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException | JRException e2) {
                e2.printStackTrace();
                break block19;
            }
            finally {
                FileUtils.closeStream(in);
            }
            FileUtils.closeStream((Closeable)in);
        }
        File f = null;
        try {
            f = new File(location);
            if (f.exists()) {
                return f;
            }
            String p = new URI(location).getPath();
            if (p != null && (f = new File(p)).exists()) {
                return f;
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        URL url = context.getClassLoader().getResource(location);
        if (url != null) {
            try {
                f = new File(url.toURI());
                if (f.exists()) {
                    return f;
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        if ((file = (IFile)context.get("ifile")) != null) {
            f = new File(file.getParent().getLocationURI());
            if ((f = new File(f, location)).exists()) {
                return f;
            }
            f = new File(file.getProject().getLocationURI());
            if ((f = new File(f, location)).exists()) {
                return f;
            }
        }
        return null;
    }

    public static org.eclipse.swt.graphics.Image produceImage(String location, JasperReportsConfiguration context) {
        return ReportThumbnailsManager.produceImage(location, context, 120, true, false);
    }

    public static org.eclipse.swt.graphics.Image produceImage(String location, JasperReportsConfiguration context, int thumbnailSize, boolean drawShadow, boolean cropDocument) {
        if (thumbnailSize == 0) {
            thumbnailSize = 120;
        }
        Image previewImage = null;
        File file = ReportThumbnailsManager.findFile(location, context);
        if (file == null || !file.exists()) {
            previewImage = ReportThumbnailsManager.getErrorImage();
        } else {
            JasperReportsConfiguration previewContext;
            ThumbnailCacheItem cachedItem = null;
            String cacheKey = String.valueOf(location) + thumbnailSize;
            if (cachedItems.containsKey(cacheKey) && (cachedItem = cachedItems.get(cacheKey)) != null && file.lastModified() > cachedItem.getTimestamp().getTime()) {
                cachedItems.remove(cacheKey);
                cachedReports.remove(file.toString());
                cachedItem = null;
            }
            if ((previewContext = context) == null) {
                previewContext = DefaultJasperReportsContext.getInstance();
            }
            if (cachedItem == null) {
                ReportThumbnailsManager.setLoadingItem(location);
                ExtensionLoader.waitIfLoading();
                JRReport report = null;
                try {
                    report = ReportThumbnailsManager.getReport(file);
                }
                catch (JRException e1) {
                    e1.printStackTrace();
                    previewImage = ReportThumbnailsManager.getErrorImage();
                }
                if (previewImage == null && report != null) {
                    float previewZoom = (float)thumbnailSize / (float)Math.max(report.getPageHeight(), report.getPageWidth());
                    int previewWidth = (int)((float)report.getPageWidth() * previewZoom);
                    int previewHeight = (int)((float)report.getPageHeight() * previewZoom);
                    previewImage = new BufferedImage(previewWidth, previewHeight, 1);
                    Graphics2D previewG2d = (Graphics2D)previewImage.getGraphics();
                    previewG2d.setBackground(Color.WHITE);
                    previewG2d.fillRect(0, 0, previewWidth, previewHeight);
                    previewG2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    previewG2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    previewG2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    try {
                        JasperPrint jasperPrint = new JSSReportConverter((JasperReportsContext)previewContext, report, false).getJasperPrint();
                        JRGraphics2DExporter exporter = new JRGraphics2DExporter((JasperReportsContext)previewContext);
                        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                        SimpleGraphics2DExporterOutput output = new SimpleGraphics2DExporterOutput();
                        output.setGraphics2D(previewG2d);
                        exporter.setExporterOutput((ExporterOutput)output);
                        SimpleGraphics2DReportConfiguration grxConfiguration = new SimpleGraphics2DReportConfiguration();
                        grxConfiguration.setPageIndex(Integer.valueOf(0));
                        grxConfiguration.setZoomRatio(Float.valueOf(previewZoom));
                        exporter.setConfiguration((ReportExportConfiguration)grxConfiguration);
                        exporter.exportReport();
                        cachedItem = new ThumbnailCacheItem(previewImage);
                        cachedReports.put(file.toString(), new DatedItem<JRReport>(report));
                        cachedItems.put(cacheKey, cachedItem);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        previewImage = ReportThumbnailsManager.getErrorImage();
                    }
                }
                ReportThumbnailsManager.removeLoadingItem(location);
            } else {
                previewImage = cachedItem.getPreview();
            }
        }
        return ReportThumbnailsManager.generateImage(previewImage, thumbnailSize, drawShadow, cropDocument);
    }

    private static JRReport getReport(File file) throws JRException {
        if (!file.getName().toLowerCase().endsWith(".jasper")) {
            return JRXmlLoader.load((File)file);
        }
        return (JRReport)JRLoader.loadObject((File)file);
    }

    public static final org.eclipse.swt.graphics.Image getNoPreviewImage(int thumbnailSize, boolean drawShadow, boolean cropDocument) {
        if (thumbnailSize == 0) {
            thumbnailSize = 120;
        }
        return ReportThumbnailsManager.generateImage(ReportThumbnailsManager.getErrorImage(), thumbnailSize, drawShadow, cropDocument);
    }

    private static final org.eclipse.swt.graphics.Image generateImage(Image previewImage, int thumbnailSize, boolean drawShadow, boolean cropDocument) {
        if (thumbnailSize == 0) {
            thumbnailSize = 120;
        }
        int imageWidth = thumbnailSize;
        int imageHeight = thumbnailSize;
        float documentWidth = previewImage.getWidth(null);
        float documentHeight = previewImage.getHeight(null);
        if (cropDocument) {
            imageWidth = (int)(documentWidth > documentHeight ? (float)thumbnailSize : documentWidth / documentHeight * (float)thumbnailSize);
            imageHeight = (int)(documentWidth > documentHeight ? documentHeight / documentWidth * (float)thumbnailSize : (float)thumbnailSize);
        }
        BufferedImage bi = new BufferedImage(imageWidth, imageHeight, 1);
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        float zoom = (float)(thumbnailSize - (drawShadow ? 8 : 0)) / Math.max(documentWidth, documentHeight);
        documentWidth *= zoom;
        documentHeight *= zoom;
        if (!cropDocument && drawShadow) {
            g2d.setBackground(Color.WHITE);
            g2d.fillRect(0, 0, imageWidth, imageHeight);
            int i = 4;
            while (i >= 0) {
                RoundRectangle2D.Double shadowTemplate = new RoundRectangle2D.Double((double)thumbnailSize / 2.0 - (double)documentWidth / 2.0 - (double)i, (double)thumbnailSize / 2.0 - (double)documentHeight / 2.0 - (double)i, documentWidth + (float)(2 * i), documentHeight + (float)(2 * i), 4.0, 4.0);
                g2d.setColor(new Color(250 - 8 * (4 - i), 250 - 8 * (4 - i), 250 - 8 * (4 - i)));
                g2d.fill(shadowTemplate);
                --i;
            }
            g2d.setColor(Color.WHITE);
            Rectangle2D.Double pageTemplate = new Rectangle2D.Double((double)thumbnailSize / 2.0 - (double)documentWidth / 2.0, (double)thumbnailSize / 2.0 - (double)documentHeight / 2.0, documentWidth, documentHeight);
            g2d.fill(pageTemplate);
        }
        if (!cropDocument) {
            g2d.setTransform(AffineTransform.getTranslateInstance((double)thumbnailSize / 2.0 - (double)documentWidth / 2.0, (double)thumbnailSize / 2.0 - (double)documentHeight / 2.0));
        }
        g2d.drawImage(previewImage, 0, 0, (int)documentWidth, (int)documentHeight, null);
        return UIUtils.awt2Swt((BufferedImage)bi);
    }

    public static void pushElementImage(String uuid, org.eclipse.swt.graphics.Image swtImage) {
        if (temporarySwap.containsKey(uuid)) {
            return;
        }
        if (swtImage == null || swtImage.isDisposed()) {
            return;
        }
        org.eclipse.swt.graphics.Image newCachedImage = new org.eclipse.swt.graphics.Image((Device)UIUtils.getDisplay(), swtImage, 0);
        temporarySwap.put(uuid, newCachedImage);
    }

    public static synchronized org.eclipse.swt.graphics.Image popElementImage(String uuid) {
        if (temporarySwap.containsKey(uuid)) {
            org.eclipse.swt.graphics.Image cachedImage = temporarySwap.get(uuid);
            temporarySwap.remove(uuid);
            return cachedImage;
        }
        return null;
    }

    public static String getLocation(MReportPart model) {
        JRExpression subreportExp;
        PartComponent partComponent;
        Object reportFileName = null;
        JRDesignPart jrDesignPart = model.getValue();
        JasperReportsConfiguration context = model.getJasperConfiguration();
        if (jrDesignPart != null && (partComponent = jrDesignPart.getComponent()) instanceof SubreportPartComponent && (subreportExp = ((SubreportPartComponent)partComponent).getExpression()) != null) {
            JRDesignDataset dataset = (JRDesignDataset)model.getJasperDesign().getMainDataset();
            reportFileName = ExpressionUtil.cachedExpressionEvaluation((JRExpression)subreportExp, (JasperReportsConfiguration)context, (JRDesignDataset)dataset);
        }
        if (reportFileName == null) {
            return null;
        }
        if (reportFileName instanceof File) {
            reportFileName = ((File)reportFileName).toURI().toString();
        } else if (!(reportFileName instanceof String)) {
            return null;
        }
        String location = reportFileName;
        File f = ReportThumbnailsManager.findFile(location, context);
        if ((f == null || !f.exists()) && location.toLowerCase().endsWith(".jasper")) {
            location = String.valueOf(location.substring(0, location.length() - ".jasper".length())) + ".jrxml";
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLoadingItem(String key) {
        HashSet<String> hashSet = loadingItems;
        synchronized (hashSet) {
            loadingItems.add(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeLoadingItem(String key) {
        HashSet<String> hashSet = loadingItems;
        synchronized (hashSet) {
            loadingItems.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isLoadingItem(String key) {
        HashSet<String> hashSet = loadingItems;
        synchronized (hashSet) {
            return loadingItems.contains(key);
        }
    }

    public static JRReport getJasperDesign(String location, JasperReportsConfiguration jrConfig) {
        while (ReportThumbnailsManager.isLoadingItem(location)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        JRReport report = null;
        File f = ReportThumbnailsManager.findFile(location, jrConfig);
        if (f != null) {
            String key = f.toString();
            DatedItem<JRReport> item = cachedReports.get(key);
            if (item != null && item.isOlder(f.lastModified())) {
                cachedReports.remove(key);
                item = null;
            }
            if (item != null) {
                report = (JRReport)item.value;
            }
            if (report == null) {
                try {
                    report = ReportThumbnailsManager.getReport(f);
                    cachedReports.put(key, new DatedItem<JRReport>(report));
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
        }
        return report;
    }

    static class DatedItem<T> {
        Date timestamp = new Date();
        T value;

        public DatedItem(T value) {
            this.value = value;
        }

        public boolean isOlder(long newt) {
            return this.timestamp.getTime() < newt;
        }
    }
}

