/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.dnd;

import com.jaspersoft.studio.book.dnd.DropLocation;
import com.jaspersoft.studio.book.editparts.BookPagesEditPart;
import com.jaspersoft.studio.book.editparts.BookSectionEditPart;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.swt.graphics.Cursor;

public class PageEditPartTracker
extends DragEditPartsTracker {
    private static DropLocation dropLocation = new DropLocation(null, null);

    public PageEditPartTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    private static Point getLocationFromRequest(Request request) {
        return ((DropRequest)request).getLocation();
    }

    protected void setTargetEditPart(EditPart editpart) {
        EditPart nextPart;
        if (this.getContainer() != null) {
            this.getContainer().eraseTargetFeedback();
        }
        if (this.getSourceEditPart() == null || this.getSourceEditPart() instanceof BookSectionEditPart) {
            dropLocation.reset();
        } else {
            Point pt = PageEditPartTracker.getLocationFromRequest(this.getTargetRequest());
            dropLocation = PageEditPartTracker.getDropLocation(editpart, pt);
        }
        if (this.getContainer() != null && this.getOperationSet().contains(this.getAfterPart())) {
            dropLocation.reset();
        }
        if (this.getContainer() != null && this.getAfterPart() != null && (nextPart = this.getContainer().getFollowingPart(this.getAfterPart())) != null && this.getOperationSet().contains(nextPart)) {
            dropLocation.reset();
        }
        super.setTargetEditPart((EditPart)this.getContainer());
    }

    public EditPart getAfterPart() {
        return dropLocation.getAfterPart();
    }

    public BookSectionEditPart getContainer() {
        return dropLocation.getContainer();
    }

    protected void showTargetFeedback() {
        if (this.getContainer() != null) {
            this.getContainer().showTargetFeedback(this.getAfterPart());
        }
    }

    protected Cursor calculateCursor() {
        if (this.getState() == 1) {
            return super.calculateCursor();
        }
        if (this.getContainer() == null) {
            return SharedCursors.NO;
        }
        return SharedCursors.CURSOR_TREE_ADD;
    }

    public void eraseTargetFeedback() {
        if (this.getContainer() != null) {
            this.getContainer().eraseTargetFeedback();
        }
    }

    public static DropLocation getDropLocation(EditPart targetPart, Point location) {
        Object afterPart = null;
        BookSectionEditPart container = null;
        if (targetPart instanceof BookSectionEditPart) {
            container = (BookSectionEditPart)targetPart;
            List children = container.getChildren();
            if (container.getChildren().size() == 0) {
                afterPart = null;
            } else {
                Transposer transposer = new Transposer();
                Point pt = transposer.t(location);
                int multiplier = 1;
                while (multiplier < 10) {
                    PrecisionPoint ptLeft = new PrecisionPoint(pt.x - 5 * multiplier, pt.y);
                    PrecisionPoint ptRight = new PrecisionPoint(pt.x + 5 * multiplier, pt.y);
                    EditPart itemLeft = container.getViewer().findObjectAt((Point)ptLeft);
                    if (itemLeft != null && itemLeft instanceof BookPagesEditPart) {
                        afterPart = itemLeft;
                        break;
                    }
                    EditPart itemRight = container.getViewer().findObjectAt((Point)ptRight);
                    if (itemRight != null && itemRight instanceof BookPagesEditPart) {
                        int rightItemIndex = children.indexOf(itemRight);
                        if (rightItemIndex == 0) {
                            afterPart = null;
                            break;
                        }
                        afterPart = (EditPart)children.get(rightItemIndex - 1);
                        break;
                    }
                    ++multiplier;
                }
                if (afterPart == null) {
                    afterPart = (EditPart)container.getChildren().get(container.getChildren().size() - 1);
                }
            }
        } else if (targetPart instanceof BookPagesEditPart) {
            int currentIndex;
            container = (BookSectionEditPart)targetPart.getParent();
            Rectangle elementBounds = ((BookPagesEditPart)targetPart).getFigure().getBounds();
            int halfWidth = elementBounds.width / 2;
            Rectangle splitLeft = new Rectangle(elementBounds.x, elementBounds.y, halfWidth, elementBounds.height);
            List children = container.getChildren();
            if (children.isEmpty()) {
                afterPart = null;
            }
            afterPart = splitLeft.contains(location) ? ((currentIndex = children.indexOf(targetPart)) == 0 ? null : (EditPart)children.get(currentIndex - 1)) : targetPart;
        }
        return new DropLocation(container, (BookPagesEditPart)((Object)afterPart));
    }

    public void updateDropLocation(DropLocation location) {
        this.eraseTargetFeedback();
        dropLocation = location;
        this.showTargetFeedback();
        this.showSourceFeedback();
    }
}

