/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.editors.actions;

import com.jaspersoft.studio.book.JRBookActivator;
import com.jaspersoft.studio.book.messages.Messages;
import com.jaspersoft.studio.book.model.MReportPart;
import com.jaspersoft.studio.book.model.MReportPartContainer;
import com.jaspersoft.studio.book.model.commands.CreatePartCommand;
import com.jaspersoft.studio.book.wizards.AddPageWizardPage;
import com.jaspersoft.studio.editor.outline.actions.ACreateAndSelectAction;
import com.jaspersoft.studio.model.subreport.MSubreport;
import com.jaspersoft.studio.model.subreport.command.wizard.NewSubreportPage;
import com.jaspersoft.studio.model.subreport.command.wizard.SubreportWizard;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignPart;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JRDesignSubreportParameter;
import net.sf.jasperreports.parts.subreport.StandardSubreportPartComponent;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class CreateNewBookPartAction
extends ACreateAndSelectAction {
    public static final String ID = "create_book_part";

    public CreateNewBookPartAction(IWorkbenchPart part) {
        super(part);
    }

    protected void init() {
        super.init();
        this.setText(Messages.CreateNewBookPartAction_actionTitle);
        this.setToolTipText(Messages.CreateNewBookPartAction_actionTooltip);
        this.setId(ID);
        this.setImageDescriptor(JRBookActivator.getDefault().getImageDescriptor("/icons/add.png"));
        this.setEnabled(false);
    }

    protected boolean calculateEnabled() {
        Object obj;
        ISelection s = this.getSelection();
        return s instanceof StructuredSelection && (obj = ((StructuredSelection)s).getFirstElement()) instanceof AbstractEditPart && ((AbstractEditPart)obj).getModel() instanceof MReportPartContainer;
    }

    public void run() {
        Object model;
        Object obj;
        ISelection s = this.getSelection();
        if (s instanceof StructuredSelection && (obj = ((StructuredSelection)s).getFirstElement()) instanceof AbstractEditPart && (model = ((AbstractEditPart)obj).getModel()) instanceof MReportPartContainer) {
            MReportPartContainer partContainer = (MReportPartContainer)((Object)model);
            SubreportWizard wizard = new SubreportWizard(){

                protected NewSubreportPage getSubreportPage() {
                    return new AddPageWizardPage();
                }
            };
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            wizard.setConfig(partContainer.getJasperConfiguration(), false);
            dialog.create();
            if (dialog.open() == 0) {
                MSubreport srcNode = wizard.getSubreport();
                JRDesignSubreport subreport = srcNode.getValue();
                String subReportExpression = subreport.getExpression().getText();
                JRDesignPart newBookPart = MReportPart.createJRElement(new JRDesignExpression(subReportExpression));
                this.setDataParameters(newBookPart, subreport.getConnectionExpression(), subreport.getDataSourceExpression(), subreport.getParameters());
                this.getCommandStack().execute((Command)new CreatePartCommand(partContainer, newBookPart, -1));
            }
        }
    }

    private void setDataParameters(JRDesignPart newPart, JRExpression connectionExp, JRExpression datasourceExp, JRSubreportParameter[] parameters) {
        if (newPart.getComponent() instanceof StandardSubreportPartComponent) {
            JRDesignSubreportParameter param;
            StandardSubreportPartComponent subPart = (StandardSubreportPartComponent)newPart.getComponent();
            if (connectionExp != null) {
                param = new JRDesignSubreportParameter();
                param.setName("REPORT_CONNECTION");
                param.setExpression(connectionExp);
                try {
                    subPart.addParameter((JRSubreportParameter)param);
                }
                catch (JRException e) {
                    e.printStackTrace();
                    JRBookActivator.getDefault().logError(e);
                }
            }
            if (datasourceExp != null) {
                param = new JRDesignSubreportParameter();
                param.setName("REPORT_DATA_SOURCE");
                param.setExpression(datasourceExp);
                try {
                    subPart.addParameter((JRSubreportParameter)param);
                }
                catch (JRException e) {
                    e.printStackTrace();
                    JRBookActivator.getDefault().logError(e);
                }
            }
            if (parameters != null) {
                JRSubreportParameter[] jRSubreportParameterArray = parameters;
                int n = parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    JRSubreportParameter parameter = jRSubreportParameterArray[n2];
                    if (!subPart.getParametersMap().containsKey(parameter.getName())) {
                        JRSubreportParameter newParam = (JRSubreportParameter)parameter.clone();
                        try {
                            subPart.addParameter(newParam);
                        }
                        catch (JRException e) {
                            e.printStackTrace();
                            JRBookActivator.getDefault().logError(e);
                        }
                    }
                    ++n2;
                }
            }
        }
    }
}

