/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.gallery.commands;

import com.jaspersoft.studio.book.editors.ReportPartGalleryElement;
import com.jaspersoft.studio.book.gallery.controls.GalleryComposite;
import com.jaspersoft.studio.book.gallery.interfaces.IGalleryElement;
import com.jaspersoft.studio.book.model.IReportPartContainer;
import com.jaspersoft.studio.book.model.MReportPart;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.util.ReportFactory;
import net.sf.jasperreports.engine.JRPart;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignPart;
import net.sf.jasperreports.engine.design.JRDesignSection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CreateElementAfterCommand
extends AbstractOperation {
    private IGalleryElement elementToCreate;
    private GalleryComposite container;
    private IGalleryElement afterElement;
    private String partPath;

    public CreateElementAfterCommand(GalleryComposite container, IGalleryElement elementToCreate, IGalleryElement afterElement) {
        super("Create Element Command");
        this.partPath = (String)elementToCreate.getData();
        this.elementToCreate = elementToCreate;
        this.afterElement = afterElement;
        this.container = container;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        int afterIndex;
        int chosenIndex = -1;
        chosenIndex = this.afterElement == null ? 0 : ((afterIndex = this.container.getIndexOf(this.afterElement)) == this.container.getContentSize() - 1 ? -1 : afterIndex + 1);
        IReportPartContainer partsContainer = this.container.getPartsContainer();
        JRDesignSection jrsection = partsContainer.getSection();
        if (jrsection != null) {
            JRDesignPart part = MReportPart.createJRElement(new JRDesignExpression(this.partPath));
            if (chosenIndex != -1) {
                jrsection.addPart(chosenIndex, (JRPart)part);
            } else {
                jrsection.addPart((JRPart)part);
            }
            MReportPart partNode = (MReportPart)ReportFactory.createNode((ANode)((ANode)partsContainer), (Object)part, (int)chosenIndex);
            this.elementToCreate = new ReportPartGalleryElement(partNode);
            this.container.createItem(this.elementToCreate, chosenIndex);
        }
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        int createdIndex = this.container.getIndexOf(this.elementToCreate);
        this.container.removeItem(createdIndex);
        return Status.OK_STATUS;
    }
}

