/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.gallery.commands;

import com.jaspersoft.studio.book.editors.ReportPartGalleryElement;
import com.jaspersoft.studio.book.gallery.controls.GalleryComposite;
import com.jaspersoft.studio.book.gallery.interfaces.IGalleryElement;
import com.jaspersoft.studio.book.model.IReportPartContainer;
import com.jaspersoft.studio.book.model.MReportPart;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.util.ReportFactory;
import net.sf.jasperreports.engine.JRPart;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignPart;
import net.sf.jasperreports.engine.design.JRDesignSection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CreateElementCommand
extends AbstractOperation {
    private IGalleryElement elementToCreate;
    private GalleryComposite container;
    private int index = -1;
    private String partPath;

    public CreateElementCommand(GalleryComposite container, IGalleryElement elementToCreate, int index) {
        super("Create Element");
        this.partPath = (String)elementToCreate.getData();
        this.elementToCreate = elementToCreate;
        this.index = index;
        this.container = container;
    }

    public CreateElementCommand(GalleryComposite container, IGalleryElement elementToCreate) {
        this(container, elementToCreate, -1);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IReportPartContainer partsContainer;
        JRDesignSection jrsection;
        if (this.index < 0 || this.index >= this.container.getContentSize()) {
            this.index = -1;
        }
        if ((jrsection = (partsContainer = this.container.getPartsContainer()).getSection()) != null) {
            JRDesignPart part = MReportPart.createJRElement(new JRDesignExpression(this.partPath));
            if (this.index == -1) {
                jrsection.addPart((JRPart)part);
            } else {
                jrsection.addPart(this.index, (JRPart)part);
            }
            MReportPart partNode = (MReportPart)ReportFactory.createNode((ANode)((ANode)partsContainer), (Object)part, (int)this.index);
            this.elementToCreate = new ReportPartGalleryElement(partNode);
            this.container.createItem(this.elementToCreate, this.index);
        }
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.index < 0 || this.index > this.container.getContentSize()) {
            this.index = this.container.getContentSize() - 1;
        }
        this.container.removeItem(this.index);
        return Status.OK_STATUS;
    }
}

