/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.gallery.commands;

import com.jaspersoft.studio.book.gallery.controls.GalleryComposite;
import com.jaspersoft.studio.book.gallery.interfaces.IGalleryElement;
import com.jaspersoft.studio.book.model.MReportPart;
import net.sf.jasperreports.engine.JRPart;
import net.sf.jasperreports.engine.design.JRDesignPart;
import net.sf.jasperreports.engine.design.JRDesignSection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DeleteItemCommand
extends AbstractOperation {
    private GalleryComposite container;
    private int index;
    private IGalleryElement deletedElement = null;
    private JRDesignPart part;
    private JRDesignSection jrsection;

    public DeleteItemCommand(GalleryComposite container, IGalleryElement elementToDelete) {
        super("Delete Item");
        this.container = container;
        this.index = container.getIndexOf(elementToDelete);
        MReportPart mpart = (MReportPart)((Object)elementToDelete.getData());
        this.part = mpart.getValue();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.deletedElement = this.container.removeItem(this.index);
        JRDesignSection jrsection = this.container.getPartsContainer().getSection();
        if (jrsection != null) {
            jrsection.removePart((JRPart)this.part);
        }
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.container.createItem(this.deletedElement, this.index);
        if (this.jrsection != null) {
            this.jrsection.addPart(this.index, (JRPart)this.part);
        }
        this.deletedElement = null;
        return Status.OK_STATUS;
    }
}

