/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.gallery.controls;

import com.jaspersoft.studio.book.gallery.commands.CompoundOperation;
import com.jaspersoft.studio.book.gallery.commands.CreateElementAfterCommand;
import com.jaspersoft.studio.book.gallery.commands.CreateElementCommand;
import com.jaspersoft.studio.book.gallery.commands.MoveElementAfter;
import com.jaspersoft.studio.book.gallery.commands.MoveElementToEnd;
import com.jaspersoft.studio.book.gallery.controls.DropEffectLocation;
import com.jaspersoft.studio.book.gallery.controls.DropLocation;
import com.jaspersoft.studio.book.gallery.controls.GalleryComposite;
import com.jaspersoft.studio.book.gallery.controls.GalleryTransfer;
import com.jaspersoft.studio.book.gallery.implementations.PageElement;
import com.jaspersoft.studio.book.gallery.interfaces.IGalleryElement;
import java.util.ArrayList;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.ResourceTransfer;

public class GalleryDropTargetListener
implements DropTargetListener {
    private GalleryComposite lastTargetGallery = null;

    public void drop(DropTargetEvent event) {
        DropLocation currentDrop = new DropLocation();
        TransferData[] transferDataArray = event.dataTypes;
        int n = event.dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData eventData = transferDataArray[n2];
            if (ResourceTransfer.getInstance().isSupportedType(eventData)) {
                this.getExternalDropLocation(event.x, event.y, currentDrop);
                this.parseExternalResources((IResource[])event.data, currentDrop);
                currentDrop.getTargetGallery().clearDropEffect(true);
                break;
            }
            if (GalleryTransfer.getInstance().isSupportedType(eventData)) {
                DropLocation location = new DropLocation();
                GalleryComposite sourceGallery = GalleryTransfer.getInstance().getSourceGallery();
                location.setSourceGallery(sourceGallery);
                if (sourceGallery.isSelectionEmpty()) break;
                this.getDropLocation(event.x, event.y, location);
                if (location.isValid()) {
                    GalleryItem movedItem = location.getSourceGallery().getGallery().getSelection()[0];
                    if (location.isPlacedAfter()) {
                        this.placeAfter(location.getItem(), movedItem, location);
                    } else {
                        this.placeBefore(location.getItem(), movedItem, location);
                    }
                } else if (location.getTargetGallery() != null && location.getTargetGallery().isEmpty()) {
                    GalleryItem movedItem = location.getSourceGallery().getGallery().getSelection()[0];
                    MoveElementToEnd moveAfterCommand = new MoveElementToEnd((IGalleryElement)movedItem.getData(), location.getSourceGallery(), location.getTargetGallery());
                    location.getTargetGallery().executeCommand(moveAfterCommand);
                }
                location.getTargetGallery().clearDropEffect(true);
                break;
            }
            ++n2;
        }
        this.lastTargetGallery = null;
    }

    public void dragOver(DropTargetEvent event) {
        DropLocation currentDrop = new DropLocation();
        TransferData[] transferDataArray = event.dataTypes;
        int n = event.dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData eventData = transferDataArray[n2];
            if (ResourceTransfer.getInstance().isSupportedType(eventData)) {
                this.getExternalDropLocation(event.x, event.y, currentDrop);
                break;
            }
            if (GalleryTransfer.getInstance().isSupportedType(eventData)) {
                currentDrop.setSourceGallery(GalleryTransfer.getInstance().getSourceGallery());
                this.getDropLocation(event.x, event.y, currentDrop);
                break;
            }
            ++n2;
        }
        if (currentDrop.isValid() && !this.hasAlreadyEffect(currentDrop)) {
            GalleryComposite target = currentDrop.getTargetGallery();
            DropEffectLocation lastDropEffect = target.getDropTargetEffect();
            lastDropEffect.setItem(currentDrop.getItem());
            lastDropEffect.setPlaceAfer(currentDrop.isPlacedAfter());
            target.getGallery().redraw();
        }
    }

    private boolean hasAlreadyEffect(DropLocation dropLocation) {
        GalleryComposite target = dropLocation.getTargetGallery();
        DropEffectLocation lastDropEffect = target.getDropTargetEffect();
        return lastDropEffect.getItem() == dropLocation.getItem() && lastDropEffect.isPlacedAfter() == dropLocation.isPlacedAfter();
    }

    public void dragLeave(DropTargetEvent event) {
        if (this.lastTargetGallery != null) {
            this.lastTargetGallery.clearDropEffect(false);
        }
    }

    public void dragEnter(DropTargetEvent event) {
        Display currentDisplay = UIUtils.getDisplay();
        Control hoveredControl = currentDisplay.getCursorControl();
        if (hoveredControl.getParent() instanceof GalleryComposite) {
            this.lastTargetGallery = (GalleryComposite)hoveredControl.getParent();
        }
    }

    private void getDropLocation(int currentX, int currentY, DropLocation currentLocation) {
        currentLocation.setItem(null);
        if (this.lastTargetGallery != null && currentLocation.getSourceGallery() != null && !currentLocation.getSourceGallery().isSelectionEmpty()) {
            currentLocation.setTargetGallery(this.lastTargetGallery);
            Display currentDisplay = UIUtils.getDisplay();
            Point pt = currentDisplay.map(null, (Control)currentLocation.getTargetGallery(), currentX, currentY);
            GalleryItem currentItem = currentLocation.getTargetGallery().getGallery().getItem(pt);
            GalleryItem movedItem = currentLocation.getSourceGallery().getGallery().getSelection()[0];
            if (currentItem == null) {
                int multiplier = 1;
                Gallery targetGallery = currentLocation.getTargetGallery().getGallery();
                while (multiplier < 10) {
                    Point ptLeft = new Point(pt.x - 5 * multiplier, pt.y);
                    Point ptRight = new Point(pt.x + 5 * multiplier, pt.y);
                    GalleryItem itemLeft = targetGallery.getItem(ptLeft);
                    if (itemLeft != null) {
                        currentLocation.setItem(itemLeft);
                        currentLocation.setPlaceAfer(true);
                        break;
                    }
                    GalleryItem itemRight = targetGallery.getItem(ptRight);
                    if (itemRight != null) {
                        currentLocation.setItem(itemRight);
                        currentLocation.setPlaceAfer(false);
                        break;
                    }
                    ++multiplier;
                }
            } else if (currentItem != movedItem) {
                Rectangle elementBounds = currentItem.getBounds();
                int halfWidth = elementBounds.width / 2;
                Rectangle splitLeft = new Rectangle(elementBounds.x, elementBounds.y, halfWidth, elementBounds.height);
                if (splitLeft.contains(pt)) {
                    currentLocation.setItem(currentItem);
                    currentLocation.setPlaceAfer(false);
                } else {
                    currentLocation.setItem(currentItem);
                    currentLocation.setPlaceAfer(true);
                }
            }
            if (currentLocation.isValid()) {
                GalleryItem galleryRoot = currentLocation.getTargetGallery().getGallery().getItem(0);
                if (currentLocation.getItem() == movedItem) {
                    currentLocation.setItem(null);
                } else if (currentLocation.isPlacedAfter()) {
                    GalleryItem nextItem;
                    int index = galleryRoot.indexOf(currentLocation.getItem());
                    if (index != galleryRoot.getItemCount() - 1 && (nextItem = galleryRoot.getItem(index + 1)) == movedItem) {
                        currentLocation.setItem(null);
                    }
                } else {
                    GalleryItem previousItem;
                    int index = galleryRoot.indexOf(currentLocation.getItem());
                    if (index != 0 && (previousItem = galleryRoot.getItem(index - 1)) == movedItem) {
                        currentLocation.setItem(null);
                    }
                }
            }
        }
    }

    private void getExternalDropLocation(int currentX, int currentY, DropLocation currentLocation) {
        currentLocation.setItem(null);
        if (this.lastTargetGallery != null) {
            currentLocation.setTargetGallery(this.lastTargetGallery);
            Display currentDisplay = UIUtils.getDisplay();
            Point pt = currentDisplay.map(null, (Control)currentLocation.getTargetGallery(), currentX, currentY);
            GalleryItem currentItem = currentLocation.getTargetGallery().getGallery().getItem(pt);
            if (currentItem == null) {
                int multiplier = 1;
                Gallery targetGallery = currentLocation.getTargetGallery().getGallery();
                while (multiplier < 10) {
                    Point ptLeft = new Point(pt.x - 5 * multiplier, pt.y);
                    Point ptRight = new Point(pt.x + 5 * multiplier, pt.y);
                    GalleryItem itemLeft = targetGallery.getItem(ptLeft);
                    if (itemLeft != null) {
                        currentLocation.setItem(itemLeft);
                        currentLocation.setPlaceAfer(true);
                        break;
                    }
                    GalleryItem itemRight = targetGallery.getItem(ptRight);
                    if (itemRight != null) {
                        currentLocation.setItem(itemRight);
                        currentLocation.setPlaceAfer(false);
                        break;
                    }
                    ++multiplier;
                }
            } else {
                Rectangle elementBounds = currentItem.getBounds();
                int halfWidth = elementBounds.width / 2;
                Rectangle splitLeft = new Rectangle(elementBounds.x, elementBounds.y, halfWidth, elementBounds.height);
                if (splitLeft.contains(pt)) {
                    currentLocation.setItem(currentItem);
                    currentLocation.setPlaceAfer(false);
                } else {
                    currentLocation.setItem(currentItem);
                    currentLocation.setPlaceAfer(true);
                }
            }
            if (currentLocation.getItem() == null && !this.lastTargetGallery.isEmpty()) {
                GalleryItem rootItem = this.lastTargetGallery.getGallery().getItem(0);
                currentLocation.setItem(rootItem.getItem(rootItem.getItemCount() - 1));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void parseExternalResources(IResource[] input, DropLocation drop) {
        void var5_9;
        ArrayList<PageElement> readElements = new ArrayList<PageElement>();
        IResource[] iResourceArray = input;
        int n = input.length;
        boolean n2 = false;
        while (var5_9 < n) {
            IFile file;
            IResource resource = iResourceArray[var5_9];
            if (resource instanceof IFile && (file = (IFile)resource).getName().toLowerCase().endsWith(".jrxml")) {
                readElements.add(new PageElement(file.getRawLocation().makeAbsolute().toPortableString()));
            }
            ++var5_9;
        }
        if (drop.getTargetGallery().isEmpty()) {
            CompoundOperation cc = new CompoundOperation("Move Elements");
            for (IGalleryElement iGalleryElement : readElements) {
                CreateElementCommand createCommand = new CreateElementCommand(drop.getTargetGallery(), iGalleryElement);
                cc.add(createCommand);
            }
            drop.getTargetGallery().executeCommand(cc);
        } else if (readElements.size() > 0 && drop.isValid()) {
            IGalleryElement firstElement = (IGalleryElement)readElements.get(0);
            CompoundOperation compoundOperation = new CompoundOperation("Move Elements");
            IGalleryElement selectedNode = (IGalleryElement)drop.getItem().getData();
            if (drop.isPlacedAfter()) {
                CreateElementAfterCommand firstCommand = new CreateElementAfterCommand(drop.getTargetGallery(), firstElement, selectedNode);
                compoundOperation.add(firstCommand);
            } else {
                IGalleryElement previousNode = null;
                int selectedNodeIndex = drop.getTargetGallery().getIndexOf(selectedNode);
                if (selectedNodeIndex > 0) {
                    previousNode = drop.getTargetGallery().getElementAt(selectedNodeIndex - 1);
                }
                CreateElementAfterCommand firstCommand = new CreateElementAfterCommand(drop.getTargetGallery(), firstElement, previousNode);
                compoundOperation.add(firstCommand);
            }
            IGalleryElement afterNode = firstElement;
            int i = 1;
            while (i < readElements.size()) {
                IGalleryElement currentNode = (IGalleryElement)readElements.get(i);
                CreateElementAfterCommand firstCommand = new CreateElementAfterCommand(drop.getTargetGallery(), currentNode, afterNode);
                compoundOperation.add(firstCommand);
                afterNode = currentNode;
                ++i;
            }
            drop.getTargetGallery().executeCommand(compoundOperation);
        }
    }

    private boolean placeAfter(GalleryItem afterItem, GalleryItem movedItem, DropLocation location) {
        if (afterItem == movedItem) {
            return false;
        }
        MoveElementAfter moveAfterCommand = new MoveElementAfter((IGalleryElement)afterItem.getData(), (IGalleryElement)movedItem.getData(), location.getSourceGallery(), location.getTargetGallery());
        location.getTargetGallery().executeCommand(moveAfterCommand);
        return true;
    }

    private boolean placeBefore(GalleryItem beforeItem, GalleryItem movedItem, DropLocation location) {
        if (beforeItem == movedItem) {
            return false;
        }
        IGalleryElement beforeItemContainer = (IGalleryElement)beforeItem.getData();
        int beforeItemIndex = location.getTargetGallery().getElements().indexOf(beforeItemContainer);
        if (beforeItemIndex == 0) {
            MoveElementAfter moveAfterCommand = new MoveElementAfter(null, (IGalleryElement)movedItem.getData(), location.getSourceGallery(), location.getTargetGallery());
            location.getTargetGallery().executeCommand(moveAfterCommand);
        } else {
            beforeItemContainer = location.getTargetGallery().getElements().get(beforeItemIndex - 1);
            MoveElementAfter moveAfterCommand = new MoveElementAfter(beforeItemContainer, (IGalleryElement)movedItem.getData(), location.getSourceGallery(), location.getTargetGallery());
            location.getTargetGallery().executeCommand(moveAfterCommand);
        }
        return true;
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }
}

