/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.svgimporter;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.svgimporter.CreateResourceCommand;
import com.jaspersoft.studio.svgimporter.InkscapeSVGDocumentFactory;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Pair;
import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignEllipse;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignLine;
import net.sf.jasperreports.engine.design.JRDesignRectangle;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;
import net.sf.jasperreports.engine.util.JRTextMeasurerUtil;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.anim.dom.SVGOMEllipseElement;
import org.apache.batik.anim.dom.SVGOMGElement;
import org.apache.batik.anim.dom.SVGOMImageElement;
import org.apache.batik.anim.dom.SVGOMMaskElement;
import org.apache.batik.anim.dom.SVGOMPathElement;
import org.apache.batik.anim.dom.SVGOMRectElement;
import org.apache.batik.anim.dom.SVGOMSVGElement;
import org.apache.batik.anim.dom.SVGOMTSpanElement;
import org.apache.batik.anim.dom.SVGOMTextElement;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.GenericText;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.AWTTransformProducer;
import org.apache.batik.parser.PathHandler;
import org.apache.batik.parser.PathParser;
import org.apache.batik.parser.TransformListHandler;
import org.apache.batik.parser.TransformListParser;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.apache.batik.util.Base64DecodeStream;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.svg.SVGPaint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGDocumentLoader {
    private static final double degree = 57.29577951308232;
    private static final double radian = Math.PI / 180;
    protected static final String IMPORTED_IMAGE_PREFIX = "imported_image_";
    private Document svgDocument;
    private JasperReportsConfiguration jConfig;
    private List<Pair<File, JRDesignImage>> resources = new ArrayList<Pair<File, JRDesignImage>>();
    private HashMap<String, List<BufferedImage>> masks = new HashMap();

    public SVGDocumentLoader(String uri, JasperReportsConfiguration jConfig) throws IOException {
        this.setSVGDocument(this.createSVGDocument(uri));
        this.jConfig = jConfig;
    }

    protected String createSpacesString(int numberOfSpaces) {
        char[] chars = new char[numberOfSpaces];
        Arrays.fill(chars, ' ');
        return new String(chars);
    }

    protected int getSplitPoint(String text, int startPoint) {
        char[] chars = text.toCharArray();
        int i = startPoint;
        while (i < chars.length) {
            char c = chars[i];
            if (c == ' ') {
                return i;
            }
            if (c == '.' || c == ',') {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    private AffineTransform getTransofrm(SVGOMElement element) {
        TransformListParser transformMatrix = new TransformListParser();
        AWTTransformProducer matrixProducer = new AWTTransformProducer();
        transformMatrix.setTransformListHandler((TransformListHandler)matrixProducer);
        transformMatrix.parse(element.getAttribute("transform"));
        return matrixProducer.getAffineTransform();
    }

    private boolean isBold(CSSStyleDeclaration style) {
        String fontWeight = style.getPropertyValue("font-weight");
        if (fontWeight != null && !fontWeight.trim().isEmpty()) {
            if (fontWeight.equalsIgnoreCase("bold") || fontWeight.equalsIgnoreCase("bolder")) {
                return true;
            }
            if (StringUtils.isNumeric((String)fontWeight)) {
                try {
                    int weight = Integer.parseInt(fontWeight);
                    return weight > 500;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return false;
    }

    private float getStrokeWidth(CSSStyleDeclaration style) {
        String strokeWidth = style.getPropertyValue("stroke-width");
        if (StringUtils.isNumeric((String)strokeWidth)) {
            try {
                return Float.parseFloat(strokeWidth);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return 0.0f;
    }

    private boolean isItalic(CSSStyleDeclaration style) {
        String fontWeight = style.getPropertyValue("font-style");
        return fontWeight != null && !fontWeight.trim().isEmpty() && (fontWeight.equalsIgnoreCase("oblique") || fontWeight.equalsIgnoreCase("italic"));
    }

    public Color getColor(SVGPaint svgPaint) {
        Color returnColor = null;
        if (svgPaint != null && svgPaint.getPaintType() == 1) {
            RGBColor rgb = svgPaint.getRGBColor();
            float red = rgb.getRed().getFloatValue((short)1);
            float green = rgb.getGreen().getFloatValue((short)1);
            float blue = rgb.getBlue().getFloatValue((short)1);
            returnColor = new Color(red / 255.0f, green / 255.0f, blue / 255.0f);
        }
        return returnColor;
    }

    public Color getColor(CSSStyleDeclaration style, String attribute) {
        SVGPaint svgPaint = (SVGPaint)style.getPropertyCSSValue(attribute);
        return this.getColor(svgPaint);
    }

    private int getAwtFontStyle(boolean isBold, boolean isItalic) {
        int result = 0;
        if (isBold) {
            result |= 1;
        }
        if (isItalic) {
            result |= 2;
        }
        return result;
    }

    private Number parseNumber(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private double parseCoordinates(String value) {
        if (value == null || value.trim().isEmpty()) {
            return 0.0;
        }
        if (value.contains(" ")) {
            value = value.split(" ")[0];
        }
        return Double.parseDouble(value);
    }

    private List<Double> parseCoordinatesList(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        String[] stringValues = value.split(" ");
        ArrayList<Double> result = new ArrayList<Double>();
        String[] stringArray = stringValues;
        int n = stringValues.length;
        int n2 = 0;
        while (n2 < n) {
            String stringValue = stringArray[n2];
            try {
                result.add(Double.parseDouble(stringValue));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
        return result;
    }

    private double getRotation(AffineTransform transform) {
        double a = transform.getScaleX();
        double c = transform.getShearX();
        double scaleX = Math.sqrt(Math.pow(a, 2.0) + Math.pow(c, 2.0));
        double sign = Math.atan(-c / a);
        double rad = Math.acos(a / scaleX);
        double deg = rad * 57.29577951308232;
        double rotation = deg > 90.0 && sign > 0.0 ? (360.0 - deg) * (Math.PI / 180) : (deg < 90.0 && sign < 0.0 ? (360.0 - deg) * (Math.PI / 180) : rad);
        return rotation * 57.29577951308232;
    }

    private JRMeasuredText getTextSize(JRDesignStaticText newStaticText) {
        String text = newStaticText.getText();
        JRTextMeasurer measurer = JRTextMeasurerUtil.getInstance((JasperReportsContext)this.jConfig).createTextMeasurer((JRCommonText)newStaticText, null);
        HashMap attributes = new HashMap();
        FontUtil.getInstance((JasperReportsContext)this.jConfig).getAttributesWithoutAwtFont(attributes, (JRFont)newStaticText);
        JRStyledText styledText = JRStyledTextParser.getInstance().getStyledText(attributes, text, !"none".equals(newStaticText.getMarkup()), Locale.getDefault());
        styledText = JRStyledTextUtil.getInstance((JasperReportsContext)this.jConfig).resolveFonts(styledText, Locale.getDefault());
        JRMeasuredText measuredText = measurer.measure(styledText, 0, 2000, false, false);
        return measuredText;
    }

    private JRDesignStaticText generateText(String text, CSSStyleDeclaration style, int x, int y, List<Double> singleCharX, SVGRect boundingBox, AffineTransform transform) {
        if (text == null || text.trim().isEmpty()) {
            return null;
        }
        JRDesignStaticText newStaticText = new JRDesignStaticText();
        float fontSize = 9.0f;
        String fontSizeText = style.getPropertyValue("font-size");
        if (fontSizeText != null && !fontSizeText.trim().isEmpty()) {
            if (fontSizeText.endsWith("px")) {
                fontSizeText = fontSizeText.substring(0, fontSizeText.length() - 2);
            }
            fontSize = Float.valueOf(fontSizeText).floatValue();
        }
        newStaticText.setFontSize(Float.valueOf(fontSize));
        String fontFamily = style.getPropertyValue("font-family");
        if (fontFamily != null && !fontFamily.trim().isEmpty()) {
            newStaticText.setFontName(fontFamily);
        } else {
            fontFamily = "sans-serif";
        }
        Color foregroundColor = this.getColor(style, "fill");
        if (foregroundColor != null) {
            newStaticText.setForecolor(foregroundColor);
        }
        Boolean isBold = this.isBold(style);
        newStaticText.setBold(isBold);
        Boolean isItalic = this.isItalic(style);
        newStaticText.setItalic(isItalic);
        double rotation = this.getRotation(transform);
        if (rotation != 0.0) {
            if (rotation > 0.0 && rotation <= 90.0) {
                newStaticText.setRotation(RotationEnum.RIGHT);
            } else if (rotation > 90.0 && rotation <= 180.0) {
                newStaticText.setRotation(RotationEnum.UPSIDE_DOWN);
            } else if (rotation > 180.0 && rotation <= 270.0) {
                newStaticText.setRotation(RotationEnum.LEFT);
            }
        }
        newStaticText.setWidth(10000);
        newStaticText.setHeight(10000);
        newStaticText.setText(text);
        JRMeasuredText measuredText = this.getTextSize(newStaticText);
        int width = (int)Math.ceil(measuredText.getTextWidth() + 1.0f);
        int height = (int)Math.ceil(measuredText.getTextHeight() + 1.0f);
        if (newStaticText.getRotationValue() == RotationEnum.LEFT || newStaticText.getRotationValue() == RotationEnum.RIGHT) {
            newStaticText.setHeight(width);
            newStaticText.setWidth(height);
            newStaticText.setY(y);
            newStaticText.setX(x - newStaticText.getWidth() + 1);
        } else {
            newStaticText.setHeight(height);
            newStaticText.setWidth(width);
            newStaticText.setY(y - newStaticText.getHeight() + 1);
            newStaticText.setX(x);
        }
        return newStaticText;
    }

    public List<JRDesignStaticText> parseSpan(SVGOMTSpanElement textNode, SVGRect textBoundingBox, AffineTransform previousTransform) {
        NodeList nodes = textNode.getChildNodes();
        AffineTransform newTransform = this.getTransofrm((SVGOMElement)textNode);
        previousTransform.concatenate(newTransform);
        ArrayList<JRDesignStaticText> result = new ArrayList<JRDesignStaticText>();
        CSSStyleDeclaration textNodeStyle = ((SVGSVGElement)this.svgDocument.getDocumentElement()).getComputedStyle((Element)textNode, null);
        int i = 0;
        while (i < nodes.getLength()) {
            String text;
            Node node = nodes.item(i);
            if (node instanceof GenericText && (text = node.getNodeValue()) != null) {
                double x = this.parseCoordinates(textNode.getAttribute("x"));
                double y = this.parseCoordinates(textNode.getAttribute("y"));
                Point2D.Double point = new Point2D.Double(x, y);
                Point2D coordinates = previousTransform.transform(point, null);
                List<Double> xList = this.parseCoordinatesList(textNode.getAttribute("x"));
                JRDesignStaticText jrText = this.generateText(text, textNodeStyle, (int)coordinates.getX(), (int)coordinates.getY(), xList, textBoundingBox, previousTransform);
                if (jrText != null) {
                    result.add(jrText);
                }
            }
            ++i;
        }
        return result;
    }

    public List<JRDesignStaticText> parseText(SVGOMTextElement textNode, AffineTransform previousTransform) {
        NodeList nodes = textNode.getChildNodes();
        AffineTransform newTransform = this.getTransofrm((SVGOMElement)textNode);
        previousTransform.concatenate(newTransform);
        ArrayList<JRDesignStaticText> result = new ArrayList<JRDesignStaticText>();
        SVGRect boundingBox = textNode.getBBox();
        CSSStyleDeclaration textNodeStyle = ((SVGSVGElement)this.svgDocument.getDocumentElement()).getComputedStyle((Element)textNode, null);
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof GenericText) {
                double y;
                double x;
                Point2D.Double point;
                Point2D coordinates;
                JRDesignStaticText jrText;
                String text = node.getNodeValue();
                if (text != null && (jrText = this.generateText(text, textNodeStyle, (int)(coordinates = previousTransform.transform(point = new Point2D.Double(x = this.parseCoordinates(textNode.getAttribute("x")), y = this.parseCoordinates(textNode.getAttribute("y"))), null)).getX(), (int)coordinates.getY(), null, boundingBox, previousTransform)) != null) {
                    result.add(jrText);
                }
            } else if (node instanceof SVGOMTSpanElement) {
                result.addAll(this.parseSpan((SVGOMTSpanElement)node, boundingBox, new AffineTransform(previousTransform)));
            }
            ++i;
        }
        return result;
    }

    private JRDesignRectangle parseRectangle(SVGOMRectElement rect, AffineTransform previousTransform) {
        AffineTransform newTransform = this.getTransofrm((SVGOMElement)rect);
        previousTransform.concatenate(newTransform);
        double x = this.parseCoordinates(rect.getAttribute("x"));
        double y = this.parseCoordinates(rect.getAttribute("y"));
        double width = Double.parseDouble(rect.getAttribute("width"));
        double height = Double.parseDouble(rect.getAttribute("height"));
        Rectangle2D rectFigure = new Rectangle2D.Double(x, y, width, height);
        rectFigure = previousTransform.createTransformedShape(rectFigure).getBounds2D();
        JRDesignRectangle rectangle = new JRDesignRectangle();
        rectangle.setX((int)rectFigure.getX());
        rectangle.setY((int)rectFigure.getY());
        rectangle.setWidth((int)rectFigure.getWidth());
        rectangle.setHeight((int)rectFigure.getHeight());
        CSSStyleDeclaration nodeStyle = ((SVGSVGElement)this.svgDocument.getDocumentElement()).getComputedStyle((Element)rect, null);
        Color backgroundColor = this.getColor(nodeStyle, "fill");
        if (backgroundColor != null) {
            rectangle.setBackcolor(backgroundColor);
        }
        Float strokeWidth = Float.valueOf(this.getStrokeWidth(nodeStyle));
        rectangle.getLinePen().setLineWidth(strokeWidth);
        Color strokeColor = this.getColor(nodeStyle, "stroke");
        if (strokeColor != null) {
            rectangle.getLinePen().setLineColor(strokeColor);
        }
        return rectangle;
    }

    private List<BufferedImage> parseMask(SVGOMMaskElement maskElement) {
        String maskId = maskElement.getAttribute("id");
        List<BufferedImage> result = this.masks.get(maskId);
        if (result == null) {
            result = new ArrayList<BufferedImage>();
            NodeList nodes = maskElement.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node instanceof SVGOMMaskElement) {
                    result.addAll(this.parseMask((SVGOMMaskElement)node));
                } else if (node instanceof SVGOMImageElement) {
                    SVGOMImageElement imageElement = (SVGOMImageElement)node;
                    String sourceData = imageElement.getAttributeNS("http://www.w3.org/1999/xlink", "href");
                    String[] splitData = sourceData.split(",");
                    BufferedImage maskImage = this.decodeImage(imageElement, splitData[1].getBytes());
                    if (maskElement != null) {
                        result.add(maskImage);
                    }
                }
                ++i;
            }
            this.masks.put(maskId, result);
        }
        return result;
    }

    private BufferedImage decodeImage(SVGOMImageElement imageElement, byte[] imageBytesArray) {
        ByteArrayInputStream imageBytes = new ByteArrayInputStream(imageBytesArray);
        Base64DecodeStream decodeStream = new Base64DecodeStream((InputStream)imageBytes);
        try {
            Element maskElement;
            BufferedImage image = ImageIO.read((InputStream)decodeStream);
            String maskRef = imageElement.getAttribute("mask");
            if (maskRef != null && maskRef.startsWith("url(") && maskRef.endsWith(")") && (maskRef = maskRef.substring(4, maskRef.length() - 1)).startsWith("#") && (maskElement = this.svgDocument.getElementById(maskRef = maskRef.substring(1))) != null && maskElement instanceof SVGOMMaskElement) {
                List<BufferedImage> masks = this.parseMask((SVGOMMaskElement)maskElement);
                for (BufferedImage mask : masks) {
                    int width = image.getWidth();
                    int[] imgData = new int[width];
                    int[] maskData = new int[width];
                    int y = 0;
                    while (y < image.getHeight()) {
                        image.getRGB(0, y, width, 1, imgData, 0, 1);
                        mask.getRGB(0, y, width, 1, maskData, 0, 1);
                        int x = 0;
                        while (x < width) {
                            int color = imgData[x] & 0xFFFFFF;
                            int maskColor = (maskData[x] & 0xFF0000) << 8;
                            imgData[x] = color |= maskColor;
                            ++x;
                        }
                        image.setRGB(0, y, width, 1, imgData, 0, 1);
                        ++y;
                    }
                }
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            FileUtils.closeStream((Closeable)decodeStream);
            FileUtils.closeStream((Closeable)imageBytes);
        }
        return null;
    }

    private File getFileName(String extension) {
        File destFile;
        int counter = 1;
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        do {
            String filename = IMPORTED_IMAGE_PREFIX + counter + "." + extension;
            destFile = new File(tempDir, filename);
            ++counter;
        } while (destFile.exists());
        return destFile;
    }

    private JRDesignImage parseImage(SVGOMImageElement imageElement, AffineTransform previousTransform) {
        AffineTransform newTransofrm = this.getTransofrm((SVGOMElement)imageElement);
        previousTransform.concatenate(newTransofrm);
        double x = this.parseCoordinates(imageElement.getAttribute("x"));
        double y = this.parseCoordinates(imageElement.getAttribute("y"));
        double width = Double.parseDouble(imageElement.getAttribute("width"));
        double height = Double.parseDouble(imageElement.getAttribute("height"));
        Rectangle2D rectFigure = new Rectangle2D.Double(x, y, width, height);
        rectFigure = previousTransform.createTransformedShape(rectFigure).getBounds2D();
        JRDesignImage jrImage = new JRDesignImage((JRDefaultStyleProvider)this.jConfig.getJasperDesign());
        jrImage.setX((int)rectFigure.getX());
        jrImage.setY((int)rectFigure.getY());
        jrImage.setWidth((int)rectFigure.getWidth());
        jrImage.setHeight((int)rectFigure.getHeight());
        String sourceData = imageElement.getAttributeNS("http://www.w3.org/1999/xlink", "href");
        String[] splitData = sourceData.split(",");
        String extension = splitData[0].contains("png") ? "png" : (splitData[0].contains("bmp") ? "bmp" : (splitData[0].contains("ico") ? "ico" : "jpg"));
        BufferedImage image = this.decodeImage(imageElement, splitData[1].getBytes());
        if (image != null) {
            File destFile;
            block6: {
                destFile = this.getFileName(extension);
                FileOutputStream outStream = null;
                try {
                    try {
                        outStream = new FileOutputStream(destFile);
                        ImageIO.write((RenderedImage)image, extension, outStream);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        FileUtils.closeStream((Closeable)outStream);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.closeStream(outStream);
                    throw throwable;
                }
                FileUtils.closeStream((Closeable)outStream);
            }
            this.resources.add((Pair<File, JRDesignImage>)new Pair((Object)destFile, (Object)jrImage));
        }
        return jrImage;
    }

    private JRDesignEllipse parseEllipse(SVGOMEllipseElement ellipseElement, AffineTransform previousTransform) {
        JRDesignEllipse result = new JRDesignEllipse((JRDefaultStyleProvider)this.jConfig.getJasperDesign());
        AffineTransform newTransofrm = this.getTransofrm((SVGOMElement)ellipseElement);
        previousTransform.concatenate(newTransofrm);
        double cx = Double.parseDouble(ellipseElement.getAttribute("cx"));
        double cy = Double.parseDouble(ellipseElement.getAttribute("cy"));
        double rx = Double.parseDouble(ellipseElement.getAttribute("rx"));
        double ry = Double.parseDouble(ellipseElement.getAttribute("ry"));
        Ellipse2D.Double ellipseFigure = new Ellipse2D.Double(cx - rx, cy - ry, rx * 2.0, ry * 2.0);
        Rectangle2D rectFigure = previousTransform.createTransformedShape(ellipseFigure).getBounds2D();
        result.setX((int)rectFigure.getX());
        result.setY((int)rectFigure.getY());
        result.setWidth((int)rectFigure.getWidth());
        result.setHeight((int)rectFigure.getHeight());
        CSSStyleDeclaration nodeStyle = ((SVGSVGElement)this.svgDocument.getDocumentElement()).getComputedStyle((Element)ellipseElement, null);
        Color backgroundColor = this.getColor(nodeStyle, "fill");
        if (backgroundColor != null) {
            result.setBackcolor(backgroundColor);
        }
        Float strokeWidth = Float.valueOf(this.getStrokeWidth(nodeStyle));
        result.getLinePen().setLineWidth(strokeWidth);
        Color strokeColor = this.getColor(nodeStyle, "stroke");
        if (strokeColor != null) {
            result.getLinePen().setLineColor(strokeColor);
        }
        return result;
    }

    private File transcodeToSVG(Document doc) {
        File destFile;
        block5: {
            destFile = null;
            FileOutputStream outputStream = null;
            try {
                try {
                    SVGTranscoder t = new SVGTranscoder();
                    TranscoderInput input = new TranscoderInput(doc);
                    ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
                    OutputStreamWriter ostream = new OutputStreamWriter((OutputStream)bytestream, "UTF-8");
                    TranscoderOutput output = new TranscoderOutput((Writer)ostream);
                    t.transcode(input, output);
                    ostream.flush();
                    ostream.close();
                    destFile = this.getFileName("svg");
                    byte[] svgBytes = bytestream.toByteArray();
                    outputStream = new FileOutputStream(destFile);
                    outputStream.write(svgBytes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    FileUtils.closeStream(outputStream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(outputStream);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)outputStream);
        }
        return destFile;
    }

    public static String affineTransformToString(AffineTransform at) {
        double[] matrix = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        at.getMatrix(matrix);
        return SVGDocumentLoader.matrixArrayToString(matrix);
    }

    public static String matrixArrayToString(double[] vals) {
        return "matrix(" + vals[0] + " " + vals[1] + " " + vals[2] + " " + vals[3] + " " + vals[4] + " " + vals[5] + ") ";
    }

    private List<JRDesignElement> exrtractPath(SVGOMPathElement pathElement, AffineTransform previousTransform, Shape awtShape) {
        double xTranslation;
        ArrayList<JRDesignElement> result = new ArrayList<JRDesignElement>();
        Rectangle2D bounds = awtShape.getBounds2D();
        Number stroke = this.parseNumber(pathElement.getAttribute("stroke-width"));
        if (stroke == null) {
            stroke = 0.0;
        }
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        Rectangle2D rectFigure = new Rectangle2D.Double(x, y, width, height);
        rectFigure = previousTransform.createTransformedShape(rectFigure).getBounds2D();
        double imageWidth = rectFigure.getWidth() + stroke.doubleValue();
        double imageHeight = rectFigure.getHeight() + stroke.doubleValue();
        double yTranslation = bounds.getY() * previousTransform.getScaleY();
        if (yTranslation < 0.0 && bounds.getHeight() * previousTransform.getScaleY() < 0.0) {
            yTranslation += bounds.getHeight() * previousTransform.getScaleY();
        }
        if ((xTranslation = bounds.getX() * previousTransform.getScaleX()) < 0.0 && bounds.getWidth() * previousTransform.getScaleX() < 0.0) {
            xTranslation += bounds.getWidth() * previousTransform.getScaleX();
        }
        AffineTransform originTransform = new AffineTransform(previousTransform.getScaleX(), previousTransform.getShearY(), previousTransform.getShearX(), previousTransform.getScaleY(), -xTranslation + stroke.doubleValue() / 2.0, -yTranslation + stroke.doubleValue() / 2.0);
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document doc = impl.createDocument(svgNS, "svg", null);
        Element svgRoot = doc.getDocumentElement();
        svgRoot.setAttribute("width", String.valueOf(imageWidth));
        svgRoot.setAttribute("height", String.valueOf(imageHeight));
        Element group = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        svgRoot.appendChild(group);
        Element copy = (Element)doc.importNode((Node)pathElement, true);
        group.setAttributeNS(null, "transform", SVGDocumentLoader.affineTransformToString(originTransform));
        group.appendChild(copy);
        File destFile = this.transcodeToSVG(doc);
        if (destFile != null) {
            JRDesignImage jrImage = new JRDesignImage((JRDefaultStyleProvider)this.jConfig.getJasperDesign());
            jrImage.setX((int)rectFigure.getX());
            jrImage.setY((int)rectFigure.getY());
            jrImage.setWidth((int)imageWidth);
            jrImage.setHeight((int)imageHeight);
            this.resources.add((Pair<File, JRDesignImage>)new Pair((Object)destFile, (Object)jrImage));
            result.add((JRDesignElement)jrImage);
        }
        return result;
    }

    private boolean isSingleLine(Shape awtShape, AffineTransform transorm) {
        PathIterator iterator = awtShape.getPathIterator(transorm);
        int lines = 0;
        while (!iterator.isDone()) {
            float[] coords = new float[6];
            int segType = iterator.currentSegment(coords);
            if (segType == 3 || segType == 2 || segType == 4) {
                return false;
            }
            if (segType == 1 && ++lines > 1) {
                return false;
            }
            iterator.next();
        }
        return true;
    }

    private List<JRDesignElement> parsePath(SVGOMPathElement pathElement, AffineTransform previousTransform) {
        AffineTransform newTransofrm = this.getTransofrm((SVGOMElement)pathElement);
        previousTransform.concatenate(newTransofrm);
        AWTPathProducer pathProducer = new AWTPathProducer();
        PathParser pathParser = new PathParser();
        pathParser.setPathHandler((PathHandler)pathProducer);
        pathParser.parse(pathElement.getAttribute("d"));
        Shape awtShape = pathProducer.getShape();
        if (this.isSingleLine(awtShape, previousTransform)) {
            ArrayList<JRDesignElement> result = new ArrayList<JRDesignElement>();
            PathIterator iterator = awtShape.getPathIterator(previousTransform);
            float[] lastCoords = null;
            float[] firstCoords = null;
            while (!iterator.isDone()) {
                float[] coords = new float[6];
                int segType = iterator.currentSegment(coords);
                if (lastCoords != null) {
                    int lineHeight;
                    int yLineStart;
                    int lineWdith;
                    int xLineStart;
                    double y2;
                    double x2;
                    JRDesignLine line = new JRDesignLine();
                    double x1 = lastCoords[0];
                    double y1 = lastCoords[1];
                    if (segType == 4) {
                        x2 = firstCoords[0];
                        y2 = firstCoords[1];
                    } else {
                        x2 = coords[0];
                        y2 = coords[1];
                    }
                    LineDirectionEnum direction = null;
                    if (x1 < x2) {
                        xLineStart = (int)Math.round(x1);
                        lineWdith = (int)Math.round(x2 - x1);
                    } else {
                        xLineStart = (int)Math.round(x2);
                        lineWdith = (int)Math.round(x1 - x2);
                    }
                    if (y1 < y2) {
                        yLineStart = (int)Math.round(y1);
                        lineHeight = (int)Math.round(y2 - y1);
                    } else {
                        yLineStart = (int)Math.round(y2);
                        lineHeight = (int)Math.round(y1 - y2);
                        direction = LineDirectionEnum.BOTTOM_UP;
                    }
                    line.setX(xLineStart);
                    line.setY(yLineStart);
                    line.setWidth(lineWdith);
                    line.setHeight(lineHeight);
                    line.setDirection(direction);
                    result.add((JRDesignElement)line);
                }
                lastCoords = coords;
                if (firstCoords == null) {
                    firstCoords = coords;
                }
                iterator.next();
            }
            return result;
        }
        return this.exrtractPath(pathElement, previousTransform, awtShape);
    }

    private List<JRDesignElement> parseElement(SVGOMElement element, AffineTransform previousTransform) {
        ArrayList<JRDesignElement> result = new ArrayList<JRDesignElement>();
        if (element instanceof SVGOMTextElement) {
            List<JRDesignStaticText> texts = this.parseText((SVGOMTextElement)element, new AffineTransform(previousTransform));
            result.addAll(texts);
        } else if (element instanceof SVGOMRectElement) {
            JRDesignRectangle rect = this.parseRectangle((SVGOMRectElement)element, new AffineTransform(previousTransform));
            if (rect != null) {
                result.add((JRDesignElement)rect);
            }
        } else if (element instanceof SVGOMGElement) {
            result.addAll(this.parseGroup((SVGOMGElement)element, new AffineTransform(previousTransform)));
        } else if (element instanceof SVGOMImageElement) {
            SVGOMImageElement imageNode = (SVGOMImageElement)element;
            JRDesignImage image = this.parseImage(imageNode, new AffineTransform(previousTransform));
            if (image != null) {
                result.add((JRDesignElement)image);
            }
        } else if (element instanceof SVGOMEllipseElement) {
            SVGOMEllipseElement ellipseNode = (SVGOMEllipseElement)element;
            JRDesignEllipse ellipse = this.parseEllipse(ellipseNode, new AffineTransform(previousTransform));
            if (ellipse != null) {
                result.add((JRDesignElement)ellipse);
            }
        } else if (element instanceof SVGOMPathElement) {
            List<JRDesignElement> lines = this.parsePath((SVGOMPathElement)element, new AffineTransform(previousTransform));
            result.addAll(lines);
        } else {
            System.out.println("SVG element " + element.toString() + " not supported");
            JaspersoftStudioPlugin.getInstance().logWarning("SVG element " + element.toString() + " not supported");
        }
        return result;
    }

    public List<JRDesignElement> parseGroup(SVGOMGElement group, AffineTransform previousTransofrm) {
        AffineTransform newTransform = this.getTransofrm((SVGOMElement)group);
        previousTransofrm.concatenate(newTransform);
        NodeList nodes = group.getChildNodes();
        ArrayList<JRDesignElement> result = new ArrayList<JRDesignElement>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof SVGOMElement) {
                result.addAll(this.parseElement((SVGOMElement)node, previousTransofrm));
            }
            ++i;
        }
        return result;
    }

    public List<JRDesignElement> getJRElements() {
        this.resources.clear();
        SVGOMSVGElement rootElement = this.getSVGDocumentRoot();
        NodeList nodes = rootElement.getChildNodes();
        AffineTransform startingStransform = new AffineTransform();
        ArrayList<JRDesignElement> result = new ArrayList<JRDesignElement>();
        this.masks.clear();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof SVGOMGElement) {
                result.addAll(this.parseElement((SVGOMElement)((SVGOMGElement)node), startingStransform));
            } else if (node instanceof SVGOMPathElement) {
                result.addAll(this.parseElement((SVGOMElement)((SVGOMPathElement)node), startingStransform));
            }
            ++i;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        for (JRDesignElement element : result) {
            if (element.getX() < minX) {
                minX = element.getX();
            }
            if (element.getY() >= minY) continue;
            minY = element.getY();
        }
        for (JRDesignElement element : result) {
            element.setX(element.getX() - minX);
            element.setY(element.getY() - minY);
        }
        return result;
    }

    public Command getResourceCreationCommands() {
        CompoundCommand result = new CompoundCommand();
        for (Pair<File, JRDesignImage> resource : this.resources) {
            CreateResourceCommand resourceCommand = new CreateResourceCommand((File)resource.getKey(), (JRDesignImage)resource.getValue(), this.jConfig);
            result.add((Command)resourceCommand);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    private SVGOMSVGElement getSVGDocumentRoot() {
        return (SVGOMSVGElement)this.getSVGDocument().getDocumentElement();
    }

    public void setSVGDocument(Document document) {
        this.initSVGDOM(document);
        this.svgDocument = document;
    }

    public Document getSVGDocument() {
        return this.svgDocument;
    }

    private void initSVGDOM(Document document) {
        UserAgentAdapter userAgent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
        BridgeContext bridgeContext = new BridgeContext((UserAgent)userAgent, loader);
        bridgeContext.setDynamicState(2);
        new GVTBuilder().build(bridgeContext, document);
    }

    private Document createSVGDocument(String uri) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        InkscapeSVGDocumentFactory factory = new InkscapeSVGDocumentFactory(parser);
        return factory.createDocument(uri);
    }
}

